/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import com.ibm.icu.text.MessageFormat;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCDistinctUDT;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCStructuredUDT;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.Messages;
import org.eclipse.datatools.connectivity.sqm.loader.SchemaObjectFilterProvider;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataTypesPackage;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.ecore.EClass;

public class JDBCUserDefinedTypeLoader
extends JDBCBaseLoader {
    public static final String COLUMN_TYPE_NAME = "TYPE_NAME";
    public static final String COLUMN_CLASS_NAME = "CLASS_NAME";
    public static final String COLUMN_DATA_TYPE = "DATA_TYPE";
    public static final String COLUMN_REMARKS = "REMARKS";
    public static final String COLUMN_BASE_TYPE = "BASE_TYPE";
    private IUDTFactory mDistinctTypeFactory;
    private IUDTFactory mJavaTypeFactory;
    private IUDTFactory mStructTypeFactory;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.sqm.loader.JDBCUserDefinedTypeLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public JDBCUserDefinedTypeLoader(ICatalogObject catalogObject) {
        this(catalogObject, new SchemaObjectFilterProvider("DatatoolsUDTFilterPredicate"));
    }

    public JDBCUserDefinedTypeLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        this(catalogObject, connectionFilterProvider, new DistinctTypeFactory(RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(catalogObject.getCatalogDatabase())), new StructTypeFactory(), null);
    }

    public JDBCUserDefinedTypeLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider, IUDTFactory distinctTypeFactory, IUDTFactory structTypeFactory, IUDTFactory javaTypeFactory) {
        super(catalogObject, connectionFilterProvider);
        if (!$assertionsDisabled && !(catalogObject instanceof Schema)) {
            throw new AssertionError();
        }
        this.mDistinctTypeFactory = distinctTypeFactory;
        this.mJavaTypeFactory = javaTypeFactory;
        this.mStructTypeFactory = structTypeFactory;
    }

    public List loadUDTs() throws SQLException {
        ArrayList retVal = new ArrayList();
        this.loadUDTs(retVal, Collections.EMPTY_SET);
        return retVal;
    }

    /*
     * Exception decompiling
     */
    public void loadUDTs(List containmentList, Collection existingUDTs) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 219->223)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void clearUDTs(List existingUDTs) {
        existingUDTs.clear();
    }

    protected ResultSet createResultSet() throws SQLException {
        try {
            Schema schema = this.getSchema();
            return this.getCatalogObject().getConnection().getMetaData().getUDTs(schema.getCatalog().getName(), schema.getName(), this.getJDBCFilterPattern(), null);
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getUDTs()"}));
            error.initCause(e);
            throw error;
        }
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {}
    }

    protected UserDefinedType processRow(ResultSet rs) throws SQLException {
        IUDTFactory udtFactory = null;
        switch (rs.getInt(COLUMN_DATA_TYPE)) {
            case 2000: {
                udtFactory = this.mJavaTypeFactory;
                break;
            }
            case 2002: {
                udtFactory = this.mStructTypeFactory;
                break;
            }
            case 2001: {
                udtFactory = this.mDistinctTypeFactory;
            }
        }
        if (udtFactory == null) {
            return null;
        }
        return udtFactory.createUDT(rs);
    }

    protected Schema getSchema() {
        return (Schema)this.getCatalogObject();
    }

    public static class DistinctTypeFactory
    extends StructTypeFactory {
        private DatabaseDefinition mDatabaseDefinition;

        public DistinctTypeFactory(DatabaseDefinition databaseDefinition) {
            this.mDatabaseDefinition = databaseDefinition;
        }

        public EClass getUDTEClass() {
            return SQLDataTypesPackage.eINSTANCE.getDistinctUserDefinedType();
        }

        protected UserDefinedType newUDT() {
            return new JDBCDistinctUDT();
        }

        protected DatabaseDefinition getDatabaseDefinition() {
            return this.mDatabaseDefinition;
        }

        public void initialize(UserDefinedType udt, ResultSet rs) throws SQLException {
            super.initialize(udt, rs);
            List preDefinedTypes = this.getDatabaseDefinition().getPredefinedDataTypesByJDBCEnumType(rs.getShort(JDBCUserDefinedTypeLoader.COLUMN_BASE_TYPE));
            if (preDefinedTypes.size() > 0) {
                ((DistinctUserDefinedType)udt).setPredefinedRepresentation((PredefinedDataType)preDefinedTypes.get(0));
            }
        }
    }

    public static interface IUDTFactory {
        public EClass getUDTEClass();

        public UserDefinedType createUDT(ResultSet var1) throws SQLException;

        public void initialize(UserDefinedType var1, ResultSet var2) throws SQLException;
    }

    public static class StructTypeFactory
    implements IUDTFactory {
        public EClass getUDTEClass() {
            return SQLDataTypesPackage.eINSTANCE.getStructuredUserDefinedType();
        }

        public UserDefinedType createUDT(ResultSet rs) throws SQLException {
            UserDefinedType retVal = this.newUDT();
            this.initialize(retVal, rs);
            return retVal;
        }

        protected UserDefinedType newUDT() {
            return new JDBCStructuredUDT();
        }

        public void initialize(UserDefinedType udt, ResultSet rs) throws SQLException {
            udt.setName(rs.getString(JDBCUserDefinedTypeLoader.COLUMN_TYPE_NAME));
            udt.setDescription(rs.getString(JDBCUserDefinedTypeLoader.COLUMN_REMARKS));
        }
    }
}

