/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.datafeed;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.datafeed.IDataPointEntry;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;

public final class StockEntry
implements IDataPointEntry {
    private double dOpen;
    private double dLow;
    private double dHigh;
    private double dClose;

    public StockEntry(double dOpen, double dLow, double dHigh, double dClose) {
        this.dOpen = dOpen;
        this.dLow = dLow;
        this.dHigh = dHigh;
        this.dClose = dClose;
    }

    public StockEntry(Object[] oaFourComponents) {
        assert (oaFourComponents.length == 4);
        this.dHigh = oaFourComponents[0] instanceof Number ? ((Number)oaFourComponents[0]).doubleValue() : Double.NaN;
        this.dLow = oaFourComponents[1] instanceof Number ? ((Number)oaFourComponents[1]).doubleValue() : Double.NaN;
        this.dOpen = oaFourComponents[2] instanceof Number ? ((Number)oaFourComponents[2]).doubleValue() : Double.NaN;
        this.dClose = oaFourComponents[3] instanceof Number ? ((Number)oaFourComponents[3]).doubleValue() : Double.NaN;
    }

    public String toString() {
        return "H" + this.dHigh + " L" + this.dLow + " O" + this.dOpen + " C" + this.dClose;
    }

    public final double getClose() {
        return this.dClose;
    }

    public final void setClose(double close) {
        this.dClose = close;
    }

    public final double getHigh() {
        return this.dHigh;
    }

    public final void setHigh(double high) {
        this.dHigh = high;
    }

    public final double getLow() {
        return this.dLow;
    }

    public final void setLow(double low) {
        this.dLow = low;
    }

    public final double getOpen() {
        return this.dOpen;
    }

    public final void setOpen(double open) {
        this.dOpen = open;
    }

    public String getFormattedString(String type, FormatSpecifier formatter, ULocale locale) {
        String str = null;
        try {
            if ("stock_high".equals(type)) {
                str = ValueFormatter.format((Object)new Double(this.dHigh), (FormatSpecifier)formatter, (ULocale)locale, null);
            } else if ("stock_low".equals(type)) {
                str = ValueFormatter.format((Object)new Double(this.dLow), (FormatSpecifier)formatter, (ULocale)locale, null);
            } else if ("stock_open".equals(type)) {
                str = ValueFormatter.format((Object)new Double(this.dOpen), (FormatSpecifier)formatter, (ULocale)locale, null);
            } else if ("stock_close".equals(type)) {
                str = ValueFormatter.format((Object)new Double(this.dClose), (FormatSpecifier)formatter, (ULocale)locale, null);
            }
        }
        catch (ChartException e) {
            Logger.getLogger((String)"org.eclipse.birt.chart.engine/exception").log((Exception)((Object)e));
        }
        return str;
    }

    public String getFormattedString(Object formatter, ULocale locale) {
        return this.toString();
    }
}

