/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.group;

import java.util.Date;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.group.DateGroupCalculator;
import org.eclipse.birt.report.data.adapter.group.DateTimeUtil;

class DayGroupCalculator
extends DateGroupCalculator {
    public DayGroupCalculator(Object intervalStart, double intervalRange) throws BirtException {
        super(intervalStart, intervalRange);
    }

    public Object calculate(Object value) {
        if (value == null) {
            return new Double(-1.0);
        }
        if (this.intervalStart == null) {
            return new Double(Math.floor(DateTimeUtil.diffDay(defaultStart, (Date)value) / (long)this.getDateIntervalRange()));
        }
        if (DateTimeUtil.diffDay((Date)this.intervalStart, (Date)value) < 0L) {
            return new Double(-1.0);
        }
        return new Double(Math.floor(DateTimeUtil.diffDay((Date)this.intervalStart, (Date)value) / (long)this.getDateIntervalRange()));
    }
}

