/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ISubCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.cube.CubeElementFactory;
import org.eclipse.birt.data.engine.olap.data.api.cube.CubeMaterializer;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IColumnValueIterator;
import org.eclipse.birt.report.data.adapter.api.ICubeQueryUtil;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.api.IQueryDefinitionUtil;
import org.eclipse.birt.report.data.adapter.api.IRequestInfo;
import org.eclipse.birt.report.data.adapter.group.GroupCalculatorFactory;
import org.eclipse.birt.report.data.adapter.impl.ColumnValueIterator;
import org.eclipse.birt.report.data.adapter.impl.CubeQueryUtil;
import org.eclipse.birt.report.data.adapter.impl.DataSetIterator;
import org.eclipse.birt.report.data.adapter.impl.DataSetMetaDataHelper;
import org.eclipse.birt.report.data.adapter.impl.ModelAdapter;
import org.eclipse.birt.report.data.adapter.impl.QueryDefinitionUtil;
import org.eclipse.birt.report.data.adapter.impl.QueryExecutionHelper;
import org.eclipse.birt.report.data.adapter.internal.adapter.GroupAdapter;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionConditionHandle;
import org.eclipse.birt.report.model.api.DimensionJoinConditionHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.RuleHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRequestSessionImpl
extends DataRequestSession {
    private DataEngineImpl dataEngine;
    private IModelAdapter modelAdaptor;
    private DataSessionContext sessionContext;
    private Map cubeHandleMap;
    private StopSign stopSign;

    public DataRequestSessionImpl(DataSessionContext context) throws BirtException {
        if (context == null) {
            throw new AdapterException("context.null.error");
        }
        this.dataEngine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context.getDataEngineContext());
        this.modelAdaptor = new ModelAdapter(context);
        this.sessionContext = context;
        this.cubeHandleMap = new HashMap();
        this.stopSign = new StopSign();
        if (this.sessionContext != null) {
            this.setModuleHandleToAppContext();
        }
    }

    @Override
    public void defineDataSource(IBaseDataSourceDesign design) throws BirtException {
        this.dataEngine.defineDataSource(design);
    }

    @Override
    public void defineDataSet(IBaseDataSetDesign design) throws BirtException {
        this.dataEngine.defineDataSet(design);
    }

    @Override
    public IResultMetaData getDataSetMetaData(String dataSetName, boolean useCache) throws BirtException {
        return this.getDataSetMetaData(this.sessionContext.getModuleHandle().findDataSet(dataSetName), useCache);
    }

    @Override
    public IResultMetaData getDataSetMetaData(DataSetHandle dataSetHandle, boolean useCache) throws BirtException {
        return new DataSetMetaDataHelper((DataEngine)this.dataEngine, this.modelAdaptor, this.sessionContext).getDataSetMetaData(dataSetHandle, useCache);
    }

    @Override
    public Collection getColumnValueSet(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName) throws BirtException {
        return this.getColumnValueSet(dataSet, inputParamBindings, columnBindings, boundColumnName, null);
    }

    @Override
    public IColumnValueIterator getColumnValueIterator(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName) throws BirtException {
        return this.getColumnValueIterator(dataSet, inputParamBindings, columnBindings, boundColumnName, null);
    }

    private IColumnValueIterator getColumnValueIterator(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName, IRequestInfo requestInfo) throws BirtException {
        ArrayList temp = new ArrayList();
        while (columnBindings != null && columnBindings.hasNext()) {
            temp.add(columnBindings.next());
        }
        IQueryResults queryResults = this.getQueryResults(dataSet, inputParamBindings, temp.iterator(), boundColumnName);
        return new ColumnValueIterator(queryResults, boundColumnName, requestInfo);
    }

    @Override
    public Collection getColumnValueSet(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName, IRequestInfo requestInfo) throws BirtException {
        IColumnValueIterator columnValueIterator = this.getColumnValueIterator(dataSet, inputParamBindings, columnBindings, boundColumnName, requestInfo);
        ArrayList<Object> values = new ArrayList<Object>();
        do {
            if (columnValueIterator.getValue() == null) continue;
            values.add(columnValueIterator.getValue());
        } while (columnValueIterator.next());
        columnValueIterator.close();
        return values;
    }

    @Override
    public IResultMetaData refreshMetaData(DataSetHandle dataSetHandle) throws BirtException {
        return new DataSetMetaDataHelper((DataEngine)this.dataEngine, this.modelAdaptor, this.sessionContext).refreshMetaData(dataSetHandle);
    }

    @Override
    public IResultMetaData refreshMetaData(DataSetHandle dataSetHandle, boolean holdEvent) throws BirtException {
        return new DataSetMetaDataHelper((DataEngine)this.dataEngine, this.modelAdaptor, this.sessionContext).refreshMetaData(dataSetHandle, holdEvent);
    }

    @Override
    public IQueryResults executeQuery(IQueryDefinition queryDefn, Iterator paramBindingIt, Iterator filterIt, Iterator bindingIt) throws BirtException {
        return new QueryExecutionHelper((DataEngine)this.dataEngine, this.modelAdaptor, this.sessionContext).executeQuery(queryDefn, paramBindingIt, filterIt, bindingIt, this.sessionContext.getTopScope());
    }

    @Override
    public IQueryResults getQueryResults(String queryResultID) throws BirtException {
        return this.dataEngine.getQueryResults(queryResultID);
    }

    @Override
    public void clearCache(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        this.dataEngine.clearCache(dataSource, dataSet);
    }

    @Override
    public IPreparedQuery prepare(IQueryDefinition query, Map appContext) throws BirtException {
        this.defineDataSourceDataSet(query);
        if (appContext == null) {
            appContext = this.sessionContext.getAppContext();
        }
        this.setModuleHandleToAppContext(appContext);
        return this.dataEngine.prepare(query, appContext);
    }

    @Override
    public IPreparedQuery prepare(IQueryDefinition query) throws BirtException {
        return this.prepare(query, null);
    }

    @Override
    public void closeDataSource(String dataSourceName) throws BirtException {
        this.dataEngine.closeDataSource(dataSourceName);
    }

    @Override
    public IModelAdapter getModelAdaptor() {
        return this.modelAdaptor;
    }

    @Override
    public void shutdown() {
        this.dataEngine.shutdown();
        this.dataEngine = null;
    }

    private IQueryResults getQueryResults(DataSetHandle dataSet, Iterator inputParamBindings, Iterator columnBindings, String boundColumnName) throws BirtException {
        ModuleHandle moduleHandle;
        assert (dataSet != null);
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName(dataSet.getQualifiedName());
        boolean useDataSetFilter = true;
        if (columnBindings == null || !columnBindings.hasNext()) {
            query.setAutoBinding(true);
            useDataSetFilter = false;
        }
        if ((moduleHandle = this.sessionContext.getModuleHandle()) == null) {
            moduleHandle = dataSet.getModuleHandle();
        }
        QueryExecutionHelper execHelper = new QueryExecutionHelper((DataEngine)this.dataEngine, this.modelAdaptor, this.sessionContext);
        IQueryResults results = execHelper.executeQuery((IQueryDefinition)query, inputParamBindings, null, columnBindings, useDataSetFilter, false, this.sessionContext.getTopScope());
        return results;
    }

    private boolean referToAggregation(List bindings, String boundColumnName) throws BirtException {
        if (boundColumnName == null) {
            return true;
        }
        Iterator columnBindings = bindings.iterator();
        while (columnBindings != null && columnBindings.hasNext()) {
            ComputedColumn column = this.modelAdaptor.adaptComputedColumn((ComputedColumnHandle)columnBindings.next());
            if (!column.getName().equals(boundColumnName)) continue;
            ScriptExpression sxp = (ScriptExpression)column.getExpression();
            if (column.getAggregateFunction() != null || ExpressionUtil.hasAggregation((String)sxp.getText())) {
                return true;
            }
            for (IColumnBinding columnBinding : ExpressionUtil.extractColumnExpressions((String)sxp.getText())) {
                if (!this.referToAggregation(bindings, columnBinding.getResultSetColumnName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IBaseQueryResults execute(IBasePreparedQuery query, IBaseQueryResults outerResults, Scriptable scope) throws AdapterException {
        try {
            if (query instanceof IPreparedQuery) {
                return ((IPreparedQuery)query).execute(outerResults, scope);
            }
            if (query instanceof IPreparedCubeQuery) {
                return ((IPreparedCubeQuery)query).execute(outerResults, scope);
            }
            return null;
        }
        catch (BirtException e) {
            throw new AdapterException("exception.error", e);
        }
    }

    @Override
    public IBasePreparedQuery prepare(IDataQueryDefinition query, Map appContext) throws AdapterException {
        try {
            this.setModuleHandleToAppContext(appContext);
            if (query instanceof IQueryDefinition) {
                return this.prepare((IQueryDefinition)query, appContext == null ? this.sessionContext.getAppContext() : appContext);
            }
            if (query instanceof ICubeQueryDefinition) {
                return this.prepare((ICubeQueryDefinition)query, appContext == null ? this.sessionContext.getAppContext() : appContext);
            }
            if (query instanceof ISubCubeQueryDefinition) {
                return this.prepare((ISubCubeQueryDefinition)query, appContext == null ? this.sessionContext.getAppContext() : appContext);
            }
            return null;
        }
        catch (BirtException e) {
            throw new AdapterException("exception.error", e);
        }
    }

    @Override
    public void defineCube(CubeHandle cubeHandle) throws BirtException {
        Set involvedDataSets = this.getInvolvedDataSets((TabularCubeHandle)cubeHandle);
        for (DataSetHandle dsHandle : involvedDataSets) {
            BaseDataSourceDesign baseDataSource = this.modelAdaptor.adaptDataSource(dsHandle.getDataSource());
            BaseDataSetDesign baseDataSet = this.modelAdaptor.adaptDataSet(dsHandle);
            if (baseDataSource != null && this.dataEngine.getDataSourceRuntime(baseDataSource.getName()) == null) {
                this.defineDataSource((IBaseDataSourceDesign)baseDataSource);
            }
            if (this.dataEngine.getDataSetDesign(baseDataSet.getName()) != null) continue;
            this.defineDataSet((IBaseDataSetDesign)baseDataSet);
        }
        if (!this.cubeHandleMap.containsKey(cubeHandle.getQualifiedName())) {
            this.cubeHandleMap.put(cubeHandle.getQualifiedName(), cubeHandle);
        }
    }

    private void materializeCube(CubeHandle cubeHandle, Map appContext) throws BirtException {
        int mode = this.sessionContext.getDataEngineContext().getMode();
        try {
            CubeMaterializer cubeMaterializer = null;
            if (appContext == null) {
                appContext = this.sessionContext.getAppContext();
            }
            if (mode == 3) {
                Integer value;
                int size = 0;
                if (appContext != null && (value = DataTypeUtil.toInteger(appContext.get(DataEngine.IN_MEMORY_CUBE_SIZE))) != null && value > 0) {
                    size = value;
                }
                cubeMaterializer = this.createCubeMaterializer(cubeHandle, size);
                this.createCube((TabularCubeHandle)cubeHandle, cubeMaterializer, appContext);
                cubeMaterializer.close();
            } else if (mode == 1) {
                cubeMaterializer = this.createCubeMaterializer(cubeHandle, 0);
                this.createCube((TabularCubeHandle)cubeHandle, cubeMaterializer, appContext);
                cubeMaterializer.saveCubeToReportDocument(cubeHandle.getQualifiedName(), this.sessionContext.getDocumentWriter(), null);
                cubeMaterializer.close();
            }
        }
        catch (Exception e) {
            throw new DataException("exception.error", (Throwable)e);
        }
    }

    private CubeMaterializer createCubeMaterializer(CubeHandle cubeHandle, int size) throws DataException, IOException, BirtException {
        CubeMaterializer cubeMaterializer = new CubeMaterializer(this.dataEngine, cubeHandle.getQualifiedName(), size);
        return cubeMaterializer;
    }

    private void createCube(TabularCubeHandle cubeHandle, CubeMaterializer cubeMaterializer, Map appContext) throws IOException, BirtException, DataException {
        HashMap backupAppContext = new HashMap();
        if (appContext == null) {
            appContext = new HashMap();
        }
        backupAppContext.putAll(appContext);
        HashMap<ReportElementHandle, IQueryDefinition> queryMap = new HashMap<ReportElementHandle, IQueryDefinition>();
        HashMap<ReportElementHandle, List<DataSetIterator.ColumnMeta>> metaMap = new HashMap<ReportElementHandle, List<DataSetIterator.ColumnMeta>>();
        this.prepareForCubeGeneration(cubeHandle, queryMap, metaMap);
        ArrayList<String> measureNames = new ArrayList<String>();
        List measureGroups = cubeHandle.getContents("measureGroups");
        int i = 0;
        while (i < measureGroups.size()) {
            MeasureGroupHandle mgh = (MeasureGroupHandle)measureGroups.get(i);
            List measures = mgh.getContents("measures");
            int j = 0;
            while (j < measures.size()) {
                MeasureHandle measure = (MeasureHandle)measures.get(j);
                measureNames.add(measure.getName());
                ++j;
            }
            ++i;
        }
        IDimension[] dimensions = this.populateDimensions(cubeMaterializer, cubeHandle, appContext, queryMap, metaMap);
        String[][] factTableKey = new String[dimensions.length][];
        String[][] dimensionKey = new String[dimensions.length][];
        int i2 = 0;
        while (i2 < dimensions.length) {
            TabularDimensionHandle dim = (TabularDimensionHandle)cubeHandle.getDimension(dimensions[i2].getName());
            TabularHierarchyHandle hier = (TabularHierarchyHandle)dim.getDefaultHierarchy();
            if (cubeHandle.getDataSet().equals(hier.getDataSet()) || hier.getDataSet() == null) {
                String[] keyNames = dimensions[i2].getHierarchy().getLevels()[dimensions[i2].getHierarchy().getLevels().length - 1].getKeyNames();
                int j = 0;
                while (j < keyNames.length) {
                    keyNames[j] = String.valueOf(dimensions[i2].getName()) + "/" + keyNames[j];
                    ++j;
                }
                factTableKey[i2] = keyNames;
                dimensionKey[i2] = factTableKey[i2];
            } else {
                Iterator it = cubeHandle.joinConditionsIterator();
                if (!it.hasNext()) {
                    throw new AdapterException("missing.join.condition", dim.getName());
                }
                boolean foundJoinCondition = false;
                while (it.hasNext()) {
                    DimensionConditionHandle dimCondHandle = (DimensionConditionHandle)it.next();
                    if (!dimCondHandle.getHierarchy().getName().equals(hier.getName())) continue;
                    Iterator conditionIt = dimCondHandle.getJoinConditions().iterator();
                    ArrayList<String> dimensionKeys = new ArrayList<String>();
                    ArrayList<String> factTableKeys = new ArrayList<String>();
                    while (conditionIt.hasNext()) {
                        foundJoinCondition = true;
                        DimensionJoinConditionHandle joinCondition = (DimensionJoinConditionHandle)conditionIt.next();
                        String levelName = joinCondition.getLevelName();
                        if (levelName != null && this.isAttribute(dimensions[i2], levelName, joinCondition.getHierarchyKey())) {
                            dimensionKeys.add(OlapExpressionUtil.getAttributeColumnName((String)this.getLevelName(dimensions[i2], levelName), (String)joinCondition.getHierarchyKey()));
                        } else {
                            dimensionKeys.add(joinCondition.getHierarchyKey());
                        }
                        factTableKeys.add(OlapExpressionUtil.getQualifiedLevelName((String)dimensions[i2].getName(), (String)joinCondition.getCubeKey()));
                    }
                    factTableKey[i2] = new String[factTableKeys.size()];
                    dimensionKey[i2] = new String[dimensionKeys.size()];
                    int j = 0;
                    while (j < dimensionKeys.size()) {
                        factTableKey[i2][j] = factTableKeys.get(j).toString();
                        dimensionKey[i2][j] = dimensionKeys.get(j).toString();
                        ++j;
                    }
                }
                if (!foundJoinCondition) {
                    throw new AdapterException("missing.join.condition", dim.getName());
                }
            }
            ++i2;
        }
        cubeMaterializer.createCube(cubeHandle.getQualifiedName(), factTableKey, dimensionKey, dimensions, (IDatasetIterator)new DataSetIterator(this, (IQueryDefinition)queryMap.get(cubeHandle), (List)metaMap.get(cubeHandle), appContext), this.toStringArray(measureNames), this.stopSign);
        appContext.clear();
        appContext.putAll(backupAppContext);
    }

    private void prepareForCubeGeneration(TabularCubeHandle cubeHandle, Map<ReportElementHandle, IQueryDefinition> queryMap, Map<ReportElementHandle, List<DataSetIterator.ColumnMeta>> metaMap) throws AdapterException, DataException {
        ArrayList<QueryDefinition> queryDefns = new ArrayList<QueryDefinition>();
        ArrayList metaList = new ArrayList();
        QueryDefinition query = DataRequestSessionImpl.createQuery(this, cubeHandle, metaList);
        queryDefns.add(query);
        queryMap.put((ReportElementHandle)cubeHandle, (IQueryDefinition)query);
        metaMap.put((ReportElementHandle)cubeHandle, metaList);
        List dimHandles = cubeHandle.getContents("dimensions");
        for (DimensionHandle dim : dimHandles) {
            List hiers = dim.getContents("hierarchies");
            for (TabularHierarchyHandle hier : hiers) {
                metaList = new ArrayList();
                query = DataRequestSessionImpl.createQuery(this, hier, metaList);
                queryDefns.add(query);
                queryMap.put((ReportElementHandle)hier, (IQueryDefinition)query);
                metaMap.put((ReportElementHandle)hier, metaList);
            }
        }
        this.dataEngine.registerQueries(queryDefns.toArray(new IDataQueryDefinition[0]));
    }

    private void clearCache(Set dataSetHandles) {
        Iterator it = dataSetHandles.iterator();
        while (it.hasNext()) {
            try {
                DataSetHandle dsHandle = (DataSetHandle)it.next();
                BaseDataSourceDesign baseDataSource = this.modelAdaptor.adaptDataSource(dsHandle.getDataSource());
                BaseDataSetDesign baseDataSet = this.modelAdaptor.adaptDataSet(dsHandle);
                this.dataEngine.clearCache((IBaseDataSourceDesign)baseDataSource, (IBaseDataSetDesign)baseDataSet);
                if (!(dsHandle instanceof JointDataSetHandle)) continue;
                HashSet parentSet = new HashSet();
                Iterator parentIt = ((JointDataSetHandle)dsHandle).dataSetsIterator();
                while (parentIt != null && parentIt.hasNext()) {
                    parentSet.add(parentIt.next());
                }
                this.clearCache(parentSet);
            }
            catch (Exception exception) {}
        }
    }

    private List getDataSetsToCache(TabularCubeHandle cubeHandle) {
        ArrayList<DataSetHandle> list = new ArrayList<DataSetHandle>();
        if (cubeHandle.getDataSet() == null) {
            return list;
        }
        list.add(cubeHandle.getDataSet());
        List dimHandles = cubeHandle.getContents("dimensions");
        int i = 0;
        while (i < dimHandles.size()) {
            DimensionHandle dimHandle = (DimensionHandle)dimHandles.get(i);
            List hiers = dimHandle.getContents("hierarchies");
            TabularHierarchyHandle hierHandle = (TabularHierarchyHandle)hiers.get(0);
            if (hierHandle.getDataSet() != null) {
                list.add(hierHandle.getDataSet());
            } else {
                list.add(cubeHandle.getDataSet());
            }
            ++i;
        }
        return list;
    }

    private Set getInvolvedDataSets(TabularCubeHandle cubeHandle) {
        return new HashSet(this.getDataSetsToCache(cubeHandle));
    }

    private boolean isAttribute(IDimension dimension, String levelName, String colName) {
        ILevel[] levels = dimension.getHierarchy().getLevels();
        int j = 0;
        while (j < levels.length) {
            String[] attributes;
            if (levelName.equals(OlapExpressionUtil.getQualifiedLevelName((String)dimension.getName(), (String)levels[j].getName())) && (attributes = levels[j].getAttributeNames()) != null) {
                int k = 0;
                while (k < attributes.length) {
                    if (attributes[k].equals(OlapExpressionUtil.getAttributeColumnName((String)levels[j].getName(), (String)colName))) {
                        return true;
                    }
                    ++k;
                }
            }
            ++j;
        }
        return false;
    }

    private String getLevelName(IDimension dimension, String targetName) {
        ILevel[] levels = dimension.getHierarchy().getLevels();
        int j = 0;
        while (j < levels.length) {
            if (targetName.equals(OlapExpressionUtil.getQualifiedLevelName((String)dimension.getName(), (String)levels[j].getName()))) {
                return levels[j].getName();
            }
            ++j;
        }
        return targetName;
    }

    private IDimension[] populateDimensions(CubeMaterializer cubeMaterializer, TabularCubeHandle cubeHandle, Map appContext, Map<ReportElementHandle, IQueryDefinition> queryMap, Map<ReportElementHandle, List<DataSetIterator.ColumnMeta>> metaMap) throws IOException, BirtException, DataException {
        List dimHandles = cubeHandle.getContents("dimensions");
        ArrayList<IDimension> result = new ArrayList<IDimension>();
        int i = 0;
        while (i < dimHandles.size()) {
            result.add(this.populateDimension(cubeMaterializer, (DimensionHandle)dimHandles.get(i), cubeHandle, appContext, queryMap, metaMap));
            ++i;
        }
        IDimension[] dimArray = new IDimension[dimHandles.size()];
        int i2 = 0;
        while (i2 < result.size()) {
            dimArray[i2] = (IDimension)result.get(i2);
            ++i2;
        }
        return dimArray;
    }

    private IDimension populateDimension(CubeMaterializer cubeMaterializer, DimensionHandle dim, TabularCubeHandle cubeHandle, Map appContext, Map<ReportElementHandle, IQueryDefinition> queryMap, Map<ReportElementHandle, List<DataSetIterator.ColumnMeta>> metaMap) throws IOException, BirtException, DataException {
        List hiers = dim.getContents("hierarchies");
        ArrayList<IHierarchy> iHiers = new ArrayList<IHierarchy>();
        int j = 0;
        while (j < hiers.size()) {
            TabularHierarchyHandle hierhandle = (TabularHierarchyHandle)hiers.get(0);
            List levels = hierhandle.getContents("levels");
            ILevelDefn[] levelInHier = null;
            levelInHier = hierhandle.getLevelCount() == 1 ? new ILevelDefn[1] : new ILevelDefn[hierhandle.getLevelCount() + 1];
            String[] leafLevelKeyColumn = new String[levels.size()];
            int k = 0;
            while (k < levels.size()) {
                TabularLevelHandle level = (TabularLevelHandle)levels.get(k);
                ArrayList<String> levelKeys = new ArrayList<String>();
                Iterator it = level.attributesIterator();
                while (it.hasNext()) {
                    LevelAttributeHandle levelAttr = (LevelAttributeHandle)it.next();
                    levelKeys.add(OlapExpressionUtil.getAttributeColumnName((String)level.getName(), (String)levelAttr.getName()));
                }
                if ("dynamic".equals(level.getLevelType()) && level.getDisplayColumnName() != null) {
                    levelKeys.add(OlapExpressionUtil.getDisplayColumnName((String)level.getName()));
                }
                leafLevelKeyColumn[k] = level.getName();
                levelInHier[k] = CubeElementFactory.createLevelDefinition((String)level.getName(), (String[])new String[]{level.getName()}, (String[])this.toStringArray(levelKeys));
                ++k;
            }
            this.createLeafLevel(levels, levelInHier, leafLevelKeyColumn);
            iHiers.add(cubeMaterializer.createHierarchy(dim.getName(), hierhandle.getName(), (IDatasetIterator)new DataSetIterator(this, queryMap.get(hierhandle), metaMap.get(hierhandle), appContext), levelInHier, this.stopSign));
            ++j;
        }
        return cubeMaterializer.createDimension(dim.getName(), (IHierarchy)iHiers.get(0));
    }

    private void createLeafLevel(List levels, ILevelDefn[] levelInHier, String[] leafLevelKeyColumn) {
        if (levelInHier.length > levels.size()) {
            levelInHier[levelInHier.length - 1] = CubeElementFactory.createLevelDefinition((String)"_${INTERNAL_INDEX}$_", (String[])leafLevelKeyColumn, (String[])new String[0]);
        }
    }

    private String[] toStringArray(List object) {
        String[] result = new String[object.size()];
        int i = 0;
        while (i < object.size()) {
            result[i] = object.get(i).toString();
            ++i;
        }
        return result;
    }

    @Override
    public IPreparedCubeQuery prepare(ICubeQueryDefinition query) throws BirtException {
        return this.prepare(query, null);
    }

    @Override
    public IPreparedCubeQuery prepare(ICubeQueryDefinition query, Map appContext) throws BirtException {
        this.stopSign.start();
        this.setModuleHandleToAppContext(appContext);
        if (this.cubeHandleMap.get(query.getName()) != null) {
            this.materializeCube((CubeHandle)this.cubeHandleMap.get(query.getName()), appContext);
            this.cubeHandleMap.remove(query.getName());
        }
        return this.dataEngine.prepare(query, appContext);
    }

    private static ResourceIdentifiers createResourceIdentifiers(final ModuleHandle handle) {
        if (handle == null) {
            return null;
        }
        try {
            ResourceIdentifiers identifiers = new ResourceIdentifiers();
            if (handle.getSystemId() != null) {
                identifiers.setDesignResourceBaseURI(handle.getSystemId().toURI());
            }
            if (handle.getResourceFolder() != null) {
                URI piTmp0 = null;
                piTmp0 = (URI)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return new File(handle.getResourceFolder()).toURI();
                    }
                });
                identifiers.setApplResourceBaseURI(piTmp0);
            }
            return identifiers;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    @Override
    public IResultMetaData getCachedDataSetMetaData(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        return this.dataEngine.getCachedDataSetMetaData(dataSource, dataSet);
    }

    @Override
    public ICubeQueryUtil getCubeQueryUtil() {
        return new CubeQueryUtil(this);
    }

    @Override
    public AggregationManager getAggregationManager() throws DataException {
        return AggregationManager.getInstance();
    }

    public Scriptable getScope() throws AdapterException {
        try {
            return this.sessionContext.getDataEngineContext().getJavaScriptScope();
        }
        catch (BirtException e) {
            throw new AdapterException("exception.error", e);
        }
    }

    @Override
    public void cancel() {
        this.stopSign.stop();
    }

    @Override
    public IQueryDefinitionUtil getQueryDefinitionUtil() {
        return new QueryDefinitionUtil();
    }

    @Override
    public void registerQueries(IDataQueryDefinition[] queryDefns) throws AdapterException {
        try {
            this.dataEngine.registerQueries(queryDefns);
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public IPreparedCubeQuery prepare(ISubCubeQueryDefinition query, Map appContext) throws BirtException {
        this.setModuleHandleToAppContext(appContext);
        return this.dataEngine.prepare(query, appContext);
    }

    private void setModuleHandleToAppContext() {
        if (this.sessionContext.getAppContext() == null) {
            this.sessionContext.setAppContext(new HashMap());
        }
        this.setModuleHandleToAppContext(this.sessionContext.getAppContext());
    }

    private void setModuleHandleToAppContext(Map appContext) {
        String resouceIDs;
        if (appContext == null) {
            appContext = new HashMap<String, Object>();
        }
        if (!appContext.containsKey(resouceIDs = "org.eclipse.datatools.connectivity.oda.util_consumerResourceIds") || appContext.get(resouceIDs) == null) {
            if (this.sessionContext.getModuleHandle() != null) {
                appContext.put(resouceIDs, DataRequestSessionImpl.createResourceIdentifiers(this.sessionContext.getModuleHandle()));
            } else if (this.sessionContext.getAppContext() != null) {
                appContext.put(resouceIDs, this.sessionContext.getAppContext().get(resouceIDs));
            }
        }
    }

    private void defineDataSourceDataSet(IQueryDefinition queryDefn) throws BirtException {
        String dataSetName = queryDefn.getDataSetName();
        ModuleHandle module = this.sessionContext.getModuleHandle();
        if (module != null) {
            List l = module.getAllDataSets();
            DataSetHandle handle = null;
            int i = 0;
            while (i < l.size()) {
                if (((DataSetHandle)l.get(i)).getQualifiedName() != null && ((DataSetHandle)l.get(i)).getQualifiedName().equals(dataSetName)) {
                    handle = (DataSetHandle)l.get(i);
                    break;
                }
                ++i;
            }
            this.defineDataSourceDataSet(handle);
        }
    }

    private void defineDataSourceDataSet(DataSetHandle handle) throws BirtException {
        if (handle == null) {
            return;
        }
        DataSourceHandle dataSourceHandle = handle.getDataSource();
        if (dataSourceHandle != null && this.dataEngine.getDataSourceRuntime(dataSourceHandle.getName()) == null) {
            BaseDataSourceDesign dsourceDesign = this.modelAdaptor.adaptDataSource(dataSourceHandle);
            this.dataEngine.defineDataSource((IBaseDataSourceDesign)dsourceDesign);
        }
        if (handle instanceof JointDataSetHandle) {
            this.defineDataSourceDataSet((JointDataSetHandle)handle);
        }
        if (this.dataEngine.getDataSetDesign(handle.getName()) == null) {
            BaseDataSetDesign baseDS = this.modelAdaptor.adaptDataSet(handle);
            this.dataEngine.defineDataSet((IBaseDataSetDesign)baseDS);
        }
    }

    private void defineDataSourceDataSet(JointDataSetHandle jointDataSetHandle) throws BirtException {
        Iterator iter = jointDataSetHandle.dataSetsIterator();
        while (iter.hasNext()) {
            DataSetHandle dsHandle = (DataSetHandle)iter.next();
            if (dsHandle == null) continue;
            this.defineDataSourceDataSet(dsHandle);
        }
    }

    private static void prepareLevels(QueryDefinition query, TabularHierarchyHandle hierHandle, List metaList, String dimName) throws AdapterException {
        try {
            List levels = hierHandle.getContents("levels");
            int j = 0;
            while (j < levels.size()) {
                TabularLevelHandle level = (TabularLevelHandle)levels.get(j);
                DataSetIterator.ColumnMeta temp = null;
                String exprString = ExpressionUtil.createJSDataSetRowExpression((String)level.getColumnName());
                int type = DataAdapterUtil.adaptModelDataType(level.getDataType());
                if (type == -1 || type == 0) {
                    type = 5;
                }
                if (level.getDateTimeLevelType() != null) {
                    temp = new DataSetIterator.ColumnMeta(DataSetIterator.createLevelName(dimName, level.getName()), new DataSetIterator.DataProcessorWrapper(GroupCalculatorFactory.getGroupCalculator(99, 2, String.valueOf(DataSetIterator.getDefaultStartValue(level.getDateTimeLevelType(), level.getIntervalBase())), level.getIntervalRange())), 1);
                    temp.setDataType(2);
                    exprString = DataSetIterator.createDateTransformerExpr(level.getDateTimeLevelType(), exprString);
                } else {
                    DataSetIterator.DataProcessorWrapper processor = null;
                    if ("dynamic".equals(level.getLevelType())) {
                        int interval = GroupAdapter.intervalFromModel(level.getInterval());
                        if (interval != 0) {
                            processor = new DataSetIterator.DataProcessorWrapper(GroupCalculatorFactory.getGroupCalculator(interval, type, level.getIntervalBase(), level.getIntervalRange()));
                        }
                    } else if ("mirrored".equals(level.getLevelType())) {
                        Iterator it = level.staticValuesIterator();
                        ArrayList<String> dispExpr = new ArrayList<String>();
                        ArrayList<String> filterExpr = new ArrayList<String>();
                        while (it.hasNext()) {
                            RuleHandle o = (RuleHandle)it.next();
                            dispExpr.add(o.getDisplayExpression());
                            filterExpr.add(o.getRuleExpression());
                        }
                        exprString = "";
                        if (level.getDefaultValue() != null) {
                            exprString = String.valueOf(exprString) + "\"" + JavascriptEvalUtil.transformToJsConstants((String)level.getDefaultValue()) + "\";";
                        }
                        int i = 0;
                        while (i < dispExpr.size()) {
                            String disp = "\"" + JavascriptEvalUtil.transformToJsConstants((String)String.valueOf(dispExpr.get(i))) + "\"";
                            String filter = String.valueOf(filterExpr.get(i));
                            exprString = String.valueOf(exprString) + "if(" + filter + ")" + disp + ";";
                            ++i;
                        }
                    }
                    temp = new DataSetIterator.ColumnMeta(DataSetIterator.createLevelName(dimName, level.getName()), processor, 1);
                    temp.setDataType(type);
                }
                metaList.add(temp);
                Iterator it = level.attributesIterator();
                while (it.hasNext()) {
                    LevelAttributeHandle levelAttr = (LevelAttributeHandle)it.next();
                    DataSetIterator.DateTimeAttributeProcessor processor = null;
                    String bindingExpr = null;
                    if (level.getDateTimeLevelType() != null && "DateTime".equals(levelAttr.getName())) {
                        processor = new DataSetIterator.DateTimeAttributeProcessor(level.getDateTimeLevelType());
                        bindingExpr = ExpressionUtil.createJSDataSetRowExpression((String)level.getColumnName());
                    } else {
                        bindingExpr = ExpressionUtil.createJSDataSetRowExpression((String)levelAttr.getName());
                    }
                    DataSetIterator.ColumnMeta meta = new DataSetIterator.ColumnMeta(DataSetIterator.createLevelName(dimName, OlapExpressionUtil.getAttributeColumnName((String)level.getName(), (String)levelAttr.getName())), processor, 3);
                    meta.setDataType(DataAdapterUtil.adaptModelDataType(levelAttr.getDataType()));
                    metaList.add(meta);
                    query.addBinding((IBinding)new Binding(meta.getName(), (IBaseExpression)new ScriptExpression(bindingExpr)));
                }
                if ("dynamic".equals(level.getLevelType()) && level.getDisplayColumnName() != null) {
                    DataSetIterator.ColumnMeta meta = new DataSetIterator.ColumnMeta(DataSetIterator.createLevelName(dimName, OlapExpressionUtil.getDisplayColumnName((String)level.getName())), null, 3);
                    meta.setDataType(5);
                    metaList.add(meta);
                    query.addBinding((IBinding)new Binding(meta.getName(), (IBaseExpression)new ScriptExpression(level.getDisplayColumnName())));
                }
                String levelName = DataSetIterator.createLevelName(dimName, level.getName());
                query.addBinding((IBinding)new Binding(levelName, (IBaseExpression)new ScriptExpression(exprString, type)));
                GroupDefinition gd = new GroupDefinition(String.valueOf(query.getGroups().size()));
                gd.setKeyExpression(ExpressionUtil.createJSRowExpression((String)levelName));
                if (level.getLevelType() != null && level.getDateTimeLevelType() == null) {
                    gd.setIntervalRange(level.getIntervalRange());
                    gd.setIntervalStart((Object)level.getIntervalBase());
                    gd.setInterval(GroupAdapter.intervalFromModel(level.getInterval()));
                }
                if (level.getDateTimeLevelType() != null) {
                    gd.setIntervalRange(level.getIntervalRange() == 0.0 ? 1.0 : level.getIntervalRange());
                    gd.setIntervalStart((Object)String.valueOf(DataSetIterator.getDefaultStartValue(level.getDateTimeLevelType(), level.getIntervalBase())));
                    gd.setInterval(99);
                }
                query.addGroup(gd);
                ++j;
            }
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    private static void prepareMeasure(TabularCubeHandle cubeHandle, QueryDefinition query, List metaList) throws AdapterException {
        try {
            List measureGroups = cubeHandle.getContents("measureGroups");
            int i = 0;
            while (i < measureGroups.size()) {
                MeasureGroupHandle mgh = (MeasureGroupHandle)measureGroups.get(i);
                List measures = mgh.getContents("measures");
                int j = 0;
                while (j < measures.size()) {
                    ScriptExpression expr;
                    MeasureHandle measure = (MeasureHandle)measures.get(j);
                    String function = measure.getFunction();
                    String exprText = measure.getMeasureExpression();
                    ScriptExpression scriptExpression = expr = exprText != null ? new ScriptExpression(exprText) : null;
                    if (query.getGroups().size() > 0) {
                        Binding binding = new Binding(measure.getName(), (IBaseExpression)expr);
                        binding.setAggrFunction(DataAdapterUtil.adaptModelAggregationType(function));
                        IGroupDefinition group = (IGroupDefinition)query.getGroups().get(query.getGroups().size() - 1);
                        binding.addAggregateOn(group.getName());
                        query.addBinding((IBinding)binding);
                    } else {
                        query.addBinding((IBinding)new Binding(measure.getName(), (IBaseExpression)expr));
                    }
                    DataSetIterator.ColumnMeta meta = new DataSetIterator.ColumnMeta(measure.getName(), null, 2);
                    meta.setDataType(DataAdapterUtil.adaptModelDataType(measure.getDataType()));
                    metaList.add(meta);
                    ++j;
                }
                ++i;
            }
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    private static void popualteFilter(DataRequestSession session, Iterator filterIterator, QueryDefinition query) {
        while (filterIterator.hasNext()) {
            FilterConditionHandle filter = (FilterConditionHandle)filterIterator.next();
            query.addFilter((IFilterDefinition)session.getModelAdaptor().adaptFilter(filter));
        }
    }

    static QueryDefinition createQuery(DataRequestSessionImpl session, TabularCubeHandle cubeHandle, List metaList) throws AdapterException, DataException {
        if (metaList == null) {
            metaList = new ArrayList<DataSetIterator.ColumnMeta>();
        }
        QueryDefinition query = new QueryDefinition();
        query.setUsesDetails(false);
        query.setDataSetName(cubeHandle.getDataSet().getQualifiedName());
        List dimensions = cubeHandle.getContents("dimensions");
        if (dimensions != null) {
            int i = 0;
            while (i < dimensions.size()) {
                TabularDimensionHandle dimension = (TabularDimensionHandle)dimensions.get(i);
                List hiers = dimension.getContents("hierarchies");
                assert (hiers.size() == 1);
                TabularHierarchyHandle hierHandle = (TabularHierarchyHandle)hiers.get(0);
                if (hierHandle.getDataSet() == null || hierHandle.getDataSet().getQualifiedName().equals(cubeHandle.getDataSet().getQualifiedName())) {
                    DataRequestSessionImpl.prepareLevels(query, hierHandle, metaList, dimension.getName());
                } else {
                    Iterator it = cubeHandle.joinConditionsIterator();
                    while (it.hasNext()) {
                        DimensionConditionHandle dimCondHandle = (DimensionConditionHandle)it.next();
                        if (!dimCondHandle.getHierarchy().getName().equals(hierHandle.getName())) continue;
                        for (DimensionJoinConditionHandle joinCondition : dimCondHandle.getJoinConditions()) {
                            String cubeKey = joinCondition.getCubeKey();
                            String cubeKeyWithDimIdentifier = OlapExpressionUtil.getQualifiedLevelName((String)dimension.getName(), (String)cubeKey);
                            metaList.add(new DataSetIterator.ColumnMeta(cubeKeyWithDimIdentifier, null, 1));
                            query.addBinding((IBinding)new Binding(cubeKeyWithDimIdentifier, (IBaseExpression)new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)cubeKey))));
                            GroupDefinition gd = new GroupDefinition(String.valueOf(query.getGroups().size()));
                            gd.setKeyExpression(ExpressionUtil.createJSRowExpression((String)cubeKeyWithDimIdentifier));
                            query.addGroup(gd);
                        }
                    }
                }
                ++i;
            }
        }
        DataRequestSessionImpl.prepareMeasure(cubeHandle, query, metaList);
        DataRequestSessionImpl.popualteFilter(session, cubeHandle.filtersIterator(), query);
        return query;
    }

    private static String getDataSet(TabularHierarchyHandle handle) {
        if (handle.getDataSet() != null) {
            return handle.getDataSet().getQualifiedName();
        }
        TabularCubeHandle cubeHandle = DataRequestSessionImpl.acquireContainerCube(handle);
        if (cubeHandle != null) {
            return cubeHandle.getDataSet().getQualifiedName();
        }
        return null;
    }

    private static TabularCubeHandle acquireContainerCube(TabularHierarchyHandle hierHandle) {
        DesignElementHandle handle = hierHandle.getContainer().getContainer();
        if (handle == null || !(handle instanceof TabularCubeHandle)) {
            return null;
        }
        return (TabularCubeHandle)handle;
    }

    private static Iterator getFilterIterator(TabularHierarchyHandle handle) {
        if (handle.getDataSet() != null) {
            return handle.filtersIterator();
        }
        TabularCubeHandle cubeHandle = DataRequestSessionImpl.acquireContainerCube(handle);
        if (cubeHandle != null) {
            return cubeHandle.filtersIterator();
        }
        return new ArrayList().iterator();
    }

    static QueryDefinition createQuery(DataRequestSessionImpl session, TabularHierarchyHandle hierHandle, List metaList) throws AdapterException {
        assert (metaList != null);
        QueryDefinition query = new QueryDefinition();
        query.setUsesDetails(false);
        query.setDataSetName(DataRequestSessionImpl.getDataSet(hierHandle));
        DataRequestSessionImpl.prepareLevels(query, hierHandle, metaList, null);
        DataRequestSessionImpl.popualteFilter(session, DataRequestSessionImpl.getFilterIterator(hierHandle), query);
        return query;
    }

    @Override
    public DataSessionContext getDataSessionContext() {
        return this.sessionContext;
    }
}

