/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class OdaScalarDataType
extends AbstractEnumerator {
    public static final String copyright = "Copyright (c) 2005, 2007 Actuate Corporation";
    public static final int DATE = 0;
    public static final int DOUBLE = 1;
    public static final int INTEGER = 2;
    public static final int STRING = 3;
    public static final int TIME = 4;
    public static final int TIMESTAMP = 5;
    public static final int DECIMAL = 6;
    public static final int BLOB = 7;
    public static final int CLOB = 8;
    public static final int BOOLEAN = 9;
    public static final OdaScalarDataType DATE_LITERAL = new OdaScalarDataType(0, "Date", "Date");
    public static final OdaScalarDataType DOUBLE_LITERAL = new OdaScalarDataType(1, "Double", "Double");
    public static final OdaScalarDataType INTEGER_LITERAL = new OdaScalarDataType(2, "Integer", "Integer");
    public static final OdaScalarDataType STRING_LITERAL = new OdaScalarDataType(3, "String", "String");
    public static final OdaScalarDataType TIME_LITERAL = new OdaScalarDataType(4, "Time", "Time");
    public static final OdaScalarDataType TIMESTAMP_LITERAL = new OdaScalarDataType(5, "Timestamp", "Timestamp");
    public static final OdaScalarDataType DECIMAL_LITERAL = new OdaScalarDataType(6, "Decimal", "Decimal");
    public static final OdaScalarDataType BLOB_LITERAL = new OdaScalarDataType(7, "Blob", "Blob");
    public static final OdaScalarDataType CLOB_LITERAL = new OdaScalarDataType(8, "Clob", "Clob");
    public static final OdaScalarDataType BOOLEAN_LITERAL = new OdaScalarDataType(9, "Boolean", "Boolean");
    private static final OdaScalarDataType[] VALUES_ARRAY = new OdaScalarDataType[]{DATE_LITERAL, DOUBLE_LITERAL, INTEGER_LITERAL, STRING_LITERAL, TIME_LITERAL, TIMESTAMP_LITERAL, DECIMAL_LITERAL, BLOB_LITERAL, CLOB_LITERAL, BOOLEAN_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static OdaScalarDataType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OdaScalarDataType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OdaScalarDataType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OdaScalarDataType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OdaScalarDataType get(int value) {
        switch (value) {
            case 0: {
                return DATE_LITERAL;
            }
            case 1: {
                return DOUBLE_LITERAL;
            }
            case 2: {
                return INTEGER_LITERAL;
            }
            case 3: {
                return STRING_LITERAL;
            }
            case 4: {
                return TIME_LITERAL;
            }
            case 5: {
                return TIMESTAMP_LITERAL;
            }
            case 6: {
                return DECIMAL_LITERAL;
            }
            case 7: {
                return BLOB_LITERAL;
            }
            case 8: {
                return CLOB_LITERAL;
            }
            case 9: {
                return BOOLEAN_LITERAL;
            }
        }
        return null;
    }

    private OdaScalarDataType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

