/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;

public class MultiElementSlot
extends ContainerSlot {
    public ArrayList contents = new ArrayList();

    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        MultiElementSlot slot = (MultiElementSlot)super.clone();
        slot.contents = new ArrayList();
        int i = 0;
        while (i < this.contents.size()) {
            DesignElement e = (DesignElement)this.contents.get(i);
            slot.contents.add(e.doClone(policy));
            ++i;
        }
        return slot;
    }

    public int findPosn(DesignElement content) {
        return this.contents.indexOf(content);
    }

    public void insert(DesignElement element, int posn) {
        assert (!this.contents.contains(element));
        assert (posn >= 0 && posn <= this.contents.size());
        this.contents.add(posn, element);
    }

    public void remove(DesignElement element) {
        assert (this.contents.contains(element));
        this.contents.remove(element);
    }

    public Object remove(int posn) {
        assert (posn >= 0 && posn < this.getCount());
        return this.contents.remove(posn);
    }

    public boolean canDrop(DesignElement element) {
        return this.contents.contains(element);
    }

    public List getContents() {
        return this.contents;
    }

    public int getCount() {
        return this.contents.size();
    }

    public void moveContent(int from, int to) {
        assert (from >= 0 && from < this.contents.size());
        assert (to >= 0 && to < this.contents.size());
        if (from == to) {
            return;
        }
        Object obj = this.contents.remove(from);
        this.contents.add(to, obj);
    }

    public boolean contains(DesignElement element) {
        return this.contents.contains(element);
    }

    public DesignElement getContent(int posn) {
        assert (posn >= 0 && posn < this.contents.size());
        return (DesignElement)this.contents.get(posn);
    }

    public void clear() {
        this.contents.clear();
    }
}

