/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.parser.EncryptedPropertyState;
import org.eclipse.birt.report.model.parser.ExpressionState;
import org.eclipse.birt.report.model.parser.ListPropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.parser.PropertyState;
import org.eclipse.birt.report.model.parser.SimplePropertyListState;
import org.eclipse.birt.report.model.parser.StructureState;
import org.eclipse.birt.report.model.parser.TextPropertyState;
import org.eclipse.birt.report.model.parser.XmlPropertyState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.XMLParserHandler;

public abstract class DesignParseState
extends AbstractParseState {
    protected ModuleParserHandler handler = null;

    public DesignParseState(ModuleParserHandler theHandler) {
        this.handler = theHandler;
    }

    public XMLParserHandler getHandler() {
        return this.handler;
    }

    public abstract DesignElement getElement();

    protected void setProperty(String propName, String value) {
        DesignElement element = this.getElement();
        ElementPropertyDefn prop = element.getPropertyDefn(propName);
        assert (prop != null);
        Object propValue = null;
        try {
            propValue = prop.validateXml(this.handler.getModule(), value);
        }
        catch (PropertyValueException ex) {
            ex.setElement(element);
            ex.setPropertyName(propName);
            this.handler.getErrorHandler().semanticError((Exception)((Object)ex));
            return;
        }
        element.setProperty(propName, propValue);
    }

    public AbstractParseState startElement(String tagName) {
        int tagValue = tagName.toLowerCase().hashCode();
        if (ParserSchemaConstants.PROPERTY_TAG == tagValue) {
            return new PropertyState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.LIST_PROPERTY_TAG == tagValue) {
            return new ListPropertyState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.EXPRESSION_TAG == tagValue) {
            return new ExpressionState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.XML_PROPERTY_TAG == tagValue) {
            return new XmlPropertyState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.STRUCTURE_TAG == tagValue) {
            return new StructureState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.METHOD_TAG == tagValue) {
            return new PropertyState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.TEXT_PROPERTY_TAG == tagValue) {
            return new TextPropertyState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.HTML_PROPERTY_TAG == tagValue) {
            return new TextPropertyState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.ENCRYPTED_PROPERTY_TAG == tagValue) {
            return new EncryptedPropertyState(this.handler, this.getElement());
        }
        if (ParserSchemaConstants.SIMPLE_PROPERTY_LIST_TAG == tagValue) {
            return new SimplePropertyListState(this.handler, this.getElement());
        }
        return super.startElement(tagName);
    }
}

