/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeNode;
import org.eclipse.birt.core.btree.BTreeValue;
import org.eclipse.birt.core.btree.BTreeValues;
import org.eclipse.birt.core.btree.ExternalValueList;
import org.eclipse.birt.core.btree.IndexEntry;
import org.eclipse.birt.core.btree.InlineValueList;
import org.eclipse.birt.core.btree.LeafEntry;
import org.eclipse.birt.core.btree.SingleValueList;
import org.eclipse.birt.core.btree.ValueNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LeafNode<K, V>
extends BTreeNode<K, V> {
    static final int EMPTY_NODE_SIZE = 16;
    private int prevNodeId = -1;
    private int nextNodeId = -1;
    private int entryCount;
    private int nodeSize = 16;
    private LeafEntry<K, V> firstEntry;
    private LeafEntry<K, V> lastEntry;

    public LeafNode(BTree<K, V> btree, int nodeId) {
        super(btree, 2, nodeId);
    }

    public int getPrevNodeId() {
        return this.prevNodeId;
    }

    public void setPrevNodeId(int prevNodeId) {
        this.prevNodeId = prevNodeId;
    }

    public int getNextNodeId() {
        return this.nextNodeId;
    }

    public void setNextNodeId(int nextNodeId) {
        this.nextNodeId = nextNodeId;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public int getNodeSize() {
        return this.nodeSize;
    }

    public LeafEntry<K, V> getFirstEntry() {
        return this.firstEntry;
    }

    public LeafEntry<K, V> getLastEntry() {
        return this.lastEntry;
    }

    public LeafEntry<K, V> find(BTreeValue<K> key) throws IOException {
        LeafEntry<K, V> entry = this.firstEntry;
        while (entry != null) {
            int result = this.btree.compare(entry.getKey(), key);
            if (result == 0) {
                return entry;
            }
            if (result > 0) {
                return null;
            }
            entry = entry.getNext();
        }
        return null;
    }

    public LeafEntry<K, V> insert(BTreeValue<K> key, BTreeValue<V> value) throws IOException {
        this.dirty = true;
        LeafEntry<K, V> insertPoint = this.firstEntry;
        while (insertPoint != null) {
            int result = this.btree.compare(insertPoint.getKey(), key);
            if (result == 0) {
                if (!this.btree.hasValue()) {
                    return insertPoint;
                }
                if (!this.btree.allowDuplicate()) {
                    BTreeValues<V> values = insertPoint.getValues();
                    int valueSize1 = values.getValueSize();
                    SingleValueList sv = new SingleValueList(this.btree, value);
                    int valueSize2 = sv.getValueSize();
                    insertPoint.setValues(sv);
                    this.nodeSize = this.nodeSize + valueSize2 - valueSize1;
                    return insertPoint;
                }
                BTreeValues values = insertPoint.getValues();
                int valueSize1 = values.getValueSize();
                values.append(value);
                int valueSize2 = values.getValueSize();
                if (valueSize2 > 2046) {
                    values = this.btree.createExternalValueList(values);
                    valueSize2 = values.getValueSize();
                    insertPoint.setValues(values);
                }
                this.nodeSize = this.nodeSize - valueSize1 + valueSize2;
                this.btree.increaseTotalValues();
                return insertPoint;
            }
            if (result > 0) break;
            insertPoint = insertPoint.getNext();
        }
        BTreeValues values = null;
        if (this.btree.hasValue()) {
            if (this.btree.allowDuplicate()) {
                values = new InlineValueList(this.btree);
                values.append(value);
                if (values.getValueSize() > 2046) {
                    values = this.btree.createExternalValueList(values);
                }
            } else {
                values = new SingleValueList(this.btree, value);
            }
        }
        LeafEntry entry = new LeafEntry(this, key, values);
        this.insertBefore(insertPoint, entry);
        if (this.btree.hasValue()) {
            this.btree.increaseTotalValues();
        }
        this.btree.increaseTotalKeys();
        return entry;
    }

    private void insertBefore(LeafEntry<K, V> insertPoint, LeafEntry<K, V> entry) throws IOException {
        entry.setNode(this);
        if (insertPoint == null) {
            if (this.lastEntry == null) {
                entry.setPrev(null);
                entry.setNext(null);
                this.firstEntry = entry;
                this.lastEntry = entry;
            } else {
                entry.setPrev(this.lastEntry);
                entry.setNext(null);
                this.lastEntry.setNext(entry);
                this.lastEntry = entry;
            }
        } else {
            LeafEntry prev = insertPoint.getPrev();
            entry.setPrev(prev);
            entry.setNext(insertPoint);
            insertPoint.setPrev(entry);
            if (prev != null) {
                prev.setNext(entry);
            } else {
                this.firstEntry = entry;
            }
        }
        this.nodeSize += this.getEntrySize(entry);
        ++this.entryCount;
    }

    public boolean needSplit() {
        return this.nodeSize > 4092 && this.entryCount > 13;
    }

    public IndexEntry<K, V> split() throws IOException {
        this.entryCount /= 2;
        this.nodeSize = 16;
        LeafEntry splitEntry = this.firstEntry;
        int i = 0;
        while (i < this.entryCount) {
            this.nodeSize += this.getEntrySize(splitEntry);
            splitEntry = splitEntry.getNext();
            ++i;
        }
        this.lastEntry = splitEntry.getPrev();
        this.lastEntry.setNext(null);
        LeafNode newNode = this.btree.createLeafNode();
        try {
            LeafEntry entry = splitEntry;
            while (entry != null) {
                LeafEntry<K, V> nextEntry = entry.getNext();
                entry.setPrev(null);
                entry.setNext(null);
                super.insertBefore(null, entry);
                entry = nextEntry;
            }
            newNode.setNextNodeId(this.nextNodeId);
            newNode.setPrevNodeId(this.nodeId);
            if (this.nextNodeId != -1) {
                LeafNode nextNode = this.btree.loadLeafNode(this.nextNodeId);
                try {
                    nextNode.setPrevNodeId(newNode.getNodeId());
                    nextNode.setDirty(true);
                }
                finally {
                    nextNode.unlock();
                }
            }
            this.nextNodeId = newNode.getNodeId();
            IndexEntry indexEntry = new IndexEntry(null, splitEntry.getKey(), newNode.getNodeId());
            return indexEntry;
        }
        finally {
            newNode.unlock();
        }
    }

    @Override
    void read(DataInput in) throws IOException {
        this.nodeSize = in.readInt();
        this.prevNodeId = in.readInt();
        this.nextNodeId = in.readInt();
        this.entryCount = in.readInt();
        int i = 0;
        while (i < this.entryCount) {
            LeafEntry<K, V> entry = this.readEntry(in);
            if (this.firstEntry == null) {
                this.firstEntry = entry;
                this.lastEntry = entry;
            } else {
                this.lastEntry.setNext(entry);
                entry.setPrev(this.lastEntry);
                this.lastEntry = entry;
            }
            ++i;
        }
    }

    @Override
    protected void write(DataOutput out) throws IOException {
        out.writeInt(this.nodeSize);
        out.writeInt(this.prevNodeId);
        out.writeInt(this.nextNodeId);
        out.writeInt(this.entryCount);
        LeafEntry<K, V> entry = this.firstEntry;
        while (entry != null) {
            this.writeEntry(out, entry);
            entry = entry.getNext();
        }
    }

    private int getEntrySize(LeafEntry<K, V> entry) {
        int keySize = this.btree.getKeySize(entry.getKey());
        if (this.btree.hasValue()) {
            BTreeValues<V> values = entry.getValues();
            if (this.btree.allowDuplicate()) {
                return keySize + 4 + values.getValueSize();
            }
            return keySize + values.getValueSize();
        }
        return keySize;
    }

    protected LeafEntry<K, V> readEntry(DataInput in) throws IOException {
        BTreeValue key = this.btree.readKey(in);
        BTreeValues<V> values = this.readValues(in);
        return new LeafEntry(this, key, values);
    }

    private BTreeValues<V> readValues(DataInput in) throws IOException {
        if (this.btree.hasValue()) {
            if (this.btree.allowDuplicate()) {
                int type = in.readInt();
                if (type == 0) {
                    InlineValueList inlineValues = new InlineValueList(this.btree);
                    inlineValues.read(in);
                    return inlineValues;
                }
                if (type == 1) {
                    ExternalValueList externalValues = new ExternalValueList(this.btree);
                    externalValues.read(in);
                    return externalValues;
                }
                throw new IOException("unknown values type :" + type);
            }
            SingleValueList singleValues = new SingleValueList(this.btree);
            singleValues.read(in);
            return singleValues;
        }
        return null;
    }

    private void writeEntry(DataOutput out, LeafEntry<K, V> entry) throws IOException {
        this.btree.writeKey(out, entry.getKey());
        if (this.btree.hasValue()) {
            BTreeValues<V> values = entry.getValues();
            if (this.btree.allowDuplicate()) {
                out.writeInt(values.getType());
            }
            values.write(out);
        }
    }

    @Override
    public void dumpNode() throws IOException {
        System.out.println("LeafNode:" + this.nodeId);
        System.out.println("nodeSize:" + this.nodeSize);
        System.out.println("prevNodeId:" + this.prevNodeId);
        System.out.println("nextNodeId :" + this.nextNodeId);
        System.out.println("entryCount:" + this.entryCount);
        LeafEntry<K, V> entry = this.firstEntry;
        int id = 0;
        while (entry != null) {
            System.out.print(String.valueOf(id) + ":\"" + this.btree.getKey(entry.getKey()) + "\"");
            if (this.btree.hasValue()) {
                System.out.print(" valueCount:" + entry.getValues().getValueCount());
                System.out.print(" valueSize:" + entry.getValues().getValueSize());
            }
            System.out.println();
            ++id;
            entry = entry.getNext();
        }
    }

    @Override
    public void dumpAll() throws IOException {
        this.dumpNode();
        LeafEntry<K, V> entry = this.firstEntry;
        while (entry != null) {
            BTreeValues<V> values = entry.getValues();
            if (values != null && values.getType() == 1) {
                ExternalValueList extValues = (ExternalValueList)values;
                int nodeId = extValues.getFirstNodeId();
                while (nodeId != -1) {
                    ValueNode valueNode = this.btree.loadValueNode(nodeId);
                    try {
                        valueNode.dumpAll();
                        nodeId = valueNode.getNextNodeId();
                    }
                    finally {
                        valueNode.unlock();
                    }
                }
            }
            entry = entry.getNext();
        }
    }
}

