/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLClassLoader
extends java.net.URLClassLoader {
    private static Logger logger = Logger.getLogger(URLClassLoader.class.getName());
    private List<URL> urls = new LinkedList<URL>();
    private ArrayList<Loader> loaders;

    public URLClassLoader(URL[] urls) {
        super(new URL[0]);
        this.initURLs(urls);
        this.loaders = new ArrayList(urls.length);
        int i = 0;
        while (i < urls.length) {
            Loader loader = URLClassLoader.createLoader(urls[i]);
            if (loader != null) {
                this.loaders.add(loader);
            }
            ++i;
        }
    }

    private void initURLs(URL[] urls) {
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            this.urls.add(url);
            ++n2;
        }
    }

    public URLClassLoader(URL[] urls, ClassLoader parent) {
        super(new URL[0], parent);
        this.initURLs(urls);
        this.loaders = new ArrayList(urls.length);
        int i = 0;
        while (i < urls.length) {
            Loader loader = URLClassLoader.createLoader(urls[i]);
            if (loader != null) {
                this.loaders.add(loader);
            }
            ++i;
        }
    }

    @Override
    public void close() {
        if (this.loaders != null) {
            for (Loader loader : this.loaders) {
                try {
                    loader.close();
                }
                catch (IOException iOException) {}
            }
            this.loaders = null;
        }
    }

    @Override
    public void addURL(URL url) {
        if (url == null || this.urls.contains(url)) {
            return;
        }
        this.urls.add(url);
        Loader loader = URLClassLoader.createLoader(url);
        if (loader != null) {
            this.loaders.add(loader);
        }
    }

    @Override
    public URL[] getURLs() {
        return this.urls.toArray(new URL[0]);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.loaders == null) {
            throw new ClassNotFoundException(name);
        }
        String path = name.replace('.', '/').concat(".class");
        try {
            Resource res = this.loadResource(path);
            if (res != null) {
                CodeSource cs = res.getCodeSource();
                byte[] b = res.getBytes();
                return this.defineClass(name, b, 0, b.length, cs);
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL findResource(String name) {
        if (this.loaders != null) {
            for (Loader loader : this.loaders) {
                try {
                    URL url = loader.findResource(name);
                    if (url == null) continue;
                    return url;
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Vector<URL> urls = new Vector<URL>();
        if (this.loaders != null) {
            for (Loader loader : this.loaders) {
                try {
                    URL url = loader.findResource(name);
                    if (url == null) continue;
                    urls.add(url);
                }
                catch (IOException iOException) {}
            }
        }
        return urls.elements();
    }

    private Resource loadResource(String name) throws IOException {
        for (Loader loader : this.loaders) {
            Resource resource = loader.loadResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    static Loader createLoader(URL url) {
        try {
            String file = url.getFile();
            if (file != null && file.endsWith("/")) {
                if ("file".equals(url.getProtocol())) {
                    return new FileLoader(url);
                }
                return new UrlLoader(url);
            }
            return new JarLoader(url);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "can't load the class from " + url, ex);
            return null;
        }
    }

    static byte[] loadStream(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(in.available());
        byte[] bytes = new byte[1024];
        int readSize = in.read(bytes);
        while (readSize != -1) {
            out.write(bytes, 0, readSize);
            readSize = in.read(bytes);
        }
        return out.toByteArray();
    }

    private static String getFilePath(URL url) {
        String path = url.getFile();
        try {
            return URLDecoder.decode(path, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return path;
        }
    }

    static class FileLoader
    extends Loader {
        URL baseUrl;
        File baseDir;
        CodeSource codeSource;

        FileLoader(URL url) {
            this.baseUrl = url;
            this.baseDir = new File(URLClassLoader.getFilePath(url));
            this.codeSource = new CodeSource(this.baseUrl, null);
        }

        void close() throws IOException {
        }

        URL findResource(String name) throws IOException {
            File file = new File(this.baseDir, name.replace('/', File.separatorChar));
            if (file.exists() && file.isFile()) {
                return file.toURI().toURL();
            }
            return null;
        }

        Resource loadResource(String name) throws IOException {
            File file = new File(this.baseDir, name.replace('/', File.separatorChar));
            if (file.exists()) {
                FileInputStream in = new FileInputStream(file);
                try {
                    final byte[] bytes = URLClassLoader.loadStream(in);
                    Resource resource = new Resource(){

                        public byte[] getBytes() {
                            return bytes;
                        }

                        CodeSource getCodeSource() {
                            return FileLoader.this.codeSource;
                        }
                    };
                    return resource;
                }
                finally {
                    in.close();
                }
            }
            return null;
        }
    }

    static class JarLoader
    extends Loader {
        URL baseUrl;
        URL jarUrl;
        JarFile jarFile;

        JarLoader(URL url) throws IOException {
            this.baseUrl = url;
            this.jarUrl = new URL("jar", "", -1, this.baseUrl + "!/");
            if (this.baseUrl.getProtocol().equalsIgnoreCase("file")) {
                String filePath = URLClassLoader.getFilePath(this.baseUrl);
                this.jarFile = new JarFile(filePath);
            } else {
                JarURLConnection jarConn = (JarURLConnection)this.jarUrl.openConnection();
                this.jarFile = jarConn.getJarFile();
            }
        }

        public void close() throws IOException {
            if (this.jarFile != null) {
                this.jarFile.close();
                this.jarFile = null;
            }
        }

        URL findResource(String name) throws IOException {
            ZipEntry entry;
            if (this.jarFile != null && (entry = this.jarFile.getEntry(name)) != null) {
                return new URL(this.jarUrl, name, new JarEntryHandler(entry));
            }
            return null;
        }

        Resource loadResource(String name) throws IOException {
            JarEntry entry;
            if (this.jarFile != null && (entry = this.jarFile.getJarEntry(name)) != null) {
                InputStream in = this.jarFile.getInputStream(entry);
                try {
                    final byte[] bytes = URLClassLoader.loadStream(in);
                    Resource resource = new Resource(){

                        byte[] getBytes() {
                            return bytes;
                        }

                        CodeSource getCodeSource() {
                            return new CodeSource(JarLoader.this.baseUrl, entry.getCodeSigners());
                        }
                    };
                    return resource;
                }
                finally {
                    in.close();
                }
            }
            return null;
        }

        private class JarEntryHandler
        extends URLStreamHandler {
            private ZipEntry entry;

            JarEntryHandler(ZipEntry entry) {
                this.entry = entry;
            }

            protected URLConnection openConnection(URL u) throws IOException {
                return new URLConnection(u){

                    public void connect() throws IOException {
                    }

                    public int getContentLength() {
                        return (int)JarEntryHandler.this.entry.getSize();
                    }

                    public InputStream getInputStream() throws IOException {
                        if (((JarEntryHandler)JarEntryHandler.this).JarLoader.this.jarFile != null) {
                            return ((JarEntryHandler)JarEntryHandler.this).JarLoader.this.jarFile.getInputStream(JarEntryHandler.this.entry);
                        }
                        throw new IOException("ClassLoader has been closed");
                    }
                };
            }
        }
    }

    static abstract class Loader {
        Loader() {
        }

        abstract URL findResource(String var1) throws IOException;

        abstract Resource loadResource(String var1) throws IOException;

        abstract void close() throws IOException;
    }

    static abstract class Resource {
        Resource() {
        }

        abstract CodeSource getCodeSource();

        abstract byte[] getBytes() throws IOException;
    }

    static class UrlLoader
    extends Loader {
        CodeSource codeSource;
        URL baseUrl;

        UrlLoader(URL url) {
            this.baseUrl = url;
            this.codeSource = new CodeSource(url, null);
        }

        void close() throws IOException {
        }

        URL findResource(String name) throws IOException {
            URL url = new URL(this.baseUrl, name);
            URLConnection conn = url.openConnection();
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection hconn = (HttpURLConnection)conn;
                hconn.setRequestMethod("HEAD");
                if (hconn.getResponseCode() >= 400) {
                    return null;
                }
            } else {
                InputStream is = url.openStream();
                is.close();
            }
            return url;
        }

        Resource loadResource(String name) throws IOException {
            URL url = new URL(this.baseUrl, name);
            InputStream in = url.openStream();
            try {
                final byte[] bytes = URLClassLoader.loadStream(in);
                Resource resource = new Resource(){

                    byte[] getBytes() {
                        return bytes;
                    }

                    CodeSource getCodeSource() {
                        return UrlLoader.this.codeSource;
                    }
                };
                return resource;
            }
            finally {
                in.close();
            }
        }
    }
}

