/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.postscript;

import java.io.OutputStream;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.postscript.device.PostscriptPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.PageDeviceRender;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class PostscriptRender
extends PageDeviceRender {
    private OutputStream output = null;

    public PostscriptRender(IEmitterServices services) {
        this.initialize(services);
    }

    public IPageDevice createPageDevice(String title, String author, String subject, String description, IReportContext context, IReportContent report) {
        try {
            return new PostscriptPageDevice(this.output, title, author, description);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage());
            return null;
        }
    }

    public String getDefaultOuputFile() {
        return "report.ps";
    }

    public String getOutputFormat() {
        return "postscript";
    }

    private void initialize(IEmitterServices services) {
        this.services = services;
        IReportRunnable reportRunnable = services.getReportRunnable();
        if (reportRunnable != null) {
            this.reportDesign = (ReportDesignHandle)reportRunnable.getDesignHandle();
        }
        this.context = services.getReportContext();
        this.output = EmitterUtil.getOuputStream((IEmitterServices)services, (String)"report.ps");
    }
}

