/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ppt;

import java.io.OutputStream;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.ppt.device.PPTPageDevice;
import org.eclipse.birt.report.engine.layout.TextStyle;
import org.eclipse.birt.report.engine.layout.area.ITextArea;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.PageDeviceRender;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class PPTRender
extends PageDeviceRender {
    private OutputStream pptOutput = null;
    public static final String REPORT_FILE = "Report.ppt";

    public PPTRender(IEmitterServices services) {
        this.initialize(services);
    }

    public IPageDevice createPageDevice(String title, String author, String subject, String description, IReportContext context, IReportContent report) throws Exception {
        try {
            return new PPTPageDevice(this.pptOutput, title, author, description);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage());
            return null;
        }
    }

    public String getOutputFormat() {
        return "ppt";
    }

    public void initialize(IEmitterServices services) {
        this.services = services;
        IReportRunnable reportRunnable = services.getReportRunnable();
        if (reportRunnable != null) {
            this.reportDesign = (ReportDesignHandle)reportRunnable.getDesignHandle();
        }
        this.context = services.getReportContext();
        this.pptOutput = EmitterUtil.getOuputStream((IEmitterServices)services, (String)REPORT_FILE);
    }

    protected void drawTextAt(ITextArea text, int x, int y, int width, int height, TextStyle textStyle) {
        this.pageGraphic.drawText(text.getLogicalOrderText(), x, y, width, height, textStyle);
    }
}

