/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.ppt;

import com.ibm.icu.lang.UCharacter;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.report.engine.emitter.ppt.PPTRender;
import org.eclipse.birt.report.engine.layout.emitter.util.BackgroundImageLayout;
import org.eclipse.birt.report.engine.layout.emitter.util.Position;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;

public class PPTWriter {
    protected static Logger logger = Logger.getLogger(PPTRender.class.getName());
    private PrintWriter writer;
    protected int currentPageNum;
    private int shapeCount;
    protected float pageWidth;
    protected float pageHeight;
    private Map<String, ImageInfo> imageInfos;
    private Map<Integer, List<String>> fileNamesLists;

    public PPTWriter(OutputStream output) {
        block2: {
            this.writer = null;
            this.currentPageNum = 0;
            this.shapeCount = 0;
            this.imageInfos = new HashMap<String, ImageInfo>();
            this.fileNamesLists = new TreeMap<Integer, List<String>>();
            try {
                this.writer = new PrintWriter((Writer)new OutputStreamWriter(output, "UTF-8"), false);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void start(String title, String author, String description) {
        if (!this.imageInfos.isEmpty()) {
            this.imageInfos.clear();
        }
        if (!this.fileNamesLists.isEmpty()) {
            this.fileNamesLists.clear();
        }
        this.println("MIME-Version: 1.0");
        this.println("Content-Type: multipart/related; boundary=\"___Actuate_Content_Boundary___\"");
        this.println("");
        this.println("--___Actuate_Content_Boundary___");
        this.println("Content-Location: slide-show");
        this.println("Content-Transfer-Encoding: quoted-printable");
        this.println("Content-Type: text/html; charset=\"utf-8\"");
        this.println("");
        this.println("<html");
        this.println("xmlns=3D'http://www.w3.org/TR/REC-html40'");
        this.println("xmlns:o=3D'urn:schemas-microsoft-com:office:office'");
        this.println("xmlns:p=3D'urn:schemas-microsoft-com:office:powerpoint'");
        this.println("xmlns:v=3D'urn:schemas-microsoft-com:vml'");
        this.println(">");
        this.println("<head>");
        this.println("<meta http-equiv=3D'Content-Type' content=3D'text/html; charset=3Dutf-8'>");
        this.println("<meta name=3D'ProgId' content=3D'PowerPoint.Slide'>");
        this.println("<meta name=3D'Generator' content=3D'Actuate View Server'>");
        this.println("<title>" + title + "</title>");
        this.println("<xml><o:DocumentProperties>");
        this.println("<o:Author>" + author + "</o:Author>");
        this.println("<o:Description>" + description + "</o:Description>");
        this.println("</o:DocumentProperties></xml><link rel=3DFile-List href=3D'file-list'>");
        this.println("<link rel=3DPresentation-XML href=3D'presentation'>");
        this.println("</head></body></html>");
    }

    private void print(String text) {
        this.writer.print(text);
    }

    private void println(String text) {
        this.writer.println(text);
    }

    private void print(byte[] data) {
        this.print(new String(data));
    }

    public void end() {
        int slidesizex = (int)Math.ceil(this.pageWidth * 8.0f);
        int slidesizey = (int)Math.ceil(this.pageHeight * 8.0f);
        this.println("--___Actuate_Content_Boundary___");
        this.println("Content-Location: presentation");
        this.println("Content-Transfer-Encoding: quoted-printable");
        this.println("Content-Type: text/xml; charset=\"utf-8\"");
        this.println("");
        this.println("<xml");
        this.println(" xmlns:o=3D'urn:schemas-microsoft-com:office:office'");
        this.println(" xmlns:p=3D'urn:schemas-microsoft-com:office:powerpoint'");
        this.println(">");
        this.println("<p:presentation sizeof=3D'custom' slidesizex=3D'" + slidesizex + "' slidesizey=3D'" + slidesizey + "'>");
        int i = 0;
        while (i < this.currentPageNum) {
            this.println("<p:slide id=3D'" + (i + 1) + "' href=3D's" + (i + 1) + "'/>");
            ++i;
        }
        this.println("</p:presentation></xml>");
        this.println("");
        this.println("--___Actuate_Content_Boundary___");
        this.println("Content-Location: file-list");
        this.println("Content-Transfer-Encoding: quoted-printable");
        this.println("Content-Type: text/xml; charset=\"utf-8\"");
        this.println("<xml");
        this.println(" xmlns:o=3D'urn:schemas-microsoft-com:office:office'");
        this.println(" xmlns:p=3D'urn:schemas-microsoft-com:office:powerpoint'");
        this.println(">");
        this.println("<o:MainFile href=3D'slide-show'/>");
        this.println("<o:File href=3D'presentation'/>");
        this.println("<o:File href=3D'file-list'/>");
        i = 0;
        while (i < this.currentPageNum) {
            this.println("<o:File href=3D's" + (i + 1) + "'/>");
            if (this.fileNamesLists.containsKey(new Integer(i + 1))) {
                List<String> fileNames = this.fileNamesLists.get(new Integer(i + 1));
                for (String fileName : fileNames) {
                    this.println("<o:File href=3D\"" + fileName + "\"/>");
                }
            }
            ++i;
        }
        this.println("</xml>");
        this.println("");
        this.println("--___Actuate_Content_Boundary___--");
        this.writer.close();
        this.writer = null;
    }

    public void endPage() {
        try {
            Set<Map.Entry<String, ImageInfo>> entries = this.imageInfos.entrySet();
            for (Map.Entry<String, ImageInfo> entry : entries) {
                ImageInfo info = entry.getValue();
                this.generateImageBytes(info.imageId, info.imageData);
                this.println("\n");
            }
            this.println("</p:slide></body></html>");
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe.getMessage(), ioe);
        }
    }

    private void exportImageHeader(String imagekey) throws IOException {
        this.println("");
        this.println("--___Actuate_Content_Boundary___");
        ImageInfo imageInfo = this.imageInfos.get(imagekey);
        this.println("Content-Location: " + imageInfo.imageName);
        this.println("Content-Transfer-Encoding: base64");
        this.println("Content-Type: image/" + imageInfo.extension + "\n");
    }

    private void generateImageBytes(String imageTitle, byte[] imageData) throws IOException {
        this.exportImageHeader(imageTitle);
        Base64 base = new Base64();
        this.print(base.encode(imageData));
    }

    public void newPage(float pageWidth, float pageHeight, Color backgroundColor) {
        ++this.currentPageNum;
        this.imageInfos.clear();
        if (pageWidth > this.pageWidth) {
            this.pageWidth = pageWidth;
        }
        if (pageHeight > this.pageHeight) {
            this.pageHeight = pageHeight;
        }
        this.println("--___Actuate_Content_Boundary___");
        this.println("Content-Location: s" + this.currentPageNum);
        this.println("Content-Transfer-Encoding: quoted-printable");
        this.println("Content-Type: text/html; charset=\"utf-8\"");
        this.println("");
        this.println("<html");
        this.println(" xmlns=3D'http://www.w3.org/TR/REC-html40'");
        this.println(" xmlns:o=3D'urn:schemas-microsoft-com:office:office'");
        this.println(" xmlns:p=3D'urn:schemas-microsoft-com:office:powerpoint'");
        this.println(" xmlns:v=3D'urn:schemas-microsoft-com:vml'");
        this.println(">");
        this.println("<head/><body><p:slide>");
        this.println("<meta http-equiv=3D'Content-Type' content=3D'text/html; charset=3Dutf-8'>");
        this.drawBackgroundColor(backgroundColor, 0.0, 0.0, pageWidth, pageHeight);
    }

    private String getFontName(BaseFont baseFont) {
        String[][] familyFontNames = baseFont.getFamilyFontName();
        String[] family = familyFontNames[familyFontNames.length - 1];
        return family[family.length - 1];
    }

    public void drawText(String text, float textX, float textY, float width, float height, FontInfo fontInfo, Color color, boolean rtl) {
        boolean isBold;
        BaseFont baseFont = fontInfo.getBaseFont();
        String fontName = this.getFontName(baseFont);
        this.println("<v:shape id=3D't" + ++this.shapeCount + "' type=3D'#r'");
        this.println(" style=3D'position:absolute;left:" + textX + "pt;top:" + textY + "pt;width:" + width + "pt;height:" + height + "pt;v-text-anchor:top;mso-wrap-style:none;'");
        this.println(" filled=3D'f' stroked=3D'f'>");
        this.println("<v:textbox style=3D'mso-fit-shape-to-text:f;' inset=3D'0.00pt 0.00pt 0.00pt 0.00pt'/>");
        this.println("</v:shape>");
        this.println("<div v:shape=3D't" + this.shapeCount + "'>");
        this.println("<div style=3D'mso-text-indent-alt:0;text-align:left;'><span style=3D'font-family:" + fontName + ";font-size:" + fontInfo.getFontSize() + "pt;color:#" + this.getColorString(color) + ";'" + this.buildI18nAttributes(text, rtl) + ">");
        boolean isItalic = fontInfo != null && (fontInfo.getFontStyle() & 2) != 0;
        boolean bl = isBold = fontInfo != null && (fontInfo.getFontStyle() & 1) != 0;
        if (isItalic) {
            this.print("<i>");
        }
        if (isBold) {
            this.print("<b>");
        }
        this.print(this.getEscapedStr(text));
        if (isBold) {
            this.print("</b>");
        }
        if (isItalic) {
            this.print("</i>");
        }
        this.println("</span></div>");
        this.println("</div>");
    }

    private String getColorString(Color color) {
        StringBuffer buffer = new StringBuffer();
        this.appendComponent(buffer, color.getRed());
        this.appendComponent(buffer, color.getGreen());
        this.appendComponent(buffer, color.getBlue());
        return buffer.toString();
    }

    private void appendComponent(StringBuffer buffer, int component) {
        String hex = Integer.toHexString(component);
        if (hex.length() == 1) {
            buffer.append('0');
        }
        buffer.append(hex);
    }

    public void drawImage(String imageId, byte[] imageData, String extension, float imageX, float imageY, float height, float width, String helpText) throws Exception {
        ImageInfo imageInfo = this.getImageInfo(imageId, imageData, extension);
        this.exportImageDefn(imageInfo.imageName, imageInfo.imageId, width, height, imageX, imageY);
    }

    private ImageInfo getImageInfo(String imageId, byte[] imageData, String extension) {
        ImageInfo imageInfo = null;
        String imageTitle = this.getImageTitle();
        if (this.imageInfos.containsKey(imageId = imageId != null ? String.valueOf(imageId) + "_" + this.currentPageNum : imageTitle)) {
            imageInfo = this.imageInfos.get(imageId);
        } else {
            String imageName = String.valueOf(imageTitle) + "." + extension;
            imageInfo = new ImageInfo(imageId, imageName, extension, imageData);
            this.imageInfos.put(imageId, imageInfo);
            this.recordFileLists(imageName);
        }
        return imageInfo;
    }

    private void exportImageDefn(String imageName, String imageTitle, double width, double height, double x, double y) {
        this.println("<v:shape id=3D'" + this.shapeCount + "' type=3D'#_x0000_t75'");
        this.println(" style=3D'position:absolute;left:" + x + "pt;top:" + y + "pt;width:" + width + "pt;height:" + height + "pt'");
        this.println(" filled=3D'f' stroked=3D'f'>");
        this.println("<v:imagedata src=3D\"" + imageName + "\" o:title=3D\"" + imageTitle + "\"/>");
        this.println("<o:lock v:ext=3D'edit' aspectratio=3D't'/>");
        this.println("</v:shape>");
    }

    private String getImageExtension(String imageURI) {
        String rectifiedImageURI = imageURI.replace('.', '&');
        String extension = imageURI.substring(rectifiedImageURI.lastIndexOf(38) + 1).toLowerCase();
        if (extension.equals("svg")) {
            extension = "jpg";
        }
        return extension;
    }

    private void recordFileLists(String filename) {
        if (this.fileNamesLists.containsKey(this.currentPageNum)) {
            this.fileNamesLists.get(this.currentPageNum).add(filename);
        } else {
            ArrayList<String> fileNames = new ArrayList<String>();
            fileNames.add(filename);
            this.fileNamesLists.put(this.currentPageNum, fileNames);
        }
    }

    public void drawLine(double startX, double startY, double endX, double endY, double width, Color color, String lineStyle) {
        if (color == null || 0.0 == width || "none".equalsIgnoreCase(lineStyle)) {
            return;
        }
        if (lineStyle.equalsIgnoreCase("solid") || lineStyle.equalsIgnoreCase("dashed") || lineStyle.equalsIgnoreCase("dotted") || lineStyle.equalsIgnoreCase("double")) {
            this.drawRawLine(startX, startY, endX, endY, width, color, lineStyle);
        } else {
            this.drawRawLine(startX, startY, endX, endY, width, color, "solid");
        }
    }

    private void drawRawLine(double startX, double startY, double endX, double endY, double width, Color color, String lineStyle) {
        this.print("<v:line id=3D\"" + ++this.shapeCount + "\"");
        this.print(" style=3D'position:absolute' from=3D\"" + startX + "pt," + startY + "pt\"");
        this.print(" to=3D\"" + endX + "pt," + endY + "pt\"");
        this.print(" strokecolor=3D\"#" + this.getColorString(color) + "\"");
        this.print(" strokeweight=3D\"" + width + "pt\"");
        if (lineStyle.equalsIgnoreCase("dashed")) {
            this.println("<v:stroke dashstyle=3D\"dash\"/>");
        } else if (lineStyle.equalsIgnoreCase("dotted")) {
            this.println("<v:stroke dashstyle=3D\"1 1\"/>");
        } else if (lineStyle.equalsIgnoreCase("double")) {
            this.println("<v:stroke linestyle=3D\"thinThin\"/>");
        } else {
            this.println("/>");
            return;
        }
        this.println(">");
        this.println("</v:line>");
    }

    public void drawBackgroundColor(Color color, double x, double y, double width, double height) {
        if (color == null) {
            return;
        }
        this.print("<v:rect id=3D\"" + ++this.shapeCount + "\"");
        this.print(" style=3D'position:absolute;left:" + x + "pt;top:" + y + "pt;width:" + width + "pt;height:" + height + "pt'");
        this.print(" fillcolor=3D\"#" + this.getColorString(color) + "\"");
        this.println(" stroked=3D\"f\"/>");
    }

    public void drawBackgroundImage(String imageURI, float x, float y, float width, float height, float positionX, float positionY, String repeat) {
        byte[] imageData;
        float imageHeight;
        float imageWidth;
        block16: {
            if (imageURI == null || imageURI.length() == 0) {
                return;
            }
            imageWidth = 0.0f;
            imageHeight = 0.0f;
            imageData = null;
            InputStream imageStream = null;
            try {
                try {
                    URL url = new URL(imageURI);
                    imageStream = url.openStream();
                    imageData = this.getImageData(imageStream);
                    imageStream.close();
                    imageStream = url.openStream();
                    BufferedImage image = ImageIO.read(imageStream);
                    ImageIcon imageIcon = new ImageIcon(image);
                    imageWidth = imageIcon.getIconWidth();
                    imageHeight = imageIcon.getIconHeight();
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, ioe.getMessage(), ioe);
                    if (imageStream != null) {
                        try {
                            imageStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (imageStream != null) {
                    try {
                        imageStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (imageStream != null) {
                try {
                    imageStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        String extension = this.getImageExtension(imageURI);
        ImageInfo imageInfo = this.getImageInfo(imageURI, imageData, extension);
        Position areaPosition = new Position(x, y);
        Position areaSize = new Position(width, height);
        Position imagePosition = new Position(x + positionX, y + positionY);
        Position imageSize = new Position(imageWidth, imageHeight);
        BackgroundImageLayout layout = new BackgroundImageLayout(areaPosition, areaSize, imagePosition, imageSize);
        List positions = layout.getImagePositions(repeat);
        for (Position position : positions) {
            this.exportImageDefn(imageInfo.imageName, imageInfo.imageId, imageWidth, imageHeight, position.getX(), position.getY());
        }
    }

    private String getImageTitle() {
        return "slide" + this.currentPageNum + "_image" + ++this.shapeCount;
    }

    private byte[] getImageData(InputStream imageStream) throws IOException {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        int data = -1;
        while ((data = imageStream.read()) >= 0) {
            byteArrayStream.write(data);
        }
        byte[] imageData = byteArrayStream.toByteArray();
        return imageData;
    }

    protected String getEscapedStr(String s) {
        StringBuffer result = null;
        int spacePos = 1;
        char[] s2char = s.toCharArray();
        int i = 0;
        int max = s2char.length;
        int delta = 0;
        while (i < max) {
            char c = s2char[i];
            String replacement = null;
            if (c == ' ') {
                if (spacePos % 2 == 1 || i == max - 1) {
                    replacement = "&#160;";
                }
                ++spacePos;
            } else {
                spacePos = 0;
            }
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd')) {
                replacement = "";
            } else if (c == '&') {
                replacement = "&amp;";
            } else if (c == '<') {
                replacement = "&lt;";
            } else if (c == '>') {
                replacement = "&gt;";
            } else if (c == '\t') {
                replacement = " ";
            } else if (c == '=') {
                replacement = "=3D";
            } else if (c >= '\u0080') {
                replacement = "&#x" + Integer.toHexString(c) + ';';
            }
            if (replacement != null) {
                if (result == null) {
                    result = new StringBuffer(s);
                }
                result.replace(i + delta, i + delta + 1, replacement);
                delta += replacement.length() - 1;
            }
            ++i;
        }
        if (result == null) {
            return s;
        }
        return result.toString();
    }

    private String buildI18nAttributes(String text, boolean rtl) {
        if (text == null) {
            return "";
        }
        if (rtl) {
            String bidiAttributes = " dir=3D'rtl'";
            int i = text.length();
            while (i-- > 0) {
                UCharacter.UnicodeBlock block = UCharacter.UnicodeBlock.of((int)text.charAt(i));
                if (UCharacter.UnicodeBlock.HEBREW.equals((Object)block)) {
                    return String.valueOf(bidiAttributes) + " lang=3D'HE'";
                }
                if (!UCharacter.UnicodeBlock.ARABIC.equals((Object)block) && !UCharacter.UnicodeBlock.ARABIC_PRESENTATION_FORMS_A.equals((Object)block) && !UCharacter.UnicodeBlock.ARABIC_PRESENTATION_FORMS_B.equals((Object)block) && !UCharacter.UnicodeBlock.ARABIC_SUPPLEMENT.equals((Object)block)) continue;
                return String.valueOf(bidiAttributes) + " lang=3D'AR'";
            }
            return String.valueOf(bidiAttributes) + " lang=3D'HE'";
        }
        return " dir=3D'ltr' lang=3D'EN-US'";
    }

    private class ImageInfo {
        public String imageName;
        public String extension;
        public byte[] imageData;
        public String imageId;

        public ImageInfo(String imageId, String imageName, String extension, byte[] imageData) {
            this.imageId = imageId;
            this.imageName = imageName;
            this.extension = extension;
            this.imageData = imageData;
        }
    }
}

