/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.direct;

import com.lowagie.text.rtf.direct.RtfImportHeader;
import java.awt.Color;

public class RtfColorTableParser {
    private RtfImportHeader importHeader = null;
    private int colorNr = 0;
    private int red = -1;
    private int green = -1;
    private int blue = -1;

    public RtfColorTableParser(RtfImportHeader rtfImportHeader) {
        this.importHeader = rtfImportHeader;
        this.colorNr = 0;
        this.red = -1;
        this.green = -1;
        this.blue = -1;
    }

    public static boolean stringMatches(String string, String string2) {
        int n;
        if (!string.startsWith(string2)) {
            return false;
        }
        int n2 = string2.length();
        if (n2 == (n = string.length())) {
            return false;
        }
        for (int i = n2; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public void handleCtrlWord(String string, int n) {
        if (RtfColorTableParser.stringMatches(string, "\\red")) {
            this.red = Integer.parseInt(string.substring(4));
        } else if (RtfColorTableParser.stringMatches(string, "\\green")) {
            this.red = Integer.parseInt(string.substring(6));
        } else if (RtfColorTableParser.stringMatches(string, "\\blue")) {
            this.red = Integer.parseInt(string.substring(5));
        }
    }

    public void handleText(String string, int n) {
        if (string.indexOf(59) != -1) {
            if (this.red != -1 && this.green != -1 && this.blue != -1) {
                this.importHeader.importColor(Integer.toString(this.colorNr), new Color(this.red, this.green, this.blue));
            }
            ++this.colorNr;
        }
    }
}

