/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.graphic;

import com.lowagie.text.rtf.RtfAddableElement;
import com.lowagie.text.rtf.graphic.RtfShapePosition;
import com.lowagie.text.rtf.graphic.RtfShapeProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class RtfShape
extends RtfAddableElement {
    public static final int SHAPE_FREEFORM = 0;
    public static final int SHAPE_RECTANGLE = 1;
    public static final int SHAPE_ROUND_RECTANGLE = 2;
    public static final int SHAPE_ELLIPSE = 3;
    public static final int SHAPE_DIAMOND = 4;
    public static final int SHAPE_TRIANGLE_ISOSCELES = 5;
    public static final int SHAPE_TRIANGLE_RIGHT = 6;
    public static final int SHAPE_PARALLELOGRAM = 7;
    public static final int SHAPE_TRAPEZOID = 8;
    public static final int SHAPE_HEXAGON = 9;
    public static final int SHAPE_OCTAGON = 10;
    public static final int SHAPE_STAR = 12;
    public static final int SHAPE_ARROW = 13;
    public static final int SHAPE_ARROR_THICK = 14;
    public static final int SHAPE_HOME_PLATE = 15;
    public static final int SHAPE_CUBE = 16;
    public static final int SHAPE_BALLOON = 17;
    public static final int SHAPE_SEAL = 18;
    public static final int SHAPE_ARC = 19;
    public static final int SHAPE_LINE = 20;
    public static final int SHAPE_CAN = 22;
    public static final int SHAPE_DONUT = 23;
    public static final int SHAPE_WRAP_NONE = 0;
    public static final int SHAPE_WRAP_TOP_BOTTOM = 1;
    public static final int SHAPE_WRAP_BOTH = 2;
    public static final int SHAPE_WRAP_LEFT = 3;
    public static final int SHAPE_WRAP_RIGHT = 4;
    public static final int SHAPE_WRAP_LARGEST = 5;
    public static final int SHAPE_WRAP_TIGHT_BOTH = 6;
    public static final int SHAPE_WRAP_TIGHT_LEFT = 7;
    public static final int SHAPE_WRAP_TIGHT_RIGHT = 8;
    public static final int SHAPE_WRAP_TIGHT_LARGEST = 9;
    public static final int SHAPE_WRAP_THROUGH = 10;
    private int shapeNr = 0;
    private int type = 0;
    private RtfShapePosition position = null;
    private HashMap properties = null;
    private int wrapping = 0;
    private String shapeText = "";

    public RtfShape(int n, RtfShapePosition rtfShapePosition) {
        this.type = n;
        this.position = rtfShapePosition;
        this.properties = new HashMap();
    }

    public void setProperty(RtfShapeProperty rtfShapeProperty) {
        this.properties.put(rtfShapeProperty.getName(), rtfShapeProperty);
    }

    public void setShapeText(String string) {
        this.shapeText = string;
    }

    public void setWrapping(int n) {
        this.wrapping = n;
    }

    public byte[] write() {
        this.shapeNr = this.doc.getRandomInt();
        this.properties.put("ShapeType", new RtfShapeProperty("ShapeType", this.type));
        if (this.position.isShapeBelowText()) {
            this.properties.put("fBehindDocument", new RtfShapeProperty("fBehindDocument", true));
        }
        if (this.inTable) {
            this.properties.put("fLayoutInCell", new RtfShapeProperty("fLayoutInCell", true));
        }
        if (this.properties.containsKey("posh")) {
            this.position.setIgnoreXRelative(true);
        }
        if (this.properties.containsKey("posv")) {
            this.position.setIgnoreYRelative(true);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(OPEN_GROUP);
            byteArrayOutputStream.write("\\shp".getBytes());
            byteArrayOutputStream.write("\\shplid".getBytes());
            byteArrayOutputStream.write(this.intToByteArray(this.shapeNr));
            byteArrayOutputStream.write(this.position.write());
            switch (this.wrapping) {
                case 0: {
                    byteArrayOutputStream.write("\\shpwr3".getBytes());
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write("\\shpwr1".getBytes());
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write("\\shpwr2".getBytes());
                    byteArrayOutputStream.write("\\shpwrk0".getBytes());
                    break;
                }
                case 3: {
                    byteArrayOutputStream.write("\\shpwr2".getBytes());
                    byteArrayOutputStream.write("\\shpwrk1".getBytes());
                    break;
                }
                case 4: {
                    byteArrayOutputStream.write("\\shpwr2".getBytes());
                    byteArrayOutputStream.write("\\shpwrk2".getBytes());
                    break;
                }
                case 5: {
                    byteArrayOutputStream.write("\\shpwr2".getBytes());
                    byteArrayOutputStream.write("\\shpwrk3".getBytes());
                    break;
                }
                case 6: {
                    byteArrayOutputStream.write("\\shpwr4".getBytes());
                    byteArrayOutputStream.write("\\shpwrk0".getBytes());
                    break;
                }
                case 7: {
                    byteArrayOutputStream.write("\\shpwr4".getBytes());
                    byteArrayOutputStream.write("\\shpwrk1".getBytes());
                    break;
                }
                case 8: {
                    byteArrayOutputStream.write("\\shpwr4".getBytes());
                    byteArrayOutputStream.write("\\shpwrk2".getBytes());
                    break;
                }
                case 9: {
                    byteArrayOutputStream.write("\\shpwr4".getBytes());
                    byteArrayOutputStream.write("\\shpwrk3".getBytes());
                    break;
                }
                case 10: {
                    byteArrayOutputStream.write("\\shpwr5".getBytes());
                    break;
                }
                default: {
                    byteArrayOutputStream.write("\\shpwr3".getBytes());
                }
            }
            if (this.inHeader) {
                byteArrayOutputStream.write("\\shpfhdr1".getBytes());
            }
            if (this.doc.getDocumentSettings().isOutputDebugLineBreaks()) {
                byteArrayOutputStream.write(10);
            }
            byteArrayOutputStream.write(OPEN_GROUP);
            byteArrayOutputStream.write("\\*\\shpinst".getBytes());
            Iterator iterator = this.properties.values().iterator();
            while (iterator.hasNext()) {
                byteArrayOutputStream.write(((RtfShapeProperty)iterator.next()).write());
            }
            if (!this.shapeText.equals("")) {
                byteArrayOutputStream.write(OPEN_GROUP);
                byteArrayOutputStream.write("\\shptxt".getBytes());
                byteArrayOutputStream.write(DELIMITER);
                byteArrayOutputStream.write(this.shapeText.getBytes());
                byteArrayOutputStream.write(CLOSE_GROUP);
            }
            byteArrayOutputStream.write(CLOSE_GROUP);
            if (this.doc.getDocumentSettings().isOutputDebugLineBreaks()) {
                byteArrayOutputStream.write(10);
            }
            byteArrayOutputStream.write(CLOSE_GROUP);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

