/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.AbstractCrosstabModelTask;
import org.eclipse.birt.report.item.crosstab.core.de.internal.CrosstabModelUtil;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabExtendedItemFactory;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class LevelViewTask
extends AbstractCrosstabModelTask {
    protected LevelViewHandle focus = null;

    public LevelViewTask(LevelViewHandle levelView) {
        super(levelView);
        this.focus = levelView;
    }

    public CrosstabCellHandle addSubTotal(List measureList, List functionList) throws SemanticException {
        return this.addSubTotal(measureList, functionList, true);
    }

    CrosstabCellHandle addSubTotal(List measureList, List functionList, boolean needTransaction) throws SemanticException {
        if (this.focus == null || !this.isValidParameters(functionList, measureList)) {
            return null;
        }
        this.verifyTotalMeasureFunctions(this.focus.getAxisType(), functionList, measureList);
        if (this.focus.isInnerMost()) {
            this.focus.getLogger().log(Level.WARNING, "This level: [" + this.focus.getModelHandle().getName() + "] can not add aggregation for it is innermost");
            return null;
        }
        if (this.focus.getAggregationHeader() != null) {
            this.focus.getLogger().log(Level.INFO, "the aggregation header is set");
        }
        CommandStack stack = null;
        if (needTransaction) {
            stack = this.focus.getCommandStack();
            stack.startTrans(Messages.getString("LevelViewTask.msg.add.subtotal"));
        }
        try {
            if (this.focus.getAggregationHeader() == null) {
                this.focus.getAggregationHeaderProperty().add((DesignElementHandle)CrosstabExtendedItemFactory.createCrosstabCell(this.focus.getModuleHandle()));
            }
            if (this.crosstab != null && measureList != null) {
                this.addMeasureAggregations(this.focus, measureList, functionList, false);
            }
            this.validateCrosstab();
        }
        catch (SemanticException e) {
            this.focus.getLogger().log(Level.WARNING, e.getMessage(), e);
            if (needTransaction) {
                stack.rollback();
            }
            throw e;
        }
        if (needTransaction) {
            stack.commit();
        }
        return this.focus.getAggregationHeader();
    }

    public void removeSubTotal() throws SemanticException {
        if (this.focus.getAggregationHeader() != null) {
            CommandStack stack = this.focus.getCommandStack();
            stack.startTrans(Messages.getString("LevelViewTask.msg.remove.subtotal"));
            try {
                if (this.crosstab != null) {
                    this.removeMeasureAggregations(this.focus);
                }
                this.focus.getAggregationHeaderProperty().drop(0);
            }
            catch (SemanticException e) {
                this.focus.getLogger().log(Level.WARNING, e.getMessage(), e);
                stack.rollback();
                throw e;
            }
            stack.commit();
        }
    }

    public void removeSubTotal(int measureIndex) throws SemanticException {
        if (this.focus.getAggregationHeader() != null) {
            CommandStack stack = this.focus.getCommandStack();
            stack.startTrans(Messages.getString("LevelViewTask.msg.remove.subtotal"));
            try {
                if (this.crosstab != null) {
                    this.removeMeasureAggregations(this.focus, measureIndex);
                }
                if (this.getAggregationMeasures().size() == 0) {
                    this.focus.getAggregationHeaderProperty().drop(0);
                }
            }
            catch (SemanticException e) {
                this.focus.getLogger().log(Level.WARNING, e.getMessage(), e);
                stack.rollback();
                throw e;
            }
            stack.commit();
        }
    }

    public void validateLevelView() throws SemanticException {
        if (this.crosstab == null) {
            return;
        }
        String levelName = this.focus.getCubeLevelName();
        if (levelName == null || levelName.length() == 0) {
            return;
        }
        int axisType = this.focus.getAxisType();
        String measureDirection = this.crosstab.getMeasureDirection();
        boolean isInnerMost = this.focus.isInnerMost();
        if (this.needValidate(axisType, isInnerMost, measureDirection)) {
            CommandStack stack = this.crosstab.getCommandStack();
            stack.startTrans("Validate Level");
            try {
                this.doValidateAggregations(axisType);
            }
            catch (SemanticException e) {
                stack.rollback();
                throw e;
            }
            stack.commit();
        }
    }

    private boolean needValidate(int axisType, boolean isInnerMost, String measureDirection) {
        if (isInnerMost) {
            return true;
        }
        if ("horizontal".equals(measureDirection) && axisType == 1) {
            return true;
        }
        return "vertical".equals(measureDirection) && axisType == 0;
    }

    private void doValidateAggregations(int axisType) throws SemanticException {
        List aggregationLevelList = CrosstabModelUtil.getAllAggregationLevels(this.crosstab, CrosstabModelUtil.getOppositeAxisType(axisType));
        int i = 0;
        while (i < this.crosstab.getMeasureCount()) {
            MeasureViewHandle measureView = this.crosstab.getMeasure(i);
            this.validateMeasure(measureView, this.focus, axisType, aggregationLevelList);
            ++i;
        }
    }

    public String getAggregationFunction(MeasureViewHandle measureView) {
        String function;
        if (this.focus == null) {
            return null;
        }
        String levelName = this.focus.getCubeLevelName();
        if (this.focus.getAggregationHeader() == null || levelName == null || levelName.length() <= 0 || measureView == null) {
            return null;
        }
        if (this.crosstab == null || this.crosstab != measureView.getCrosstab()) {
            return null;
        }
        if (this.focus.isInnerMost() && (function = CrosstabModelUtil.getAggregationFunction(this.crosstab, measureView.getCell())) != null) {
            return function;
        }
        int axisType = this.focus.getAxisType();
        String propName = CrosstabModelUtil.getAggregationOnPropName(axisType);
        int j = 0;
        while (j < measureView.getAggregationCount()) {
            String function2;
            AggregationCellHandle cell = measureView.getAggregationCell(j);
            if (levelName.equals(cell.getModelHandle().getStringProperty(propName)) && (function2 = CrosstabModelUtil.getAggregationFunction(this.crosstab, cell)) != null) {
                return function2;
            }
            ++j;
        }
        return null;
    }

    public List getAggregationMeasures() {
        if (this.focus.getAggregationHeader() == null || this.focus.getCubeLevelName() == null || this.focus.getCubeLevelName().length() <= 0) {
            return Collections.EMPTY_LIST;
        }
        if (this.crosstab == null) {
            return Collections.EMPTY_LIST;
        }
        int axisType = this.focus.getAxisType();
        String levelName = this.focus.getCubeLevelName();
        ArrayList<MeasureViewHandle> measures = new ArrayList<MeasureViewHandle>();
        int i = 0;
        while (i < this.crosstab.getMeasureCount()) {
            MeasureViewHandle measureView = this.crosstab.getMeasure(i);
            if (!measures.contains(measureView) && CrosstabModelUtil.isAggregationOn(measureView, levelName, axisType)) {
                measures.add(measureView);
            }
            ++i;
        }
        return measures;
    }

    public void setAggregationFunction(MeasureViewHandle measureView, String function) throws SemanticException {
        if (this.focus.getAggregationHeader() == null || this.focus.getCubeLevelName() == null || this.focus.getCubeLevelName().length() <= 0 || measureView == null) {
            return;
        }
        if (this.crosstab == null || this.crosstab != measureView.getCrosstab()) {
            return;
        }
        String levelName = this.focus.getCubeLevelName();
        int axisType = this.focus.getAxisType();
        String propName = CrosstabModelUtil.getAggregationOnPropName(axisType);
        CommandStack stack = this.crosstab.getCommandStack();
        stack.startTrans(Messages.getString("CrosstabReportItemTask.msg.set.aggregate.function"));
        try {
            int j = 0;
            while (j < measureView.getAggregationCount()) {
                AggregationCellHandle cell = measureView.getAggregationCell(j);
                if (levelName.equals(cell.getModelHandle().getStringProperty(propName))) {
                    CrosstabModelUtil.setAggregationFunction(this.crosstab, cell, function);
                }
                ++j;
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }
}

