/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.olap.api.query.ICubeElementFactory;
import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.item.crosstab.core.CrosstabException;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.SortElementHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

public class CrosstabQueryUtil
implements ICrosstabConstants {
    private static ICubeElementFactory factory = null;

    private CrosstabQueryUtil() {
    }

    public static synchronized ICubeElementFactory getCubeElementFactory() throws BirtException {
        if (factory != null) {
            return factory;
        }
        try {
            Class<?> cls = Class.forName("org.eclipse.birt.data.engine.olap.impl.query.CubeElementFactory");
            factory = (ICubeElementFactory)cls.newInstance();
        }
        catch (Exception e) {
            throw new CrosstabException(e);
        }
        return factory;
    }

    public static ICubeQueryDefinition createCubeQuery(CrosstabReportItemHandle crosstabItem, IDataQueryDefinition parentQuery, boolean needMeasure, boolean needRowDimension, boolean needColumnDimension, boolean needBinding, boolean needSorting, boolean needFilter) throws BirtException {
        ILevelDefinition levelDef;
        LevelViewHandle lv;
        IHierarchyDefinition hieDef;
        IDimensionDefinition dimDef;
        DimensionViewHandle dv;
        LevelHandle mirrorLevel;
        ICubeQueryDefinition cubeQuery = CrosstabQueryUtil.getCubeElementFactory().createCubeQuery(crosstabItem.getCubeName());
        ArrayList<String> rowLevelNameList = new ArrayList<String>();
        ArrayList<String> columnLevelNameList = new ArrayList<String>();
        ArrayList<LevelViewHandle> levelViewList = new ArrayList<LevelViewHandle>();
        HashMap<LevelHandle, ILevelDefinition> levelMap = new HashMap<LevelHandle, ILevelDefinition>();
        if (needMeasure) {
            int i = 0;
            while (i < crosstabItem.getMeasureCount()) {
                MeasureViewHandle mv = crosstabItem.getMeasure(i);
                if (!(mv instanceof ComputedMeasureViewHandle)) {
                    if (mv.getCubeMeasure() == null) {
                        throw new CrosstabException(Messages.getString("CrosstabQueryHelper.error.invalid.measure", mv.getCubeMeasureName()));
                    }
                    IMeasureDefinition mDef = cubeQuery.createMeasure(mv.getCubeMeasure().getName());
                    mDef.setAggrFunction(mv.getCubeMeasure().getFunction() == null ? null : DataAdapterUtil.getRollUpAggregationName((String)mv.getCubeMeasure().getFunction()));
                    Iterator mfitr = mv.filtersIterator();
                    if (mfitr != null) {
                        while (mfitr.hasNext()) {
                            FilterConditionElementHandle filterCon = (FilterConditionElementHandle)mfitr.next();
                            ConditionalExpression filterCondExpr = ModuleUtil.isListFilterValue((FilterConditionElementHandle)filterCon) ? new ConditionalExpression(filterCon.getExpr(), DataAdapterUtil.adaptModelFilterOperator((String)filterCon.getOperator()), filterCon.getValue1List()) : new ConditionalExpression(filterCon.getExpr(), DataAdapterUtil.adaptModelFilterOperator((String)filterCon.getOperator()), filterCon.getValue1(), filterCon.getValue2());
                            ICubeFilterDefinition filterDef = CrosstabQueryUtil.getCubeElementFactory().creatCubeFilterDefinition((IBaseExpression)filterCondExpr, null, null, null);
                            cubeQuery.addFilter((IFilterDefinition)filterDef);
                        }
                    }
                }
                ++i;
            }
        }
        if (needRowDimension && crosstabItem.getDimensionCount(0) > 0) {
            IEdgeDefinition rowEdge = cubeQuery.createEdge(1);
            mirrorLevel = crosstabItem.getCrosstabView(0).getMirroredStartingLevel();
            int i = 0;
            while (i < crosstabItem.getDimensionCount(0)) {
                dv = crosstabItem.getDimension(0, i);
                if (dv.getCubeDimension() == null) {
                    throw new CrosstabException(Messages.getString("CrosstabQueryHelper.error.invalid.dimension.row", dv.getCubeDimensionName()));
                }
                dimDef = rowEdge.createDimension(dv.getCubeDimension().getName());
                hieDef = dimDef.createHierarchy(dv.getCubeDimension().getDefaultHierarchy().getName());
                int j = 0;
                while (j < dv.getLevelCount()) {
                    lv = dv.getLevel(j);
                    if (lv.getCubeLevel() == null) {
                        throw new CrosstabException(Messages.getString("CrosstabQueryHelper.error.invalid.level.row", lv.getCubeLevelName()));
                    }
                    levelDef = hieDef.createLevel(lv.getCubeLevel().getName());
                    rowLevelNameList.add(lv.getCubeLevel().getFullName());
                    if (mirrorLevel != null && mirrorLevel.getQualifiedName().equals(lv.getCubeLevelName())) {
                        rowEdge.setMirrorStartingLevel(levelDef);
                    }
                    levelViewList.add(lv);
                    levelMap.put(lv.getCubeLevel(), levelDef);
                    ++j;
                }
                ++i;
            }
        }
        if (needColumnDimension && crosstabItem.getDimensionCount(1) > 0) {
            IEdgeDefinition columnEdge = cubeQuery.createEdge(2);
            mirrorLevel = crosstabItem.getCrosstabView(1).getMirroredStartingLevel();
            int i = 0;
            while (i < crosstabItem.getDimensionCount(1)) {
                dv = crosstabItem.getDimension(1, i);
                if (dv.getCubeDimension() == null) {
                    throw new CrosstabException(Messages.getString("CrosstabQueryHelper.error.invalid.dimension.column", dv.getCubeDimensionName()));
                }
                dimDef = columnEdge.createDimension(dv.getCubeDimension().getName());
                hieDef = dimDef.createHierarchy(dv.getCubeDimension().getDefaultHierarchy().getName());
                int j = 0;
                while (j < dv.getLevelCount()) {
                    lv = dv.getLevel(j);
                    if (lv.getCubeLevel() == null) {
                        throw new CrosstabException(Messages.getString("CrosstabQueryHelper.error.invalid.level.column", lv.getCubeLevelName()));
                    }
                    levelDef = hieDef.createLevel(lv.getCubeLevel().getName());
                    columnLevelNameList.add(lv.getCubeLevel().getFullName());
                    if (mirrorLevel != null && mirrorLevel.getQualifiedName().equals(lv.getCubeLevelName())) {
                        columnEdge.setMirrorStartingLevel(levelDef);
                    }
                    levelViewList.add(lv);
                    levelMap.put(lv.getCubeLevel(), levelDef);
                    ++j;
                }
                ++i;
            }
        }
        if (needSorting) {
            CrosstabQueryUtil.addLevelSorting(levelViewList, levelMap, cubeQuery);
        }
        if (needFilter) {
            CrosstabQueryUtil.addLevelFilter(levelViewList, levelMap, cubeQuery);
        }
        if (needBinding) {
            Iterator bindingItr = ((ExtendedItemHandle)crosstabItem.getModelHandle()).columnBindingsIterator();
            ModuleHandle module = ((ExtendedItemHandle)crosstabItem.getModelHandle()).getModuleHandle();
            if (bindingItr != null) {
                HashMap<String, String> cache = new HashMap<String, String>();
                while (bindingItr.hasNext()) {
                    ComputedColumnHandle column = (ComputedColumnHandle)bindingItr.next();
                    Binding binding = new Binding(column.getName());
                    binding.setAggrFunction(column.getAggregateFunction() == null ? null : DataAdapterUtil.adaptModelAggregationType((String)column.getAggregateFunction()));
                    binding.setExpression((IBaseExpression)(column.getExpression() == null ? null : new ScriptExpression(column.getExpression())));
                    binding.setDataType(DataAdapterUtil.adaptModelDataType((String)column.getDataType()));
                    if (column.getFilterExpression() != null) {
                        binding.setFilter((IBaseExpression)new ScriptExpression(column.getFilterExpression()));
                    }
                    Iterator argItr = column.argumentsIterator();
                    while (argItr.hasNext()) {
                        AggregationArgumentHandle aah = (AggregationArgumentHandle)argItr.next();
                        if (aah.getValue() == null) continue;
                        binding.addArgument((IBaseExpression)new ScriptExpression(aah.getValue()));
                    }
                    List aggrList = column.getAggregateOnList();
                    if (aggrList != null) {
                        for (String baseLevel : aggrList) {
                            CrosstabUtil.addHierachyAggregateOn(module, binding, baseLevel, rowLevelNameList, columnLevelNameList, cache);
                        }
                    }
                    cubeQuery.addBinding((IBinding)binding);
                }
            }
        }
        return cubeQuery;
    }

    private static void addMembers(Map levelMap, List levels, List values, MemberValueHandle member) {
        Object levelDef;
        if (member != null && (levelDef = levelMap.get(member.getLevel())) != null) {
            levels.add(levelDef);
            values.add(member.getValue());
            if (member.getContentCount("memberValues") > 0) {
                CrosstabQueryUtil.addMembers(levelMap, levels, values, (MemberValueHandle)member.getContent("memberValues", 0));
            }
        }
    }

    private static void addLevelSorting(List levelViews, Map levelMap, ICubeQueryDefinition cubeQuery) throws BirtException {
        ArrayList levels = new ArrayList();
        ArrayList values = new ArrayList();
        for (LevelViewHandle lv : levelViews) {
            Iterator sortItr = lv.sortsIterator();
            if (sortItr == null) continue;
            while (sortItr.hasNext()) {
                SortElementHandle sortKey = (SortElementHandle)sortItr.next();
                levels.clear();
                values.clear();
                CrosstabQueryUtil.addMembers(levelMap, levels, values, sortKey.getMember());
                ILevelDefinition[] qualifyLevels = null;
                Object[] qualifyValues = null;
                if (levels.size() > 0) {
                    qualifyLevels = levels.toArray(new ILevelDefinition[levels.size()]);
                    qualifyValues = values.toArray(new Object[values.size()]);
                }
                ICubeSortDefinition sortDef = CrosstabQueryUtil.getCubeElementFactory().createCubeSortDefinition(sortKey.getKey(), (ILevelDefinition)levelMap.get(lv.getCubeLevel()), qualifyLevels, qualifyValues, DataAdapterUtil.adaptModelSortDirection((String)sortKey.getDirection()));
                cubeQuery.addSort((ISortDefinition)sortDef);
            }
        }
    }

    private static void addLevelFilter(List levelViews, Map levelMap, ICubeQueryDefinition cubeQuery) throws BirtException {
        ArrayList levels = new ArrayList();
        ArrayList values = new ArrayList();
        for (LevelViewHandle lv : levelViews) {
            Iterator filterItr = lv.filtersIterator();
            if (filterItr == null) continue;
            while (filterItr.hasNext()) {
                FilterConditionElementHandle filterCon = (FilterConditionElementHandle)filterItr.next();
                levels.clear();
                values.clear();
                CrosstabQueryUtil.addMembers(levelMap, levels, values, filterCon.getMember());
                ILevelDefinition[] qualifyLevels = null;
                Object[] qualifyValues = null;
                if (levels.size() > 0) {
                    qualifyLevels = levels.toArray(new ILevelDefinition[levels.size()]);
                    qualifyValues = values.toArray(new Object[values.size()]);
                }
                ConditionalExpression filterCondExpr = ModuleUtil.isListFilterValue((FilterConditionElementHandle)filterCon) ? new ConditionalExpression(filterCon.getExpr(), DataAdapterUtil.adaptModelFilterOperator((String)filterCon.getOperator()), filterCon.getValue1List()) : new ConditionalExpression(filterCon.getExpr(), DataAdapterUtil.adaptModelFilterOperator((String)filterCon.getOperator()), filterCon.getValue1(), filterCon.getValue2());
                ICubeFilterDefinition filterDef = CrosstabQueryUtil.getCubeElementFactory().creatCubeFilterDefinition((IBaseExpression)filterCondExpr, (ILevelDefinition)levelMap.get(lv.getCubeLevel()), qualifyLevels, qualifyValues);
                cubeQuery.addFilter((IFilterDefinition)filterDef);
            }
        }
    }
}

