/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;

public class CrosstabCellExecutor
extends BaseCrosstabExecutor {
    private static final Logger logger = Logger.getLogger(CrosstabCellExecutor.class.getName());
    private CrosstabCellHandle cellHandle;
    private int rowSpan;
    private int colSpan;
    private int colIndex;
    private List contents;
    private int currentChild;
    private long position = -1L;
    private boolean isForceEmpty;

    public CrosstabCellExecutor(BaseCrosstabExecutor parent, CrosstabCellHandle handle, int rowSpan, int colSpan, int colIndex) {
        super(parent);
        this.cellHandle = handle;
        if (this.cellHandle != null) {
            this.contents = this.cellHandle.getContents();
        }
        this.rowSpan = rowSpan;
        this.colSpan = colSpan;
        this.colIndex = colIndex;
    }

    public void setPosition(long pos) {
        this.position = pos;
    }

    public void setForceEmpty(boolean isEmpty) {
        this.isForceEmpty = isEmpty;
    }

    public IContent execute() {
        ICellContent content = this.context.getReportContent().createCellContent();
        this.initializeContent((IContent)content, this.cellHandle);
        content.setRowSpan(this.rowSpan);
        content.setColSpan(this.colSpan);
        content.setColumn(this.colIndex);
        try {
            EdgeCursor columnEdgeCursor = this.getColumnEdgeCursor();
            if (columnEdgeCursor != null) {
                columnEdgeCursor.setPosition(this.position);
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabCellExecutor.error.restor.data.position"), e);
        }
        this.processStyle(this.cellHandle);
        this.processVisibility(this.cellHandle);
        this.processBookmark(this.cellHandle);
        this.processAction(this.cellHandle);
        this.currentChild = 0;
        ICubeResultSet cubeRset = this.getCubeResultSet();
        DataID di = cubeRset == null ? null : new DataID(cubeRset.getID(), cubeRset.getCellIndex());
        InstanceID iid = new InstanceID(null, this.cellHandle == null ? -1L : this.cellHandle.getModelHandle().getID(), di);
        content.setInstanceID(iid);
        return content;
    }

    public IReportItemExecutor getNextChild() {
        if (this.isForceEmpty) {
            return null;
        }
        try {
            EdgeCursor columnEdgeCursor = this.getColumnEdgeCursor();
            if (columnEdgeCursor != null) {
                columnEdgeCursor.setPosition(this.position);
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabCellExecutor.error.restor.data.position"), e);
        }
        IReportItemExecutor executor = this.context.createExecutor((IReportItemExecutor)this, this.contents.get(this.currentChild++));
        return executor;
    }

    public boolean hasNextChild() {
        if (this.isForceEmpty) {
            return false;
        }
        if (this.contents != null) {
            return this.currentChild < this.contents.size();
        }
        return false;
    }
}

