/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IExecutorContext;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CachedColumnWalker;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabFooterExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabGroupExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabHeaderExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabMeasureExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;
import org.eclipse.birt.report.item.crosstab.core.re.executor.TableColumnGenerator;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;

public class CrosstabReportItemExecutor
extends BaseCrosstabExecutor {
    private static Logger logger = Logger.getLogger(CrosstabReportItemExecutor.class.getName());
    private List children;
    private int currentChild;
    private EdgeCursor rowCursor;
    private List groupCursors;
    private int measureCount;
    private boolean endOfGroups;
    private boolean needRowGroups;
    boolean notifyNextGroupPageBreak;

    public CrosstabReportItemExecutor() {
    }

    public CrosstabReportItemExecutor(CrosstabReportItemHandle item, IExecutorContext context, IReportItemExecutor parentExecutor) {
        super(context, item, parentExecutor);
    }

    public void close() {
        super.close();
        this.closeQuery();
        this.children = null;
        this.rowCursor = null;
        this.groupCursors = null;
    }

    public void setModelObject(Object handle) {
        super.setModelObject(handle);
        if (handle instanceof ExtendedItemHandle) {
            ExtendedItemHandle exHandle = (ExtendedItemHandle)handle;
            IReportItem item = null;
            try {
                item = exHandle.getReportItem();
            }
            catch (ExtendedElementException e) {
                logger.log(Level.SEVERE, Messages.getString("CrosstabReportItemExecutor.error.crosstab.loading"), e);
            }
            this.crosstabItem = (CrosstabReportItemHandle)item;
        }
    }

    public IContent execute() {
        ITableContent content = this.context.getReportContent().createTableContent();
        this.executeQuery(this.crosstabItem);
        this.initializeContent((IContent)content, this.crosstabItem);
        this.processStyle(this.crosstabItem);
        this.processVisibility(this.crosstabItem);
        this.processBookmark(this.crosstabItem);
        this.processAction(this.crosstabItem);
        content.setCaption(this.crosstabItem.getCaption());
        content.setCaptionKey(this.crosstabItem.getCaptionKey());
        content.setSummary(this.crosstabItem.getSummary());
        content.setHeaderRepeat(this.crosstabItem.isRepeatColumnHeader());
        if (this.getCubeCursor() != null) {
            this.styleCache = new HashMap();
            try {
                this.rowGroups = GroupUtil.getGroups(this.crosstabItem, 0);
                this.columnGroups = GroupUtil.getGroups(this.crosstabItem, 1);
                this.rowLevelPageBreakIntervals = GroupUtil.getLevelPageBreakIntervals(this.crosstabItem, this.rowGroups, 0);
                this.walker = new CachedColumnWalker(this.crosstabItem, this.getColumnEdgeCursor());
                new TableColumnGenerator(this.crosstabItem, this.walker, (IBaseResultSet)this.getCubeResultSet(), this.getColumnEdgeCursor(), this.columnGroups).generateColumns(this.context.getReportContent(), content);
                this.prepareChildren();
            }
            catch (OLAPException e) {
                logger.log(Level.SEVERE, Messages.getString("CrosstabReportItemExecutor.error.generate.columns"), e);
            }
        } else {
            logger.log(Level.SEVERE, Messages.getString("CrosstabReportItemExecutor.error.invalid.cube.result"));
        }
        return content;
    }

    private void prepareChildren() throws OLAPException {
        this.needRowGroups = false;
        this.measureCount = this.crosstabItem.getMeasureCount();
        this.rowCursor = this.getRowEdgeCursor();
        if (this.rowGroups.size() > 0 && this.rowCursor != null) {
            this.rowCursor.beforeFirst();
            if (this.rowCursor.next()) {
                this.groupCursors = this.rowCursor.getDimensionCursor();
                this.needRowGroups = true;
            }
        }
        if (this.needRowGroups) {
            this.collectExecutable();
        } else {
            this.currentChild = 0;
            this.children = new ArrayList();
            if (this.columnGroups.size() > 0 || GroupUtil.hasMeasureHeader(this.crosstabItem, 1)) {
                CrosstabHeaderExecutor headerExecutor = new CrosstabHeaderExecutor(this);
                this.children.add(headerExecutor);
            }
            if (this.measureCount > 0 && this.rowCursor == null) {
                CrosstabMeasureExecutor measureExecutor = new CrosstabMeasureExecutor(this);
                this.children.add(measureExecutor);
            }
            if (this.rowGroups.size() > 0 && this.rowCursor != null && this.crosstabItem.getGrandTotal(0) != null && this.measureCount > 0) {
                CrosstabFooterExecutor totalExecutor = new CrosstabFooterExecutor(this);
                this.children.add(totalExecutor);
            }
        }
    }

    private void collectExecutable() throws OLAPException {
        this.endOfGroups = false;
        this.currentChild = 0;
        this.children = new ArrayList();
        int startingGroupIndex = GroupUtil.getStartingGroupLevel(this.rowCursor, this.groupCursors);
        if (startingGroupIndex <= 0 && (this.columnGroups.size() > 0 || GroupUtil.hasMeasureHeader(this.crosstabItem, 1) || this.crosstabItem.getHeader() != null)) {
            CrosstabHeaderExecutor headerExecutor = new CrosstabHeaderExecutor(this);
            this.children.add(headerExecutor);
        }
        CrosstabGroupExecutor groupExecutor = new CrosstabGroupExecutor(this, 0, this.rowCursor);
        this.children.add(groupExecutor);
        int endingGroupIndex = GroupUtil.getEndingGroupLevel(this.rowCursor, this.groupCursors);
        if (endingGroupIndex <= 0) {
            if (this.crosstabItem.getGrandTotal(0) != null && this.measureCount > 0) {
                CrosstabFooterExecutor totalExecutor = new CrosstabFooterExecutor(this);
                this.children.add(totalExecutor);
            }
            this.endOfGroups = true;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean hasNextChild() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            return (IReportItemExecutor)this.children.get(this.currentChild++);
        }
        return null;
    }
}

