/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.script.internal;

import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.instance.IScriptStyle;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.script.internal.instance.StyleInstance;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.script.ICrosstabCellInstance;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.UserPropertyDefnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;

public class CrosstabCellInstanceImpl
implements ICrosstabCellInstance {
    private IReportContext context;
    private ICellContent content;
    private ExtendedItemHandle modelHandle;
    private long id = -1L;
    private String type = "header";

    public CrosstabCellInstanceImpl(ICellContent content, ExtendedItemHandle modelHandle, IReportContext context) {
        this.content = content;
        this.modelHandle = modelHandle;
        this.context = context;
        if (modelHandle != null) {
            this.id = modelHandle.getID();
        }
        try {
            IReportItem item = modelHandle.getReportItem();
            if (item instanceof AggregationCellHandle) {
                this.type = "aggregation";
            }
        }
        catch (ExtendedElementException e) {
            e.printStackTrace();
        }
    }

    public long getCellID() {
        return this.id;
    }

    public String getCellType() {
        return this.type;
    }

    public Object getDataValue(String bindingName) throws BirtException {
        if (this.context != null && bindingName != null) {
            return this.context.evaluate(ExpressionUtil.createJSDataExpression((String)bindingName));
        }
        return null;
    }

    public String getHeight() {
        DimensionType height = this.content.getHeight();
        if (height != null) {
            return height.toString();
        }
        return null;
    }

    public String getHelpText() {
        return this.content.getHelpText();
    }

    public String getHorizontalPosition() {
        DimensionType x = this.content.getX();
        if (x != null) {
            return x.toString();
        }
        return null;
    }

    public String getName() {
        return this.content.getName();
    }

    public Object getNamedExpressionValue(String name) {
        return null;
    }

    public IScriptStyle getStyle() {
        return new StyleInstance(this.content.getStyle());
    }

    public Object getUserPropertyValue(String name) {
        UserPropertyDefnHandle prop;
        if (this.modelHandle != null && (prop = this.modelHandle.getUserPropertyDefnHandle(name)) != null) {
            return this.modelHandle.getProperty(prop.getName());
        }
        return null;
    }

    public String getVerticalPosition() {
        DimensionType y = this.content.getY();
        if (y != null) {
            return y.toString();
        }
        return null;
    }

    public String getWidth() {
        DimensionType width = this.content.getWidth();
        if (width != null) {
            return width.toString();
        }
        return null;
    }

    public void setHeight(String height) {
        this.content.setHeight(DimensionType.parserUnit((String)height));
    }

    public void setHelpText(String help) {
        this.content.setHelpText(help);
    }

    public void setHorizontalPosition(String position) {
        this.content.setX(DimensionType.parserUnit((String)position));
    }

    public void setName(String name) {
        this.content.setName(name);
    }

    public void setUserPropertyValue(String name, Object value) throws ScriptException {
        UserPropertyDefnHandle prop;
        if (this.modelHandle != null && (prop = this.modelHandle.getUserPropertyDefnHandle(name)) != null) {
            try {
                this.modelHandle.setProperty(prop.getName(), value);
            }
            catch (SemanticException e) {
                throw new ScriptException(e.getLocalizedMessage());
            }
        }
    }

    public void setVerticalPosition(String position) {
        this.content.setY(DimensionType.parserUnit((String)position));
    }

    public void setWidth(String width) {
        this.content.setWidth(DimensionType.parserUnit((String)width));
    }
}

