/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.script.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.script.ILevel;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.SortElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.simpleapi.IFilterConditionElement;
import org.eclipse.birt.report.model.api.simpleapi.ISimpleElementFactory;
import org.eclipse.birt.report.model.api.simpleapi.ISortElement;
import org.eclipse.birt.report.model.api.simpleapi.SimpleElementFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelImpl
implements ILevel {
    private LevelViewHandle lv;
    private LevelHandle lh;

    public LevelImpl(LevelViewHandle lv) {
        this.lv = lv;
        if (lv != null) {
            this.lh = lv.getCubeLevel();
        }
    }

    @Override
    public String getDimensionName() {
        DimensionHandle dh;
        if (this.lh != null && this.lh.getContainer() != null && (dh = (DimensionHandle)this.lh.getContainer().getContainer()) != null) {
            return dh.getName();
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.lh != null) {
            return this.lh.getName();
        }
        return null;
    }

    @Override
    public void addFilterCondition(IFilterConditionElement filter) throws SemanticException {
        FilterConditionElementHandle fceh = this.lv.getModelHandle().getElementFactory().newFilterConditionElement();
        fceh.setExpr(filter.getExpr());
        fceh.setFilterTarget(filter.getFilterTarget());
        fceh.setOperator(filter.getOperator());
        fceh.setValue1(filter.getValue1List());
        fceh.setValue2(filter.getValue2());
        fceh.setOptional(filter.isOptional());
        this.lv.getModelHandle().add("filter", (DesignElementHandle)fceh);
    }

    @Override
    public List<IFilterConditionElement> getFilterConditions() {
        ArrayList<IFilterConditionElement> filters = new ArrayList<IFilterConditionElement>();
        ISimpleElementFactory factory = SimpleElementFactory.getInstance();
        Iterator itr = this.lv.filtersIterator();
        while (itr.hasNext()) {
            FilterConditionElementHandle feh = (FilterConditionElementHandle)itr.next();
            filters.add((IFilterConditionElement)factory.getElement((DesignElementHandle)feh));
        }
        if (filters.size() > 0) {
            return filters;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void removeAllFilterConditions() throws SemanticException {
        this.lv.getModelHandle().setProperty("filter", null);
    }

    @Override
    public void removeFilterCondition(IFilterConditionElement filter) throws SemanticException {
        if (filter == null) {
            return;
        }
        FilterConditionElementHandle handle = null;
        Iterator itr = this.lv.filtersIterator();
        while (itr.hasNext()) {
            FilterConditionElementHandle feh = (FilterConditionElementHandle)itr.next();
            if (!this.equalFilter(feh, filter)) continue;
            handle = feh;
            break;
        }
        if (handle != null) {
            this.lv.getModelHandle().drop("filter", handle);
        }
    }

    @Override
    public void addSortCondition(ISortElement sort) throws SemanticException {
        SortElementHandle seh = this.lv.getModelHandle().getElementFactory().newSortElement();
        seh.setDirection(sort.getDirection());
        seh.setKey(sort.getKey());
        this.lv.getModelHandle().add("sort", (DesignElementHandle)seh);
    }

    @Override
    public List<ISortElement> getSortConditions() {
        ArrayList<ISortElement> sorts = new ArrayList<ISortElement>();
        ISimpleElementFactory factory = SimpleElementFactory.getInstance();
        Iterator itr = this.lv.sortsIterator();
        while (itr.hasNext()) {
            SortElementHandle seh = (SortElementHandle)itr.next();
            sorts.add((ISortElement)factory.getElement((DesignElementHandle)seh));
        }
        if (sorts.size() > 0) {
            return sorts;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void removeAllSortConditions() throws SemanticException {
        this.lv.getModelHandle().setProperty("sort", null);
    }

    @Override
    public void removeSortCondition(ISortElement sort) throws SemanticException {
        if (sort == null) {
            return;
        }
        SortElementHandle handle = null;
        Iterator itr = this.lv.sortsIterator();
        while (itr.hasNext()) {
            SortElementHandle seh = (SortElementHandle)itr.next();
            if (!this.equalSort(seh, sort)) continue;
            handle = seh;
            break;
        }
        if (handle != null) {
            this.lv.getModelHandle().drop("sort", handle);
        }
    }

    private boolean equalSort(SortElementHandle seh, ISortElement ise) {
        return this.equalString(seh.getDirection(), ise.getDirection()) && this.equalString(seh.getKey(), ise.getKey());
    }

    private boolean equalFilter(FilterConditionElementHandle fceh, IFilterConditionElement ifce) {
        List val1 = fceh.getValue1List();
        List val2 = ifce.getValue1List();
        if (val1 == null || val1.isEmpty() ? val2 != null && !val2.isEmpty() : !val1.equals(val2)) {
            return false;
        }
        return fceh.isOptional() == ifce.isOptional() && this.equalString(fceh.getExpr(), ifce.getExpr()) && this.equalString(fceh.getFilterTarget(), ifce.getFilterTarget()) && this.equalString(fceh.getOperator(), ifce.getOperator()) && this.equalString(fceh.getValue2(), ifce.getValue2());
    }

    private boolean equalString(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }
}

