/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.util.ISaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.IXMLSource;
import org.eclipse.datatools.enablement.oda.xml.util.XMLPath;
import org.eclipse.datatools.enablement.oda.xml.util.XMLPathHolder;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxParser
extends DefaultHandler
implements Runnable {
    private static Logger logger;
    private static final String SAX_PARSER = "org.apache.xerces.parsers.SAXParser";
    private InputStream inputStream;
    private String encoding;
    private ISaxParserConsumer spConsumer;
    private Map cachedValues;
    private boolean stopFlag;
    private boolean useNamespace;
    private Map prefixMap;
    private List exceptions;
    private XMLPathHolder pathHolder;
    private XMLPath currentElementPath;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.enablement.oda.xml.util.SaxParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.datatools.enablement.oda.xml.util.SaxParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public SaxParser(IXMLSource xmlSource, ISaxParserConsumer consumer, boolean useNamespace) throws OdaException {
        this.inputStream = xmlSource.openInputStream();
        this.encoding = "".equals(xmlSource.getEncoding()) ? null : xmlSource.getEncoding();
        this.spConsumer = consumer;
        this.useNamespace = useNamespace;
        this.stopFlag = false;
        this.cachedValues = new HashMap();
        this.exceptions = new ArrayList();
        this.prefixMap = new HashMap();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                Object xmlReader = this.createXMLReader();
                this.setContentHandler(xmlReader);
                this.setErrorHandler(xmlReader);
                this.parse(xmlReader);
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof ThreadStopException)) {
                    logger.log(Level.WARNING, "Exceptions occur during xml parsing", e);
                    this.exceptions.add(e);
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {}
            this.spConsumer.finish();
            throw throwable;
        }
        {
            Object var2_5 = null;
        }
        try {}
        catch (IOException iOException) {}
        this.inputStream.close();
        this.spConsumer.finish();
    }

    public boolean exceptionOccurred() {
        return !this.exceptions.isEmpty();
    }

    private void parse(Object xmlReader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = xmlReader.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.xml.sax.InputSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Method parse = this.getMethod("parse", clazz, classArray);
        InputSource source = new InputSource(this.inputStream);
        source.setEncoding(this.encoding);
        parse.invoke(xmlReader, source);
    }

    private void setErrorHandler(Object xmlReader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = xmlReader.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.xml.sax.ErrorHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Method setErrorHandler = this.getMethod("setErrorHandler", clazz, classArray);
        this.invokeMethod(setErrorHandler, xmlReader, new Object[]{this});
    }

    private void setContentHandler(Object xmlReader) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = xmlReader.getClass();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.xml.sax.ContentHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Method setContentHandler = this.getMethod("setContentHandler", clazz, classArray);
        this.invokeMethod(setContentHandler, xmlReader, new Object[]{this});
    }

    private Object createXMLReader() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            Object xmlReader = Thread.currentThread().getContextClassLoader().loadClass(SAX_PARSER).newInstance();
            return xmlReader;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Class.forName(SAX_PARSER).newInstance();
        }
    }

    private Method getMethod(String methodName, Class targetClass, Class[] argument) throws SecurityException, NoSuchMethodException {
        if (!$assertionsDisabled && methodName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && targetClass == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && argument == null) {
            throw new AssertionError();
        }
        return targetClass.getMethod(methodName, argument);
    }

    private void invokeMethod(Method method, Object targetObject, Object[] argument) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        method.invoke(targetObject, argument);
    }

    public void startDocument() {
        this.pathHolder = new XMLPathHolder();
    }

    public void endDocument() {
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (this.stopFlag) {
            throw new ThreadStopException();
        }
        String elementName = qName;
        if (this.useNamespace && !qName.equals(name)) {
            elementName = String.valueOf(uri.replaceAll("/", "%")) + ":" + name;
        }
        this.pathHolder.startElement(elementName);
        this.currentElementPath = this.pathHolder.getCurrentElementPath();
        this.spConsumer.startElement(this.currentElementPath);
        int i = 0;
        while (i < atts.getLength()) {
            this.spConsumer.manipulateData(this.pathHolder.getCurrentAttrPath(atts.getQName(i)), atts.getValue(i));
            ++i;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value = (String)this.cachedValues.get(this.currentElementPath.getPathString());
        value = value == null ? "" : value;
        this.spConsumer.manipulateData(this.currentElementPath, value);
        this.spConsumer.endElement(this.currentElementPath);
        this.cachedValues.remove(this.currentElementPath.getPathString());
        this.pathHolder.endElement();
        this.currentElementPath = this.pathHolder.getCurrentElementPath();
    }

    public void characters(char[] ch, int start, int length) {
        String pathString = this.currentElementPath.getPathString();
        String currentValue = new String(ch, start, length);
        Object cachedValue = this.cachedValues.get(pathString);
        String value = (cachedValue == null ? "" : cachedValue) + currentValue;
        this.cachedValues.put(pathString, value);
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.prefixMap.put(prefix, uri.replaceAll("/", "%"));
    }

    public Map getPrefixMapping() {
        return this.prefixMap;
    }

    public void stopParsing() {
        this.stopFlag = true;
    }

    private class ThreadStopException
    extends RuntimeException {
        private static final long serialVersionUID = 7871277314833138093L;

        ThreadStopException() {
        }
    }
}

