/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import java.lang.reflect.Array;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.MathUtil;
import org.eclipse.birt.data.aggregation.impl.AggrException;
import org.eclipse.birt.data.engine.core.DataException;

public class Finance {
    private Finance() {
    }

    public static double ddb(double cost, double salvage, double life, int period) throws DataException {
        double prior = 0.0;
        double depr = 0.0;
        if (life <= 0.0 || salvage < 0.0 || cost <= 0.0 || period <= 0 || life == Double.NaN || salvage == Double.NaN || cost == Double.NaN || (double)period == Double.NaN) {
            throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "DDB"));
        }
        double rate = 1.0 / life * 2.0;
        int x = 0;
        while (x < period) {
            double basis = cost - prior;
            depr = Math.min(basis - salvage, basis * rate);
            prior += depr;
            ++x;
        }
        return depr;
    }

    public static double sln(double cost, double salvage, double life) throws DataException {
        if (life <= 0.0 || salvage < 0.0 || cost <= 0.0) {
            throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "SLN"));
        }
        return (cost - salvage) / life;
    }

    public static double syd(double cost, double salvage, double life, int period) throws DataException {
        int denom = 0;
        double depr = 0.0;
        if (life <= 0.0 || salvage < 0.0 || cost <= 0.0 || period <= 0) {
            throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "SYD"));
        }
        int i = 1;
        while ((double)i <= life) {
            denom += i;
            ++i;
        }
        int x = 1;
        while (x <= period) {
            double rate = (life - (double)x + 1.0) / (double)denom;
            depr = Math.min(cost - salvage, (cost - salvage) * rate);
            ++x;
        }
        return depr;
    }

    public static double fv(double rate, int nPer, double pmt, double pv, int due) throws DataException {
        double fv = 0.0;
        int start = 0;
        int end = 0;
        if (rate < 0.0 || nPer < 0 || due != 1 && due != 0) {
            throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "fv"));
        }
        switch (due) {
            case 1: {
                start = 1;
                end = nPer;
                break;
            }
            case 0: {
                start = 0;
                end = nPer - 1;
                break;
            }
            default: {
                throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "fv"));
            }
        }
        int i = start;
        while (i <= end) {
            fv += Math.pow(1.0 + rate, i);
            ++i;
        }
        fv *= pmt;
        if (pv != 0.0) {
            fv += pv * Math.pow(1.0 + rate, new Integer(nPer).doubleValue());
        }
        return 0.0 - fv;
    }

    public static double pmt(double rate, int nper, double pv, double fv, int due) throws DataException {
        double curr;
        int start_pv = 0;
        int end_pv = 0;
        int start_fv = 0;
        int end_fv = 0;
        double pmt = 0.0;
        double df_pv = 0.0;
        double df_fv = 0.0;
        switch (due) {
            case 0: {
                start_pv = 1;
                end_pv = nper;
                start_fv = 0;
                end_fv = nper - 1;
                break;
            }
            case 1: {
                start_pv = 0;
                end_pv = nper - 1;
                start_fv = 1;
                end_fv = nper;
                break;
            }
            default: {
                throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "pmt"));
            }
        }
        int t = start_pv;
        while (t <= end_pv) {
            curr = Math.pow(1.0 + rate, new Integer(t).doubleValue());
            df_pv += 1.0 / curr;
            ++t;
        }
        t = start_fv;
        while (t <= end_fv) {
            curr = Math.pow(1.0 + rate, new Integer(t).doubleValue());
            df_fv += curr;
            ++t;
        }
        pmt = pv / df_pv + fv / df_fv;
        return -pmt;
    }

    public static double ipmt(double rate, int per, int nPer, double pv, double fv, int due) throws DataException {
        double ipmt = 0.0;
        double ppmt = 0.0;
        if (rate < 0.0 || nPer < 0 || per > nPer || due != 1 && due != 0) {
            throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "IPMT"));
        }
        double pmt = Math.abs(Finance.pmt(rate, nPer, pv, fv, due));
        double principal = Math.abs(pv);
        int curper = 1;
        while (curper <= per) {
            if (curper != 1 || due == 0) {
                ipmt = rate * principal;
            }
            ppmt = pmt - ipmt;
            principal -= ppmt;
            ++curper;
        }
        if (pv > 0.0 || pv == 0.0 && fv > 0.0) {
            ipmt *= -1.0;
        }
        return ipmt;
    }

    public static double ppmt(double rate, int per, int nPer, double pv, double fv, int due) throws DataException {
        double ipmt = 0.0;
        double ppmt = 0.0;
        if (rate < 0.0 || nPer < 0 || per > nPer || due != 1 && due != 0) {
            throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "PPMT"));
        }
        double pmt = Math.abs(Finance.pmt(rate, nPer, pv, fv, due));
        double principal = Math.abs(pv);
        int curper = 1;
        while (curper <= per) {
            if (curper != 1 || due == 0) {
                ipmt = rate * principal;
            }
            ppmt = pmt - ipmt;
            principal -= ppmt;
            ++curper;
        }
        if (pv > 0.0 || pv == 0.0 && fv > 0.0) {
            ppmt *= -1.0;
        }
        return ppmt;
    }

    public static int nPer(double rate, double pmt, double pv, double fv, int due) throws DataException {
        if (rate < 0.0 || pmt == 0.0 || due != 1 && due != 0 || Math.abs(pv) * rate >= Math.abs(pmt) || Math.abs(fv) * rate >= Math.abs(pmt)) {
            throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "NPER"));
        }
        int FvPeriod = 0;
        int PvPeriod = 0;
        int nPer = 0;
        double currentvalue = 0.0;
        if (pv != 0.0) {
            if (pv * pmt < 0.0) {
                currentvalue = Math.abs(pv);
                if (due == 1) {
                    currentvalue -= currentvalue * rate;
                }
                while (currentvalue > 0.0) {
                    currentvalue += currentvalue * rate;
                    currentvalue -= Math.abs(pmt);
                    ++PvPeriod;
                }
            } else {
                currentvalue = Math.abs(pmt);
                if (due == 1) {
                    pv *= 1.0 + rate;
                }
                while (currentvalue < Math.abs(pv)) {
                    currentvalue += currentvalue * rate;
                    currentvalue += Math.abs(pmt);
                    --PvPeriod;
                }
            }
        }
        if (fv != 0.0) {
            if (fv * pmt < 0.0) {
                currentvalue = Math.abs(pmt);
                if (due == 0) {
                    currentvalue = 0.0;
                }
                while (currentvalue < Math.abs(fv)) {
                    currentvalue += currentvalue * rate;
                    currentvalue += Math.abs(pmt);
                    ++FvPeriod;
                }
            } else {
                FvPeriod = 1;
                currentvalue = Math.abs(fv);
                if (due == 1) {
                    currentvalue -= currentvalue * rate;
                }
                while (currentvalue > 0.0) {
                    currentvalue += currentvalue * rate;
                    currentvalue -= Math.abs(pmt);
                    --FvPeriod;
                }
            }
        }
        nPer = PvPeriod + FvPeriod;
        return nPer;
    }

    public static double pv(double rate, int nPer, double pmt, double fv, int due) throws DataException {
        double pv = 0.0;
        if (nPer < 0 || due != 1 && due != 0) {
            throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "pv"));
        }
        if (rate < 0.0) {
            pv = -fv - pmt * (double)nPer;
        } else {
            double denom = Math.pow(1.0 + rate, nPer);
            double num = -fv - pmt * (1.0 + rate * (double)due) * (denom - 1.0) / rate;
            pv = num / denom;
        }
        return pv;
    }

    private static double solvePmt(int nPer, double true_pmt, double loanamt, double fv, int due, double rate, double incr, int attempt, boolean found) {
        double tolerance;
        block7: {
            try {
                tolerance = 1.0E-7;
                if (attempt <= 1000) break block7;
                found = false;
                return -1.0;
            }
            catch (Exception exception) {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
        double diff1 = true_pmt - Finance.pmt(rate + incr, nPer, loanamt, fv, due);
        if (Math.abs(diff1) <= tolerance) {
            found = true;
            return rate + incr;
        }
        double diff2 = true_pmt - Finance.pmt(rate, nPer, loanamt, fv, due);
        if (Math.abs(diff2) <= tolerance) {
            found = true;
            return rate;
        }
        if (diff1 * diff2 < 0.0) {
            incr /= 10.0;
        } else {
            rate += incr;
        }
        return Finance.solvePmt(nPer, true_pmt, loanamt, fv, due, rate, incr, ++attempt, found);
    }

    public static double rate(int nPer, double pmt, double pv, double fv, int due, double guess) throws DataException {
        try {
            double tmp;
            double incr = 0.1;
            boolean found = true;
            double result = 0.0;
            if (nPer <= 0 || due != 1 && due != 0) {
                if (nPer <= 0) {
                    throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "rate"));
                }
                throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "rate"));
            }
            int i = 5;
            double curr_guess = guess;
            --i;
            while (i > 0) {
                incr = 0.1;
                tmp = curr_guess;
                try {
                    result = Finance.solvePmt(nPer, pmt, pv, fv, due, tmp, incr, 0, found);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw DataException.wrap((BirtException)new AggrException("aggregation.BadParameterCount", e));
                }
                if (result != -1.0) {
                    return result;
                }
                curr_guess /= 2.0;
                --i;
            }
            i = 4;
            curr_guess = guess * 2.0;
            --i;
            while (i > 0) {
                tmp = curr_guess;
                incr = 0.1;
                result = Finance.solvePmt(nPer, pmt, pv, fv, due, tmp, incr, 0, found);
                if (result != -1.0) {
                    return result;
                }
                curr_guess *= 2.0;
                --i;
            }
            i = 5;
            curr_guess = guess;
            --i;
            while (i > 0) {
                tmp = curr_guess;
                incr = -0.1;
                result = Finance.solvePmt(nPer, pmt, pv, fv, due, tmp, incr, 0, found);
                if (result != -1.0) {
                    return result;
                }
                curr_guess /= 2.0;
                --i;
            }
            i = 4;
            curr_guess = guess * 2.0;
            --i;
            while (i > 0) {
                tmp = curr_guess;
                incr = -0.1;
                result = Finance.solvePmt(nPer, pmt, pv, fv, due, tmp, incr, 0, found);
                if (result != -1.0) {
                    return result;
                }
                curr_guess *= 2.0;
                --i;
            }
        }
        catch (ClassCastException e) {
            throw DataException.wrap((BirtException)new AggrException("aggregation.BadParameterType", e));
        }
        throw DataException.wrap((BirtException)new AggrException("aggregation.ResetRateGuess"));
    }

    public static double percent(double denom, double num) {
        if (num == 0.0) {
            return 0.0;
        }
        assert (denom != 0.0);
        return num / denom * 100.0;
    }

    public static Number npv(Object[] arptr, double rate) throws BirtException {
        long arsize = Array.getLength(arptr);
        Number npv = 0;
        Object dval = 0;
        int i = 1;
        while ((long)i <= arsize) {
            try {
                dval = Array.get(arptr, i - 1);
            }
            catch (Exception exception) {
                throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "npv"));
            }
            npv = MathUtil.add((Object)npv, (Object)MathUtil.divide((Object)dval, (Object)Math.pow(1.0 + rate, i)));
            ++i;
        }
        return npv;
    }

    private static double calcIrr(Object[] cash, double intrate, double inc, int attempt) throws BirtException {
        double tolerance = 1.0E-7;
        if (attempt > 1000) {
            return -1.0;
        }
        Number npv1 = Finance.npv(cash, intrate + inc);
        if (MathUtil.compare((Object)MathUtil.abs((Object)npv1), (Object)tolerance) <= 0) {
            return intrate + inc;
        }
        Number npv2 = Finance.npv(cash, intrate);
        if (MathUtil.compareTo0((Object)MathUtil.multiply((Object)npv2, (Object)npv1)) < 0) {
            inc /= 10.0;
        } else {
            intrate += inc;
        }
        return Finance.calcIrr(cash, intrate, inc, ++attempt);
    }

    public static double irr(Object[] cashFlows, double estimatedResult) throws BirtException {
        int cashFlowsCount = cashFlows.length;
        if (cashFlows == null || cashFlowsCount < 2) {
            throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "irr"));
        }
        if (MathUtil.compareTo0((Object)cashFlows[0]) != 0) {
            Number sumCashFlows = 0.0;
            int numOfNegativeCashFlows = 0;
            int numOfPositiveCashFlows = 0;
            int i = 0;
            while (i < cashFlowsCount) {
                sumCashFlows = MathUtil.add((Object)sumCashFlows, (Object)cashFlows[i]);
                if (MathUtil.compareTo0((Object)cashFlows[i]) > 0) {
                    ++numOfPositiveCashFlows;
                } else if (MathUtil.compareTo0((Object)cashFlows[i]) < 0) {
                    ++numOfNegativeCashFlows;
                }
                ++i;
            }
            if (numOfNegativeCashFlows > 0 && numOfPositiveCashFlows > 0) {
                double irrGuess = 0.1;
                if (!Double.isNaN(estimatedResult)) {
                    irrGuess = estimatedResult >= 0.0 ? estimatedResult : 0.5;
                } else {
                    throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "irr"));
                }
                double irr = MathUtil.compareTo0((Object)sumCashFlows) < 0 ? -irrGuess : irrGuess;
                Object cashFlowStart = cashFlows[0];
                boolean highValueGap = false;
                Number cashValue = 0.0;
                int i2 = 0;
                while (i2 <= 50) {
                    cashValue = MathUtil.toNumber((Object)cashFlowStart);
                    int j = 1;
                    while (j < cashFlowsCount) {
                        cashValue = MathUtil.add((Object)cashValue, (Object)MathUtil.divide((Object)cashFlows[j], (Object)Math.pow(1.0 + irr, j)));
                        ++j;
                    }
                    if (MathUtil.compare((Object)MathUtil.abs((Object)cashValue), (Object)1.0E-7) <= 0) {
                        return irr;
                    }
                    if (MathUtil.compare((Object)cashValue, (Object)0.0) > 0) {
                        if (highValueGap) {
                            irrGuess /= 2.0;
                        }
                        irr += irrGuess;
                        if (highValueGap) {
                            irrGuess -= 1.0E-15;
                            highValueGap = false;
                        }
                    } else {
                        irr -= (irrGuess /= 2.0);
                        highValueGap = true;
                    }
                    if (irrGuess <= 1.0E-15 && MathUtil.compare((Object)MathUtil.abs((Object)cashValue), (Object)1.0E-7) <= 0) {
                        return irr;
                    }
                    ++i2;
                }
            }
        }
        return Double.NaN;
    }

    private static Number calcPNPV(Object[] arptr, long arsize, double rate) throws BirtException {
        Number npv = 0;
        int i = 1;
        while ((long)i <= arsize) {
            Object dval = Array.get(arptr, i - 1);
            if (MathUtil.compareTo0((Object)dval) >= 0) {
                npv = MathUtil.add((Object)npv, (Object)MathUtil.divide((Object)dval, (Object)Math.pow(1.0 + rate, i)));
            }
            ++i;
        }
        return npv;
    }

    private static Number calcNNPV(Object[] arptr, long arsize, double rate) throws BirtException {
        Number npv = 0;
        int i = 1;
        while ((long)i <= arsize) {
            Object dval = Array.get(arptr, i - 1);
            if (MathUtil.compareTo0((Object)dval) < 0) {
                npv = MathUtil.add((Object)npv, (Object)MathUtil.divide((Object)dval, (Object)Math.pow(1.0 + rate, i)));
            }
            ++i;
        }
        return npv;
    }

    public static double mirr(Object[] arptr, double frate, double rrate) throws BirtException {
        long arsize = 0L;
        if (arptr != null) {
            arsize = arptr.length;
        }
        if (arptr == null || frate < 0.0 || rrate < 0.0) {
            throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "mirr"));
        }
        long n = arsize;
        double sign = 1.0;
        Number PNpv = Finance.calcPNPV(arptr, n, rrate);
        Number NNpv = Finance.calcNNPV(arptr, n, frate);
        if (MathUtil.compareTo0((Object)NNpv) == 0) {
            throw DataException.wrap((BirtException)new AggrException("aggregation.BadAggrFuncParam", "mirr"));
        }
        Number divider = MathUtil.multiply((Object)MathUtil.negate((Object)PNpv), (Object)Math.pow(1.0 + rrate, n));
        Number tmp = MathUtil.divide((Object)divider, (Object)MathUtil.multiply((Object)NNpv, (Object)(1.0 + frate)));
        if (MathUtil.compareTo0((Object)tmp) < 0) {
            sign = -1.0;
        }
        return sign * (Math.pow(MathUtil.abs((Object)tmp).doubleValue(), 1.0 / (double)(n - 1L)) - 1.0);
    }
}

