/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;

public class TempDir {
    private static TempDir instance;
    private String path;

    private TempDir(String path) {
        this.path = path;
    }

    public static void createInstance(String path) {
        instance = new TempDir(path);
    }

    public static TempDir getInstance() {
        return instance;
    }

    public String getPath() {
        return this.path;
    }

    public static void release() {
        if (instance != null) {
            final File f = new File(instance.getPath());
            Boolean piTmp0 = null;
            piTmp0 = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return new Boolean(f.exists());
                }
            });
            if (piTmp0.booleanValue()) {
                TempDir.deleteDirectory(f);
            }
            instance = null;
        }
    }

    private static void deleteDirectory(final File dir) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    File[] subFiles = dir.listFiles();
                    if (subFiles != null) {
                        int i = 0;
                        while (i < subFiles.length) {
                            if (subFiles[i].isDirectory()) {
                                TempDir.deleteDirectory(subFiles[i]);
                            } else {
                                this.safeDelete(subFiles[i]);
                            }
                            ++i;
                        }
                    }
                    this.safeDelete(dir);
                    return null;
                }

                private void safeDelete(File file) {
                    if (!file.delete()) {
                        file.deleteOnExit();
                    }
                }
            });
        }
        catch (Exception exception) {}
    }
}

