/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalConcatenate
extends AggrFunction {
    public String getName() {
        return "CONCATENATE";
    }

    public int getType() {
        return 0;
    }

    public int getDataType() {
        return 5;
    }

    public IParameterDefn[] getParameterDefn() {
        IParameterDefn[] paramDefn = new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.ANY, Messages.getString("TotalConcatenate.paramDescription.expression")), new ParameterDefn(Messages.getString("TotalConcatenate.param.separator"), Messages.getString("TotalConcatenate.param.separator"), false, false, SupportedDataTypes.CALCULATABLE, Messages.getString("TotalConcatenate.paramDescription.separator")), new ParameterDefn(Messages.getString("TotalConcatenate.param.maxLength"), Messages.getString("TotalConcatenate.param.maxLength"), true, false, SupportedDataTypes.CALCULATABLE, Messages.getString("TotalConcatenate.paramDescription.maxLength")), new ParameterDefn(Messages.getString("TotalConcatenate.param.showAllValues"), Messages.getString("TotalConcatenate.param.showAllValues"), true, false, SupportedDataTypes.CALCULATABLE, Messages.getString("TotalConcatenate.paramDescription.showAllValues"))};
        return paramDefn;
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    public String getDescription() {
        return Messages.getString("TotalConcatenate.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalConcatenate.displayName");
    }

    private class MyAccumulator
    extends SummaryAccumulator {
        private Collection<String> values;
        private String separator;
        private int maxLength;
        private static final int DEFAULT_MAX_LENGTH = 1024;

        private MyAccumulator() {
        }

        public void start() {
            super.start();
            this.values = null;
            this.separator = "";
            this.maxLength = 1024;
        }

        public void onRow(Object[] args) throws DataException {
            assert (args.length >= 2);
            if (args[0] != null && args[1] != null) {
                try {
                    if (this.values == null) {
                        this.setSeparator(args[1]);
                        if (args.length >= 3) {
                            this.setMaxLength(args[2]);
                            if (args.length == 4) {
                                this.setShowAllValues(args[3]);
                            }
                        }
                    }
                    this.values.add(DataTypeUtil.toString((Object)args[0]));
                }
                catch (BirtException e) {
                    throw new DataException(e.getErrorCode(), (Throwable)e);
                }
            }
        }

        public Object getSummaryValue() {
            if (this.values == null) {
                return null;
            }
            StringBuffer buffer = new StringBuffer();
            for (String currentValue : this.values) {
                if (buffer.length() > this.maxLength - currentValue.length()) break;
                if (currentValue == null || currentValue.trim().length() <= 0) continue;
                buffer.append(currentValue).append(this.separator);
            }
            if (buffer.length() > 0) {
                return buffer.toString().substring(0, buffer.length() - this.separator.length());
            }
            return buffer.toString();
        }

        private void setSeparator(Object source) throws BirtException {
            String value = DataTypeUtil.toString((Object)source);
            if (value == null || value.length() == 0) {
                throw new DataException(String.valueOf(Messages.getString("aggregation.InvalidSeparator")) + TotalConcatenate.this.getName());
            }
            this.separator = value;
        }

        private void setMaxLength(Object source) throws DataException {
            try {
                if (source == null || DataTypeUtil.toString((Object)source).trim().length() == 0) {
                    this.maxLength = 1024;
                } else {
                    int value = DataTypeUtil.toInteger((Object)source);
                    if (value < 1) {
                        throw new DataException(String.valueOf(Messages.getString("aggregation.InvalidParameterValue")) + TotalConcatenate.this.getName());
                    }
                    this.maxLength = value;
                }
            }
            catch (BirtException e) {
                throw new DataException(e.getErrorCode(), (Throwable)e);
            }
        }

        private void setShowAllValues(Object source) throws BirtException {
            boolean showAllValues;
            if (source == null || DataTypeUtil.toString((Object)source).trim().length() == 0) {
                showAllValues = false;
            } else {
                if (!(source instanceof Boolean)) {
                    throw new DataException(String.valueOf(Messages.getString("aggregation.InvalidParameterType")) + TotalConcatenate.this.getName());
                }
                showAllValues = DataTypeUtil.toBoolean((Object)source);
            }
            this.values = showAllValues ? new ArrayList<String>() : new LinkedHashSet<String>();
        }
    }
}

