/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.CallStatement;
import org.eclipse.birt.report.data.oda.jdbc.ConnectionPoolFactory;
import org.eclipse.birt.report.data.oda.jdbc.DataSourceMetaData;
import org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.LogUtil;
import org.eclipse.birt.report.data.oda.jdbc.Statement;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection
implements IConnection {
    protected java.sql.Connection jdbcConn = null;
    private static Logger logger = Logger.getLogger(Connection.class.getName());
    private static final String advancedDataType = "org.eclipse.birt.report.data.oda.jdbc.SPSelectDataSet";
    private Map appContext;
    private Boolean autoCommit = null;
    private int isolationMode = -1;

    public boolean isOpen() throws OdaException {
        return this.jdbcConn != null;
    }

    public void open(Properties connProperties) throws OdaException {
        Object value;
        if (this.appContext != null && (value = this.appContext.get("OdaJDBCDriverPassInConnection")) != null && value instanceof java.sql.Connection) {
            this.jdbcConn = (java.sql.Connection)value;
            logger.logp(Level.FINE, Connection.class.getName(), "open", this.jdbcConn.toString());
            return;
        }
        if (connProperties == null) {
            IllegalArgumentException e = new IllegalArgumentException("connProperties cannot be null");
            logger.logp(Level.FINE, Connection.class.getName(), "open", e.getMessage(), e);
            throw e;
        }
        if (logger.isLoggable(Level.FINE)) {
            String logMsg = "Connection.open(Properties). connProperties = ";
            Enumeration<?> enumeration = connProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String propVal;
                String propName = (String)enumeration.nextElement();
                String lcPropName = propName.toLowerCase();
                if (lcPropName.indexOf("password") >= 0 || lcPropName.indexOf("pwd") >= 0) {
                    propVal = "***";
                } else {
                    propVal = connProperties.getProperty(propName);
                    if (lcPropName.equals("odaurl")) {
                        propVal = LogUtil.encryptURL(propVal);
                    }
                }
                logMsg = String.valueOf(logMsg) + propName + "=" + propVal + ";";
            }
            logger.logp(Level.FINE, Connection.class.getName(), "open", logMsg);
        }
        this.close();
        String dataSource = connProperties.getProperty("odaDataSource");
        if (dataSource != null) {
            UnsupportedOperationException e = new UnsupportedOperationException("Oda-jdbc:connect by data source");
            logger.logp(Level.FINE, Connection.class.getName(), "open", e.getMessage(), e);
            throw e;
        }
        String url = connProperties.getProperty("odaURL");
        String jndiName = connProperties.getProperty("odaJndiName");
        String autoCommit = connProperties.getProperty("odaAutoCommit");
        if (autoCommit != null) {
            this.autoCommit = Boolean.valueOf(autoCommit);
        }
        String isolationMode = connProperties.getProperty("odaIsolationMode");
        this.isolationMode = Constants.getIsolationMode(isolationMode);
        if (!(url != null && url.length() != 0 || jndiName != null && jndiName.length() != 0)) {
            throw new JDBCException("odajdbc.driver.DriverMissingProperties", 112);
        }
        this.connectByUrl(url, connProperties);
    }

    private void connectByUrl(String url, Properties connProperties) throws OdaException {
        assert (connProperties != null);
        assert (url != null);
        Properties props = (Properties)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return new Properties();
            }
        });
        Enumeration<?> enumeration = connProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propName = (String)enumeration.nextElement();
            if (propName.startsWith("oda") || propName.startsWith("Oda")) continue;
            props.setProperty(propName, connProperties.getProperty(propName));
        }
        String user = connProperties.getProperty("odaUser");
        String pwd = connProperties.getProperty("odaPassword");
        props = JDBCDriverManager.addUserAuthenticationProperties(props, user, pwd);
        String driverClass = connProperties.getProperty("odaDriverClass");
        String jndiNameUrl = connProperties.getProperty("odaJndiName");
        try {
            if ((jndiNameUrl == null || jndiNameUrl.trim().length() == 0) && ConnectionPoolFactory.getInstance() != null) {
                this.jdbcConn = ConnectionPoolFactory.getInstance().getConnection(driverClass, url, props, this.getDriverClassPath(), this.appContext);
                this.populateConnectionProp();
            }
        }
        catch (Exception exception) {}
        try {
            if (this.jdbcConn == null) {
                this.jdbcConn = JDBCDriverManager.getInstance().getConnection(driverClass, url, jndiNameUrl, props, this.getDriverClassPath());
                this.populateConnectionProp();
            }
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetConn", e);
        }
    }

    private void populateConnectionProp() throws SQLException {
        if (this.jdbcConn != null) {
            if (this.autoCommit != null) {
                this.jdbcConn.setAutoCommit(this.autoCommit);
            }
            if (this.isolationMode != -1) {
                this.jdbcConn.setTransactionIsolation(this.isolationMode);
            }
        }
    }

    private Collection<String> getDriverClassPath() {
        if (this.appContext == null) {
            return null;
        }
        if (this.appContext.get("OdaJDBCDriverClassPath") == null) {
            return null;
        }
        Object classPath = this.appContext.get("OdaJDBCDriverClassPath");
        if (classPath instanceof String) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(classPath.toString());
            return result;
        }
        if (classPath instanceof Collection) {
            ArrayList<String> result = new ArrayList<String>();
            for (Object aClassPath : (Collection)classPath) {
                if (aClassPath == null) continue;
                result.add(aClassPath.toString());
            }
            return result;
        }
        return null;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        logger.logp(Level.FINE, Connection.class.getName(), "getMetaData", "Connection.getMetaData(" + dataSetType + ")");
        DatabaseMetaData dbMetadata = null;
        if (this.jdbcConn != null) {
            try {
                dbMetadata = this.jdbcConn.getMetaData();
            }
            catch (SQLException e) {
                throw new JDBCException("odajdbc.CannotGetConnMetaData", e);
            }
        }
        return new DataSourceMetaData(this, dbMetadata);
    }

    public IQuery newQuery(String dataSourceType) throws OdaException {
        logger.logp(Level.FINE, Connection.class.getName(), "createStatement", "Connection.createStatement(" + dataSourceType + ")");
        this.assertOpened();
        if (dataSourceType != null && dataSourceType.equalsIgnoreCase(advancedDataType)) {
            return new CallStatement(this.jdbcConn);
        }
        return new Statement(this.jdbcConn);
    }

    public void commit() throws OdaException {
        logger.logp(Level.FINE, Connection.class.getName(), "commit", "Connection.commit()");
        this.assertOpened();
        try {
            this.jdbcConn.commit();
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ConnCommitError", e);
        }
    }

    public void rollback() throws OdaException {
        logger.logp(Level.FINE, Connection.class.getName(), "rollback", "Connection.rollback()");
        this.assertOpened();
        try {
            this.jdbcConn.rollback();
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ConnRollbackError", e);
        }
    }

    public int getMaxQueries() throws OdaException {
        if (this.jdbcConn != null) {
            try {
                DatabaseMetaData dbMetadata = this.jdbcConn.getMetaData();
                return dbMetadata.getMaxStatements();
            }
            catch (SQLException e) {
                throw new JDBCException("odajdbc.CannotGetMaxQuerie", e);
            }
        }
        return 0;
    }

    public void close() throws OdaException {
        logger.logp(Level.FINE, Connection.class.getName(), "close", "Connection closed.");
        if (this.jdbcConn == null) {
            return;
        }
        try {
            if (!this.jdbcConn.isClosed()) {
                this.jdbcConn.close();
            }
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotCloseConn", e);
        }
        this.jdbcConn = null;
    }

    public void setAppContext(Object context) throws OdaException {
        if (context instanceof Map) {
            this.appContext = (Map)context;
        }
    }

    private void assertOpened() throws OdaException {
        if (this.jdbcConn == null) {
            throw new JDBCException("odajdbc.driver.ConnNotOpen", 111);
        }
    }

    public static class Constants {
        public static final String ODAURL = "odaURL";
        public static final String ODAPassword = "odaPassword";
        public static final String ODAUser = "odaUser";
        public static final String ODADriverClass = "odaDriverClass";
        public static final String ODADataSource = "odaDataSource";
        public static final String ODAJndiName = "odaJndiName";
        public static final String CONNECTION_AUTO_COMMIT = "odaAutoCommit";
        public static final String CONNECTION_ISOLATION_MODE = "odaIsolationMode";
        public static final int TRANSCATION_ISOLATION_DEFAULT = -1;
        public static final String TRANSACTION_READ_COMMITTED = "read-committed";
        public static final String TRANSACTION_READ_UNCOMMITTED = "read-uncommitted";
        public static final String TRANSACTION_REPEATABLE_READ = "repeatable-read";
        public static final String TRANSACTION_SERIALIZABLE = "serializable";

        public static int getIsolationMode(String value) {
            if (value == null) {
                return -1;
            }
            if (TRANSACTION_READ_COMMITTED.equals(value)) {
                return 2;
            }
            if (TRANSACTION_READ_UNCOMMITTED.equals(value)) {
                return 1;
            }
            if (TRANSACTION_REPEATABLE_READ.equals(value)) {
                return 4;
            }
            if (TRANSACTION_SERIALIZABLE.equals(value)) {
                return 8;
            }
            return Integer.parseInt(value);
        }
    }
}

