/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.Blob;
import org.eclipse.birt.report.data.oda.jdbc.Clob;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.ResultSetMetaData;
import org.eclipse.birt.report.data.oda.jdbc.SqlBlobUtil;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultSet
implements IResultSet {
    protected java.sql.ResultSet rs;
    protected int maxRows;
    protected int currentRow;
    private static Logger logger = Logger.getLogger(ResultSet.class.getName());

    private void assertNotNull(Object o) throws OdaException {
        if (o == null) {
            throw new JDBCException("odajdbc.driver.ResultSetCannotNull", 115);
        }
    }

    public ResultSet(java.sql.ResultSet jrs) throws OdaException {
        this.rs = jrs;
        this.maxRows = Integer.MAX_VALUE;
        this.currentRow = 0;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        logger.logp(Level.FINE, ResultSet.class.getName(), "getMetaData", "ResultSet.getMetaData( )");
        this.assertNotNull(this.rs);
        try {
            ResultSetMetaData rsMeta = new ResultSetMetaData(this.rs.getMetaData());
            return rsMeta;
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetResultSetMetadata", e);
        }
    }

    public void close() throws OdaException {
        logger.logp(Level.FINE, ResultSet.class.getName(), "close", "ResultSet.close()");
        this.assertNotNull(this.rs);
        try {
            this.rs.close();
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotCloseResultSet", e);
        }
    }

    public void setMaxRows(int max) {
        logger.logp(Level.FINE, ResultSet.class.getName(), "setMaxRows", "ResultSet.setMaxRows( " + max + " )");
        this.maxRows = max > 0 ? max : Integer.MAX_VALUE;
    }

    public boolean next() throws OdaException {
        logger.logp(Level.FINE, ResultSet.class.getName(), "next", "ResultSet.next( )");
        this.assertNotNull(this.rs);
        try {
            if (this.currentRow < this.maxRows && this.rs.next()) {
                ++this.currentRow;
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CursorDownError", e);
        }
    }

    public int getRow() throws OdaException {
        logger.logp(Level.FINE, ResultSet.class.getName(), "getRow", "ResultSet.getRow( )");
        this.assertNotNull(this.rs);
        return this.currentRow;
    }

    public String getString(int index) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            return this.rs.getString(index);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetStringValue", e);
        }
    }

    public String getString(String columnName) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            return this.rs.getString(columnName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetStringValue", e);
        }
    }

    public int getInt(int index) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            return this.rs.getInt(index);
        }
        catch (SQLException e) {
            block6: {
                block7: {
                    try {
                        if (this.rs.getMetaData().getColumnType(index) != -7) break block6;
                        if (!this.rs.getString(index).equals("t")) break block7;
                        return 1;
                    }
                    catch (SQLException sQLException) {
                        throw new JDBCException("odajdbc.ResultSetCannotGetIntValue", e);
                    }
                }
                if (!this.rs.getString(index).equals("f")) break block6;
                return 0;
            }
            throw new JDBCException("odajdbc.ResultSetCannotGetIntValue", e);
        }
    }

    public int getInt(String columnName) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            return this.rs.getInt(columnName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetIntValue", e);
        }
    }

    public double getDouble(int index) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            return this.rs.getDouble(index);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetDoubleValue", e);
        }
    }

    public double getDouble(String columnName) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            return this.rs.getDouble(columnName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetDoubleValue", e);
        }
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            return this.rs.getBigDecimal(index);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBigDecimalValue", e);
        }
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            return this.rs.getBigDecimal(columnName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBigDecimalValue", e);
        }
    }

    public Date getDate(int index) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            return this.rs.getDate(index);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetDateValue", e);
        }
    }

    public Date getDate(String columnName) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            return this.rs.getDate(columnName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetDateValue", e);
        }
    }

    public Time getTime(int index) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            return this.rs.getTime(index);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetTimeValue", e);
        }
    }

    public Time getTime(String columnName) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            return this.rs.getTime(columnName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetTimeValue", e);
        }
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            return this.rs.getTimestamp(index);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetTimeStampValue", e);
        }
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            return this.rs.getTimestamp(columnName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetTimeStampValue", e);
        }
    }

    public IBlob getBlob(String columnName) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            java.sql.Blob blob = this.rs.getBlob(columnName);
            return new Blob(blob);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            try {
                InputStream inputStream = this.rs.getBinaryStream(columnName);
                return new Blob(SqlBlobUtil.newBlob(inputStream));
            }
            catch (SQLException e2) {
                throw new JDBCException("odajdbc.ResultSetCannotGetBlobValue", e2);
            }
        }
        catch (SQLException sQLException) {
            byte[] bytes;
            block8: {
                try {
                    bytes = this.rs.getBytes(columnName);
                    if (bytes != null) break block8;
                    return null;
                }
                catch (SQLException e2) {
                    throw new JDBCException("odajdbc.ResultSetCannotGetBlobValue", e2);
                }
            }
            return new Blob(SqlBlobUtil.newBlob(new ByteArrayInputStream(bytes)));
        }
    }

    public IBlob getBlob(int index) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            java.sql.Blob blob = this.rs.getBlob(index);
            return new Blob(blob);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            try {
                InputStream inputStream = this.rs.getBinaryStream(index);
                return new Blob(SqlBlobUtil.newBlob(inputStream));
            }
            catch (SQLException e2) {
                throw new JDBCException("odajdbc.ResultSetCannotGetBlobValue", e2);
            }
        }
        catch (SQLException sQLException) {
            byte[] bytes;
            block8: {
                try {
                    bytes = this.rs.getBytes(index);
                    if (bytes != null) break block8;
                    return null;
                }
                catch (SQLException e2) {
                    throw new JDBCException("odajdbc.ResultSetCannotGetBlobValue", e2);
                }
            }
            return new Blob(SqlBlobUtil.newBlob(new ByteArrayInputStream(bytes)));
        }
    }

    public IClob getClob(String columnName) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            java.sql.Clob clob = this.rs.getClob(columnName);
            return new Clob(clob);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBlobValue", e);
        }
    }

    public IClob getClob(int index) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            java.sql.Clob clob = this.rs.getClob(index);
            return new Clob(clob);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBlobValue", e);
        }
    }

    public boolean getBoolean(String columnName) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            return this.rs.getBoolean(columnName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBooleanValue", e);
        }
    }

    public boolean getBoolean(int index) throws OdaException {
        this.assertNotNull(this.rs);
        try {
            return this.rs.getBoolean(index);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBooleanValue", e);
        }
    }

    public boolean wasNull() throws OdaException {
        logger.logp(Level.FINE, ResultSet.class.getName(), "getMetaData", "ResultSet.wasNull( )");
        this.assertNotNull(this.rs);
        try {
            return this.rs.wasNull();
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetDetermineNull", e);
        }
    }

    public int findColumn(String columnName) throws OdaException {
        logger.logp(Level.FINE, ResultSet.class.getName(), "findColumn", "ResultSet.findColumn( \"" + columnName + "\" )");
        this.assertNotNull(this.rs);
        try {
            return this.rs.findColumn(columnName);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotFindColumn", e);
        }
    }
}

