/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.report.model.adapter.oda.IODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.IReportParameterAdapter;
import org.eclipse.birt.report.model.adapter.oda.ODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.impl.CompareUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.DataSetParameterAdapter;
import org.eclipse.birt.report.model.adapter.oda.impl.DesignObjectSerializer;
import org.eclipse.birt.report.model.adapter.oda.impl.ModelOdaAdapter;
import org.eclipse.birt.report.model.adapter.oda.util.ParameterValueUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SelectionChoiceHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.SelectionChoice;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DynamicValuesQuery;
import org.eclipse.datatools.connectivity.oda.design.ElementNullability;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.InputParameterAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputParameterUIHints;
import org.eclipse.datatools.connectivity.oda.design.InputPromptControlStyle;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ScalarValueChoices;
import org.eclipse.datatools.connectivity.oda.design.ScalarValueDefinition;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ReportParameterAdapter
implements IReportParameterAdapter {
    private static final String ALLOW_NULL_PROP_NAME = "allowNull";
    private static final String ALLOW_BLANK_PROP_NAME = "allowBlank";
    private final IODADesignFactory designFactory = ODADesignFactory.getFactory();

    boolean isUpdatedReportParameter(ScalarParameterHandle reportParam, ParameterDefinition odaParam, String newDataType) {
        if (reportParam == null || odaParam == null) {
            return true;
        }
        DataElementAttributes dataAttrs = odaParam.getAttributes();
        Boolean odaAllowNull = ReportParameterAdapter.getROMNullability(dataAttrs.getNullability());
        boolean allowNull = this.getReportParamAllowMumble(reportParam, ALLOW_NULL_PROP_NAME);
        if (odaAllowNull != null && allowNull != odaAllowNull) {
            return false;
        }
        if (!"any".equalsIgnoreCase(newDataType) && !CompareUtil.isEquals(newDataType, reportParam.getDataType())) {
            return false;
        }
        DataElementUIHints dataUiHints = dataAttrs.getUiHints();
        if (dataUiHints != null) {
            String newPromptText = dataUiHints.getDisplayName();
            String newHelpText = dataUiHints.getDescription();
            if (!CompareUtil.isEquals(newPromptText, reportParam.getPromptText())) {
                return false;
            }
            if (!CompareUtil.isEquals(newHelpText, reportParam.getHelpText())) {
                return false;
            }
        }
        InputParameterAttributes paramAttrs = odaParam.getInputAttributes();
        InputParameterAttributes tmpParamDefn = null;
        DataSetDesign tmpDataSet = null;
        if (paramAttrs != null) {
            tmpParamDefn = (InputParameterAttributes)EcoreUtil.copy((EObject)paramAttrs);
            DynamicValuesQuery tmpDynamicQuery = tmpParamDefn.getElementAttributes().getDynamicValueChoices();
            if (tmpDynamicQuery != null) {
                tmpDataSet = tmpDynamicQuery.getDataSetDesign();
                tmpDynamicQuery.setDataSetDesign(null);
            }
            if (tmpParamDefn.getUiHints() != null) {
                tmpParamDefn.setUiHints(null);
            }
        } else {
            tmpParamDefn = this.designFactory.createInputParameterAttributes();
        }
        InputParameterAttributes tmpParamDefn1 = this.designFactory.createInputParameterAttributes();
        this.updateInputElementAttrs(tmpParamDefn1, reportParam, null);
        if (tmpParamDefn1.getUiHints() != null) {
            tmpParamDefn1.setUiHints(null);
        }
        DynamicValuesQuery tmpDynamicQuery1 = tmpParamDefn1.getElementAttributes().getDynamicValueChoices();
        DataSetDesign tmpDataSet1 = null;
        if (tmpDynamicQuery1 != null) {
            tmpDataSet1 = tmpDynamicQuery1.getDataSetDesign();
            tmpDynamicQuery1.setDataSetDesign(null);
        }
        if (!EcoreUtil.equals((EObject)tmpDataSet, (EObject)tmpDataSet1)) {
            return false;
        }
        return EcoreUtil.equals((EObject)tmpParamDefn, (EObject)tmpParamDefn1);
    }

    static Boolean getROMNullability(ElementNullability nullability) {
        if (nullability == null) {
            return null;
        }
        switch (nullability.getValue()) {
            case 1: {
                return Boolean.TRUE;
            }
            case 2: {
                return Boolean.FALSE;
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    public void updateLinkedReportParameter(ScalarParameterHandle reportParam, OdaDataSetParameterHandle dataSetParam, DataSetDesign dataSetDesign) throws SemanticException {
        if (reportParam == null || dataSetParam == null) {
            return;
        }
        ParameterDefinition matchedParam = null;
        String dataType = null;
        OdaDataSetHandle setHandle = (OdaDataSetHandle)dataSetParam.getElementHandle();
        if (dataSetDesign != null) {
            matchedParam = ReportParameterAdapter.getValidParameterDefinition(dataSetParam, dataSetDesign.getParameters());
            dataType = DataSetParameterAdapter.getROMDataType(dataSetDesign.getOdaExtensionDataSourceId(), dataSetDesign.getOdaExtensionDataSetId(), (OdaDataSetParameter)dataSetParam.getStructure(), setHandle == null ? null : setHandle.parametersIterator());
        }
        CommandStack cmdStack = reportParam.getModuleHandle().getCommandStack();
        cmdStack.startTrans(null);
        try {
            if (matchedParam != null) {
                this.updateLinkedReportParameter(reportParam, matchedParam, null, dataType, (OdaDataSetHandle)dataSetParam.getElementHandle());
            }
            this.updateLinkedReportParameterFromROMParameter(reportParam, dataSetParam);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    private void updateLinkedReportParameterFromROMParameter(ScalarParameterHandle reportParam, OdaDataSetParameterHandle dataSetParam) throws SemanticException {
        String dataType;
        assert (reportParam != null);
        if (dataSetParam == null) {
            return;
        }
        String name = dataSetParam.getName();
        if (!StringUtil.isBlank((String)name)) {
            reportParam.setName(name);
        }
        if (!StringUtil.isBlank((String)(dataType = dataSetParam.getParameterDataType()))) {
            if (!"any".equalsIgnoreCase(dataType)) {
                reportParam.setDataType(dataType);
            } else {
                reportParam.setDataType("string");
            }
        }
        String defaultValue = dataSetParam.getDefaultValue();
        String paramName = dataSetParam.getParamName();
        if (!StringUtil.isBlank((String)defaultValue) && StringUtil.isBlank((String)paramName)) {
            this.setROMDefaultValue(reportParam, defaultValue);
        }
        if (StringUtil.isBlank((String)paramName)) {
            dataSetParam.setParamName(reportParam.getName());
        }
    }

    private void setROMDefaultValue(ScalarParameterHandle setParam, String value) throws SemanticException {
        boolean match;
        String literalValue = value;
        if (literalValue != null && (match = ExpressionUtil.isScalarParamReference((String)literalValue))) {
            return;
        }
        if ("JS_EXPR".equalsIgnoreCase(literalValue)) {
            return;
        }
        if (DataSetParameterAdapter.needsQuoteDelimiters(setParam.getDataType())) {
            if (ParameterValueUtil.isQuoted(value)) {
                literalValue = ParameterValueUtil.toLiteralValue(value);
            } else {
                return;
            }
        }
        setParam.setDefaultValue(literalValue);
    }

    void updateLinkedReportParameter(ScalarParameterHandle reportParam, ParameterDefinition paramDefn, ParameterDefinition cachedParamDefn, String dataType, OdaDataSetHandle setHandle) throws SemanticException {
        if (paramDefn == null) {
            return;
        }
        if (this.isUpdatedReportParameter(reportParam, paramDefn, dataType)) {
            return;
        }
        CommandStack cmdStack = reportParam.getModuleHandle().getCommandStack();
        try {
            cmdStack.startTrans(null);
            if (dataType == null) {
                if (!"any".equalsIgnoreCase(dataType)) {
                    reportParam.setDataType(dataType);
                } else {
                    reportParam.setDataType("string");
                }
            }
            this.updateDataElementAttrsToReportParam(paramDefn.getAttributes(), cachedParamDefn == null ? null : cachedParamDefn.getAttributes(), reportParam);
            this.updateInputParameterAttrsToReportParam(paramDefn.getInputAttributes(), cachedParamDefn == null ? null : cachedParamDefn.getInputAttributes(), reportParam, setHandle);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    public void updateLinkedReportParameter(ScalarParameterHandle reportParam, OdaDataSetParameterHandle dataSetParam) throws SemanticException {
        if (reportParam == null || dataSetParam == null) {
            return;
        }
        this.updateLinkedReportParameterFromROMParameter(reportParam, dataSetParam);
    }

    private static ParameterDefinition getValidParameterDefinition(OdaDataSetParameterHandle param, DataSetParameters odaParams) {
        if (param == null || odaParams == null) {
            return null;
        }
        if (odaParams.getParameterDefinitions().isEmpty()) {
            return null;
        }
        ParameterDefinition matchedParam = DataSetParameterAdapter.findParameterDefinition(odaParams, param.getNativeName(), param.getPosition());
        return matchedParam;
    }

    private void updateDataElementAttrsToReportParam(DataElementAttributes dataAttrs, DataElementAttributes cachedDataAttrs, ScalarParameterHandle reportParam) throws SemanticException {
        DataElementUIHints cachedDataUiHints;
        if (dataAttrs == null) {
            return;
        }
        boolean allowsNull = dataAttrs.allowsNull();
        if (cachedDataAttrs == null || cachedDataAttrs.allowsNull() != allowsNull) {
            this.setReportParamIsRequired(reportParam, ALLOW_NULL_PROP_NAME, dataAttrs.allowsNull());
        }
        DataElementUIHints dataUiHints = dataAttrs.getUiHints();
        DataElementUIHints dataElementUIHints = cachedDataUiHints = cachedDataAttrs == null ? null : cachedDataAttrs.getUiHints();
        if (dataUiHints != null) {
            String cachedDescription;
            String cachedDisplayName;
            String displayName = dataUiHints.getDisplayName();
            String string = cachedDisplayName = cachedDataUiHints == null ? null : cachedDataUiHints.getDisplayName();
            if (cachedDisplayName == null || !cachedDisplayName.equals(displayName)) {
                reportParam.setPromptText(displayName);
            }
            String description = dataUiHints.getDescription();
            String string2 = cachedDescription = cachedDataUiHints == null ? null : cachedDataUiHints.getDescription();
            if (cachedDescription == null || !cachedDescription.equals(description)) {
                reportParam.setHelpText(description);
            }
        }
    }

    private void updateInputParameterAttrsToReportParam(InputParameterAttributes inputParamAttrs, InputParameterAttributes cachedInputParamAttrs, ScalarParameterHandle reportParam, OdaDataSetHandle setHandle) throws SemanticException {
        if (inputParamAttrs == null) {
            return;
        }
        InputParameterUIHints paramUiHints = inputParamAttrs.getUiHints();
        if (paramUiHints != null && reportParam.getContainer() instanceof ParameterGroupHandle) {
            ParameterGroupHandle paramGroup = (ParameterGroupHandle)reportParam.getContainer();
            InputParameterUIHints cachedParamUiHints = cachedInputParamAttrs == null ? null : cachedInputParamAttrs.getUiHints();
            String cachedGroupPromptDisplayName = cachedParamUiHints == null ? null : cachedParamUiHints.getGroupPromptDisplayName();
            String groupPromptDisplayName = paramUiHints.getGroupPromptDisplayName();
            if (cachedGroupPromptDisplayName == null || !cachedGroupPromptDisplayName.equals(groupPromptDisplayName)) {
                paramGroup.setDisplayName(paramUiHints.getGroupPromptDisplayName());
            }
        }
        this.updateInputElementAttrsToReportParam(inputParamAttrs.getElementAttributes(), cachedInputParamAttrs == null ? null : cachedInputParamAttrs.getElementAttributes(), reportParam, setHandle);
    }

    private void updateInputElementAttrsToReportParam(InputElementAttributes elementAttrs, InputElementAttributes cachedElementAttrs, ScalarParameterHandle reportParam, OdaDataSetHandle setHandle) throws SemanticException {
        boolean cachedIsEnabled;
        DynamicValuesQuery cachedValueQuery;
        Boolean cachedMasksValues;
        Boolean cachedIsOptional;
        String cachedDefaultValue;
        if (elementAttrs == null) {
            return;
        }
        String defaultValue = elementAttrs.getDefaultScalarValue();
        String string = cachedDefaultValue = cachedElementAttrs == null ? null : cachedElementAttrs.getDefaultScalarValue();
        if (!CompareUtil.isEquals(cachedDefaultValue, defaultValue) && !"JS_EXPR".equals(defaultValue)) {
            reportParam.setDefaultValue(defaultValue);
        }
        Boolean isOptional = elementAttrs.isOptional();
        Boolean bl = cachedIsOptional = cachedElementAttrs == null ? null : Boolean.valueOf(cachedElementAttrs.isOptional());
        if (!CompareUtil.isEquals(cachedIsOptional, isOptional)) {
            this.setReportParamIsRequired(reportParam, ALLOW_BLANK_PROP_NAME, isOptional);
        }
        Boolean masksValue = elementAttrs.isMasksValue();
        Boolean bl2 = cachedMasksValues = cachedElementAttrs == null ? null : Boolean.valueOf(cachedElementAttrs.isMasksValue());
        if (!CompareUtil.isEquals(cachedMasksValues, masksValue)) {
            reportParam.setConcealValue(masksValue.booleanValue());
        }
        this.updateROMSelectionList(elementAttrs.getStaticValueChoices(), cachedElementAttrs == null ? null : cachedElementAttrs.getStaticValueChoices(), reportParam);
        DynamicValuesQuery valueQuery = elementAttrs.getDynamicValueChoices();
        this.updateROMDyanmicList(valueQuery, cachedElementAttrs == null ? null : cachedElementAttrs.getDynamicValueChoices(), reportParam, setHandle);
        DynamicValuesQuery dynamicValuesQuery = cachedValueQuery = cachedElementAttrs == null ? null : cachedElementAttrs.getDynamicValueChoices();
        if (valueQuery == null && cachedValueQuery == null) {
            return;
        }
        if (valueQuery == null) {
            valueQuery = this.designFactory.createDynamicValuesQuery();
        }
        boolean isEnabled = valueQuery.isEnabled();
        boolean bl3 = cachedIsEnabled = cachedValueQuery == null ? false : cachedValueQuery.isEnabled();
        if ((cachedValueQuery == null || cachedIsEnabled != isEnabled) && isEnabled) {
            reportParam.setValueType("dynamic");
        } else if (!(cachedValueQuery != null && cachedIsEnabled == isEnabled || isEnabled)) {
            reportParam.setValueType("static");
        }
        InputElementUIHints uiHints = elementAttrs.getUiHints();
        if (uiHints != null) {
            InputPromptControlStyle cachedStyle;
            InputElementUIHints cachedUiHints = cachedElementAttrs == null ? null : cachedElementAttrs.getUiHints();
            InputPromptControlStyle style = uiHints.getPromptStyle();
            InputPromptControlStyle inputPromptControlStyle = cachedStyle = cachedUiHints == null ? null : cachedUiHints.getPromptStyle();
            if (cachedStyle == null || style != null && cachedStyle.getValue() != style.getValue()) {
                reportParam.setControlType(style == null ? null : ReportParameterAdapter.newROMControlType(style.getValue()));
            }
        }
    }

    private static String newROMControlType(int promptStyle) {
        switch (promptStyle) {
            case 3: {
                return "check-box";
            }
            case 1: 
            case 2: {
                return "list-box";
            }
            case 4: {
                return "radio-button";
            }
            case 0: {
                return "text-box";
            }
        }
        return null;
    }

    private void updateROMSelectionList(ScalarValueChoices staticChoices, ScalarValueChoices cachedStaticChoices, ScalarParameterHandle paramHandle) throws SemanticException {
        if (staticChoices == null) {
            return;
        }
        String newChoiceStr = DesignObjectSerializer.toExternalForm((EObject)staticChoices);
        String latestChoiceStr = DesignObjectSerializer.toExternalForm((EObject)cachedStaticChoices);
        if (latestChoiceStr != null && latestChoiceStr.equals(newChoiceStr)) {
            return;
        }
        ArrayList<SelectionChoice> retList = new ArrayList<SelectionChoice>();
        EList choiceList = staticChoices.getScalarValues();
        int i = 0;
        while (i < choiceList.size()) {
            ScalarValueDefinition valueDefn = (ScalarValueDefinition)choiceList.get(i);
            SelectionChoice choice = StructureFactory.createSelectionChoice();
            choice.setValue(valueDefn.getValue());
            choice.setLabel(valueDefn.getDisplayName());
            retList.add(choice);
            ++i;
        }
        PropertyHandle propHandle = paramHandle.getPropertyHandle("selectionList");
        propHandle.clearValue();
        int i2 = 0;
        while (i2 < retList.size()) {
            propHandle.addItem(retList.get(i2));
            ++i2;
        }
    }

    private void updateROMDyanmicList(DynamicValuesQuery valueQuery, DynamicValuesQuery cachedValueQuery, ScalarParameterHandle reportParam, OdaDataSetHandle setHandle) throws SemanticException {
        String cachedValue;
        if (valueQuery == null) {
            return;
        }
        String value = valueQuery.getDataSetDesign().getName();
        String string = cachedValue = cachedValueQuery == null ? null : cachedValueQuery.getDataSetDesign().getName();
        if (cachedValue == null || !cachedValue.equals(value)) {
            reportParam.setDataSetName(value);
            ModuleHandle module = setHandle.getModuleHandle();
            DataSetHandle target = module.findDataSet(value);
            if (target instanceof OdaDataSetHandle && target != setHandle) {
                new ModelOdaAdapter().updateDataSetHandle(valueQuery.getDataSetDesign(), (OdaDataSetHandle)target, false);
            }
            if (target == null) {
                OdaDataSetHandle nestedDataSet = new ModelOdaAdapter().createDataSetHandle(valueQuery.getDataSetDesign(), module);
                module.getDataSets().add((DesignElementHandle)nestedDataSet);
            }
        }
        value = valueQuery.getValueColumn();
        String string2 = cachedValue = cachedValueQuery == null ? null : cachedValueQuery.getValueColumn();
        if (cachedValue == null || !cachedValue.equals(value)) {
            reportParam.setValueExpr(value);
        }
        value = valueQuery.getDisplayNameColumn();
        String string3 = cachedValue = cachedValueQuery == null ? null : cachedValueQuery.getDisplayNameColumn();
        if (cachedValue == null || !cachedValue.equals(value)) {
            reportParam.setLabelExpr(value);
        }
    }

    ParameterDefinition updateParameterDefinitionFromReportParam(ParameterDefinition paramDefn, ScalarParameterHandle paramHandle, DataSetDesign dataSetDesign) {
        assert (paramHandle != null);
        if (paramDefn == null) {
            return null;
        }
        paramDefn.setAttributes(this.updateDataElementAttrs(paramDefn.getAttributes(), paramHandle));
        paramDefn.setInputAttributes(this.updateInputElementAttrs(paramDefn.getInputAttributes(), paramHandle, dataSetDesign));
        return paramDefn;
    }

    private DataElementAttributes updateDataElementAttrs(DataElementAttributes dataAttrs, ScalarParameterHandle paramHandle) {
        DataElementAttributes retDataAttrs = dataAttrs;
        if (retDataAttrs == null) {
            retDataAttrs = this.designFactory.createDataElementAttributes();
        }
        retDataAttrs.setNullability(DataSetParameterAdapter.newElementNullability(this.getReportParamAllowMumble(paramHandle, ALLOW_NULL_PROP_NAME)));
        DataElementUIHints uiHints = this.designFactory.createDataElementUIHints();
        uiHints.setDisplayName(paramHandle.getPromptText());
        uiHints.setDescription(paramHandle.getHelpText());
        retDataAttrs.setUiHints(uiHints);
        return retDataAttrs;
    }

    private InputParameterAttributes updateInputElementAttrs(InputParameterAttributes inputParamAttrs, ScalarParameterHandle paramHandle, DataSetDesign dataSetDesign) {
        InputElementAttributes inputAttrs;
        InputParameterAttributes retInputParamAttrs = inputParamAttrs;
        if (inputParamAttrs == null) {
            retInputParamAttrs = this.designFactory.createInputParameterAttributes();
        }
        if ((inputAttrs = retInputParamAttrs.getElementAttributes()) == null) {
            inputAttrs = this.designFactory.createInputElementAttributes();
        }
        inputAttrs.setDefaultScalarValue(paramHandle.getDefaultValue());
        inputAttrs.setOptional(this.getReportParamAllowMumble(paramHandle, ALLOW_BLANK_PROP_NAME));
        inputAttrs.setMasksValue(paramHandle.isConcealValue());
        ScalarValueChoices staticChoices = null;
        Iterator selectionList = paramHandle.choiceIterator();
        while (selectionList.hasNext()) {
            if (staticChoices == null) {
                staticChoices = this.designFactory.createScalarValueChoices();
            }
            SelectionChoiceHandle choice = (SelectionChoiceHandle)selectionList.next();
            ScalarValueDefinition valueDefn = this.designFactory.createScalarValueDefinition();
            valueDefn.setValue(choice.getValue());
            valueDefn.setDisplayName(choice.getLabel());
            staticChoices.getScalarValues().add((Object)valueDefn);
        }
        inputAttrs.setStaticValueChoices(staticChoices);
        DataSetHandle setHandle = paramHandle.getDataSet();
        String valueExpr = paramHandle.getValueExpr();
        String labelExpr = paramHandle.getLabelExpr();
        if (setHandle instanceof OdaDataSetHandle && valueExpr != null) {
            DataSetDesign targetDataSetDesign;
            DynamicValuesQuery valueQuery = this.designFactory.createDynamicValuesQuery();
            if (dataSetDesign != null) {
                targetDataSetDesign = (DataSetDesign)EcoreUtil.copy((EObject)dataSetDesign);
                if (!setHandle.getName().equals(dataSetDesign.getName())) {
                    targetDataSetDesign = new ModelOdaAdapter().createDataSetDesign((OdaDataSetHandle)setHandle);
                }
                valueQuery.setDataSetDesign(targetDataSetDesign);
            } else {
                targetDataSetDesign = new ModelOdaAdapter().createDataSetDesign((OdaDataSetHandle)setHandle);
                valueQuery.setDataSetDesign(targetDataSetDesign);
            }
            valueQuery.setDisplayNameColumn(labelExpr);
            valueQuery.setValueColumn(valueExpr);
            boolean isEnabled = "dynamic".equalsIgnoreCase(paramHandle.getValueType());
            valueQuery.setEnabled(isEnabled);
            inputAttrs.setDynamicValueChoices(valueQuery);
        }
        InputElementUIHints uiHints = this.designFactory.createInputElementUIHints();
        uiHints.setPromptStyle(ReportParameterAdapter.newPromptStyle(paramHandle.getControlType(), paramHandle.isMustMatch()));
        inputAttrs.setUiHints(uiHints);
        if (paramHandle.getContainer() instanceof ParameterGroupHandle) {
            ParameterGroupHandle groupHandle = (ParameterGroupHandle)paramHandle.getContainer();
            InputParameterUIHints paramUiHints = this.designFactory.createInputParameterUIHints();
            paramUiHints.setGroupPromptDisplayName(groupHandle.getDisplayName());
            retInputParamAttrs.setUiHints(paramUiHints);
        }
        retInputParamAttrs.setElementAttributes(inputAttrs);
        return retInputParamAttrs;
    }

    private static InputPromptControlStyle newPromptStyle(String romType, boolean mustMatch) {
        if (romType == null) {
            return null;
        }
        int type = -1;
        if ("check-box".equalsIgnoreCase(romType)) {
            type = 3;
        } else if ("list-box".equalsIgnoreCase(romType)) {
            type = mustMatch ? 1 : 2;
        } else if ("radio-button".equalsIgnoreCase(romType)) {
            type = 4;
        } else if ("text-box".equalsIgnoreCase(romType)) {
            type = 0;
        }
        return InputPromptControlStyle.get((int)type);
    }

    private boolean getReportParamAllowMumble(ScalarParameterHandle param, String propName) {
        if (ALLOW_NULL_PROP_NAME.equalsIgnoreCase(propName)) {
            return param.allowNull();
        }
        if (ALLOW_BLANK_PROP_NAME.equalsIgnoreCase(propName)) {
            return param.allowBlank();
        }
        assert (false);
        return false;
    }

    private void setReportParamIsRequired(ScalarParameterHandle param, String obsoletePropName, boolean value) throws SemanticException {
        if (ALLOW_NULL_PROP_NAME.equalsIgnoreCase(obsoletePropName)) {
            param.setAllowNull(value);
        } else if (ALLOW_BLANK_PROP_NAME.equalsIgnoreCase(obsoletePropName)) {
            param.setAllowBlank(value);
        } else assert (false);
    }
}

