/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfTextArray;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.pdf.PDFPageDevice;
import org.eclipse.birt.report.engine.layout.TextStyle;
import org.eclipse.birt.report.engine.layout.emitter.AbstractPage;
import org.eclipse.birt.report.engine.layout.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.util.FlashFile;
import org.w3c.dom.css.CSSValue;

public class PDFPage
extends AbstractPage {
    private PdfWriter writer = null;
    private PdfContentByte contentByte = null;
    private static Logger logger = Logger.getLogger(PDFPage.class.getName());
    boolean isTotalPage = false;
    private PDFPageDevice pageDevice;

    public PDFPage(int pageWidth, int pageHeight, Document document, PdfWriter writer, PDFPageDevice pageDevice) {
        super(pageWidth, pageHeight);
        this.writer = writer;
        this.pageDevice = pageDevice;
        try {
            Rectangle pageSize = new Rectangle(this.pageWidth, this.pageHeight);
            document.setPageSize(pageSize);
            if (!document.isOpen()) {
                document.open();
            } else {
                document.newPage();
            }
            this.contentByte = writer.getDirectContent();
        }
        catch (DocumentException de) {
            logger.log(Level.SEVERE, de.getMessage(), de);
        }
    }

    protected void clip(float startX, float startY, float width, float height) {
        startY = this.transformY(startY, height);
        this.contentByte.rectangle(startX, startY, width, height);
        this.contentByte.clip();
        this.contentByte.newPath();
    }

    protected void restoreState() {
        this.contentByte.restoreState();
    }

    protected void saveState() {
        this.contentByte.saveState();
    }

    public void dispose() {
    }

    protected void drawBackgroundColor(Color color, float x, float y, float width, float height) {
        if (color == null) {
            return;
        }
        y = this.transformY(y, height);
        this.contentByte.saveState();
        this.contentByte.setColorFill(color);
        this.contentByte.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, x, y);
        this.contentByte.rectangle(0.0f, 0.0f, width, height);
        this.contentByte.fill();
        this.contentByte.restoreState();
    }

    /*
     * Unable to fully structure code
     */
    protected void drawBackgroundImage(float x, float y, float width, float height, String repeat, String imageUrl, float absPosX, float absPosY) throws IOException {
        block26: {
            y = this.transformY(y);
            this.contentByte.saveState();
            img = null;
            try {
                img = Image.getInstance((URL)new URL(imageUrl));
                if ("no-repeat".equalsIgnoreCase(repeat)) {
                    triple = this.computeTplHorizontalValPair(absPosX, x, width, img.scaledWidth());
                    tplOriginX = triple.getTplOrigin();
                    tplWidth = triple.getTplSize();
                    translationX = triple.getTranslation();
                    triple = this.computeTplVerticalValTriple(absPosY, y, height, img.scaledHeight());
                    tplOrininY = triple.getTplOrigin();
                    tplHeight = triple.getTplSize();
                    translationY = triple.getTranslation();
                    templateWhole = this.contentByte.createTemplate(tplWidth, tplHeight);
                    templateWhole.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), translationX, translationY);
                    this.contentByte.addTemplate(templateWhole, tplOriginX, tplOrininY);
                    break block26;
                }
                if ("repeat-x".equalsIgnoreCase(repeat)) {
                    remainX = width;
                    template = null;
                    if (width > img.scaledWidth()) {
                        if (height - absPosY > img.scaledHeight()) {
                            template = this.contentByte.createTemplate(img.scaledWidth(), img.scaledHeight());
                            template.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, 0.0f);
                        } else {
                            template = this.contentByte.createTemplate(img.scaledWidth(), height);
                            template.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, -img.scaledHeight() + height);
                        }
                    }
                    while (remainX > 0.0f) {
                        if (remainX < img.scaledWidth()) {
                            if (height - absPosY > img.scaledHeight()) {
                                templateX = this.contentByte.createTemplate(remainX, img.scaledHeight());
                                templateX.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, 0.0f);
                                this.contentByte.addTemplate(templateX, x + width - remainX, y - absPosY - img.scaledHeight());
                            } else {
                                templateX = this.contentByte.createTemplate(remainX, height);
                                templateX.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, -img.scaledHeight() + height - absPosY);
                                this.contentByte.addTemplate(templateX, x + width - remainX, y - absPosY - height);
                            }
                            remainX = 0.0f;
                            continue;
                        }
                        if (height - absPosY > img.scaledHeight()) {
                            this.contentByte.addTemplate(template, x + width - remainX, y - absPosY - img.scaledHeight());
                        } else {
                            this.contentByte.addTemplate(template, x + width - remainX, y - absPosY - height);
                        }
                        remainX -= img.scaledWidth();
                    }
                    break block26;
                }
                if ("repeat-y".equalsIgnoreCase(repeat)) {
                    remainY = height;
                    template = null;
                    if (height > img.scaledHeight()) {
                        template = this.contentByte.createTemplate(width - absPosX > img.scaledWidth() ? img.scaledWidth() : width - absPosX, img.scaledHeight());
                        template.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, 0.0f);
                    }
                    while (remainY > 0.0f) {
                        if (remainY < img.scaledHeight()) {
                            templateY = this.contentByte.createTemplate(width - absPosX > img.scaledWidth() ? img.scaledWidth() : width - absPosX, remainY);
                            templateY.addImage(img, width > img.scaledWidth() ? img.scaledWidth() : width - absPosX, 0.0f, 0.0f, img.scaledHeight(), 0.0f, -(img.scaledHeight() - remainY));
                            this.contentByte.addTemplate(templateY, x + absPosX, y - height);
                            remainY = 0.0f;
                            continue;
                        }
                        this.contentByte.addTemplate(template, x + absPosX, y - height + remainY - img.scaledHeight());
                        remainY -= img.scaledHeight();
                    }
                    break block26;
                }
                if (!"repeat".equalsIgnoreCase(repeat)) break block26;
                remainX = width;
                remainY = height;
                template = null;
                if (width > img.scaledWidth() && height > img.scaledHeight()) {
                    template = this.contentByte.createTemplate(img.scaledWidth(), img.scaledHeight());
                    template.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, 0.0f);
                }
                while (remainY > 0.0f) {
                    remainX = width;
                    if (!(remainY < img.scaledHeight())) ** GOTO lbl97
                    while (remainX > 0.0f) {
                        if (remainX < img.scaledWidth()) {
                            templateXY = this.contentByte.createTemplate(remainX, remainY);
                            templateXY.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, -img.scaledHeight() + remainY);
                            this.contentByte.addTemplate(templateXY, x + width - remainX, y - height);
                            remainX = 0.0f;
                            continue;
                        }
                        templateY = this.contentByte.createTemplate(img.scaledWidth(), remainY);
                        templateY.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, -img.scaledHeight() + remainY);
                        this.contentByte.addTemplate(templateY, x + width - remainX, y - height);
                        remainX -= img.scaledWidth();
                    }
                    remainY = 0.0f;
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        if (remainX < img.scaledWidth()) {
                            templateX = this.contentByte.createTemplate(remainX, img.scaledHeight());
                            templateX.addImage(img, img.scaledWidth(), 0.0f, 0.0f, img.scaledHeight(), 0.0f, 0.0f);
                            this.contentByte.addTemplate(templateX, x + width - remainX, y - height + remainY - img.scaledHeight());
                            remainX = 0.0f;
                            continue;
                        }
                        this.contentByte.addTemplate(template, x + width - remainX, y - height + remainY - img.scaledHeight());
                        remainX -= img.scaledWidth();
lbl97:
                        // 3 sources

                        ** while (remainX > 0.0f)
                    }
lbl98:
                    // 1 sources

                    remainY -= img.scaledHeight();
                }
            }
            catch (IOException ioe) {
                PDFPage.logger.log(Level.WARNING, ioe.getMessage(), ioe);
            }
            catch (BadElementException bee) {
                PDFPage.logger.log(Level.WARNING, bee.getMessage(), bee);
            }
            catch (DocumentException de) {
                PDFPage.logger.log(Level.WARNING, de.getMessage(), de);
            }
            catch (RuntimeException re) {
                PDFPage.logger.log(Level.WARNING, re.getMessage(), re);
            }
        }
        this.contentByte.restoreState();
    }

    protected void drawImage(String imageId, byte[] imageData, String extension, float imageX, float imageY, float height, float width, String helpText) throws Exception {
        if (FlashFile.isFlash(null, null, (String)extension)) {
            this.embedFlash(null, imageData, imageX, imageY, height, width, helpText);
        } else {
            Image image = Image.getInstance((byte[])imageData);
            this.drawImage(image, imageX, imageY, height, width, helpText);
        }
    }

    protected void drawImage(String uri, String extension, float imageX, float imageY, float height, float width, String helpText) throws Exception {
        if (FlashFile.isFlash(null, (String)uri, (String)extension)) {
            this.embedFlash(uri, null, imageX, imageY, height, width, helpText);
        } else {
            Image image = Image.getInstance((URL)new URL(uri));
            this.drawImage(image, imageX, imageY, height, width, helpText);
        }
    }

    protected void drawLine(float startX, float startY, float endX, float endY, float width, Color color, String lineStyle) {
        if (color == null || 0.0f == width || "none".equalsIgnoreCase(lineStyle)) {
            return;
        }
        this.contentByte.saveState();
        if ("solid".equalsIgnoreCase(lineStyle)) {
            this.drawRawLine(startX, startY, endX, endY, width, color, this.contentByte);
        } else if ("dashed".equalsIgnoreCase(lineStyle)) {
            this.contentByte.setLineDash(3.0f * width, 2.0f * width, 0.0f);
            this.drawRawLine(startX, startY, endX, endY, width, color, this.contentByte);
        } else if ("dotted".equalsIgnoreCase(lineStyle)) {
            this.contentByte.setLineDash(width, width, 0.0f);
            this.drawRawLine(startX, startY, endX, endY, width, color, this.contentByte);
        } else {
            if ("double".equalsIgnoreCase(lineStyle)) {
                return;
            }
            this.drawRawLine(startX, startY, endX, endY, width, color, this.contentByte);
        }
        this.contentByte.restoreState();
    }

    protected void drawText(String text, float textX, float textY, float baseline, float width, float height, TextStyle fontStyle) {
        this.drawText(text, textX, textY + baseline, width, height, fontStyle.getFontInfo(), this.convertToPoint(fontStyle.getLetterSpacing()), this.convertToPoint(fontStyle.getWordSpacing()), fontStyle.getColor(), fontStyle.isLinethrough(), fontStyle.isOverline(), fontStyle.isUnderline(), fontStyle.getAlign());
    }

    private void drawText(String text, float textX, float textY, float width, float height, FontInfo fontInfo, float characterSpacing, float wordSpacing, Color color, boolean linethrough, boolean overline, boolean underline, CSSValue align) {
        this.drawText(text, textX, textY, fontInfo, characterSpacing, wordSpacing, color, align);
    }

    public void drawTotalPage(String text, int textX, int textY, int width, int height, TextStyle textInfo) {
        if (this.pageDevice.getPDFTemplate() != null) {
            this.isTotalPage = true;
            this.drawText(text, textX, textY, width, height, textInfo);
        }
    }

    public void createBookmark(String bookmark, int x, int y, int width, int height) {
        this.createBookmark(bookmark, this.convertToPoint(x), this.convertToPoint(y), this.convertToPoint(width), this.convertToPoint(height));
    }

    private void createBookmark(String bookmark, float x, float y, float width, float height) {
        this.contentByte.localDestination(bookmark, new PdfDestination(0, -1.0f, this.transformY(y), 0.0f));
    }

    public void createHyperlink(String hyperlink, String bookmark, String targetWindow, int type, int x, int y, int width, int height) {
        this.createHyperlink(hyperlink, bookmark, targetWindow, type, this.convertToPoint(x), this.convertToPoint(y), this.convertToPoint(width), this.convertToPoint(height));
    }

    private void createHyperlink(String hyperlink, String bookmark, String targetWindow, int type, float x, float y, float width, float height) {
        y = this.transformY(y, height);
        this.writer.addAnnotation(new PdfAnnotation(this.writer, x, y, x + width, y + height, this.createPdfAction(hyperlink, bookmark, targetWindow, type)));
    }

    public void createTotalPageTemplate(int x, int y, int width, int height) {
        this.createTotalPageTemplate(this.convertToPoint(x), this.convertToPoint(y), this.convertToPoint(width), this.convertToPoint(height));
    }

    private void createTotalPageTemplate(float x, float y, float width, float height) {
        if (this.pageDevice.getPDFTemplate() == null) {
            this.pageDevice.setPDFTemplate(this.contentByte.createTemplate(width, height));
        }
        y = this.transformY(y, height);
        this.contentByte.saveState();
        this.contentByte.addTemplate(this.pageDevice.getPDFTemplate(), x, y);
        this.contentByte.restoreState();
    }

    private void drawRawLine(float startX, float startY, float endX, float endY, float width, Color color, PdfContentByte contentByte) {
        startY = this.transformY(startY);
        endY = this.transformY(endY);
        contentByte.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, startX, startY);
        contentByte.moveTo(0.0f, 0.0f);
        contentByte.lineTo(endX - startX, endY - startY);
        contentByte.setLineWidth(width);
        contentByte.setColorStroke(color);
        contentByte.stroke();
    }

    private void drawText(String text, float textX, float textY, FontInfo fontInfo, float characterSpacing, float wordSpacing, Color color, CSSValue align) {
        PdfContentByte currentContentByte = this.isTotalPage ? this.pageDevice.getPDFTemplate() : this.contentByte;
        float containerHeight = this.isTotalPage ? this.pageDevice.getPDFTemplate().getHeight() : this.pageHeight;
        this.isTotalPage = false;
        currentContentByte.saveState();
        currentContentByte.beginText();
        if (color != null && !Color.BLACK.equals(color)) {
            currentContentByte.setColorFill(color);
            currentContentByte.setColorStroke(color);
        }
        BaseFont font = fontInfo.getBaseFont();
        float fontSize = fontInfo.getFontSize();
        currentContentByte.setFontAndSize(font, fontSize);
        if (characterSpacing != 0.0f) {
            currentContentByte.setCharacterSpacing(characterSpacing);
        }
        if (wordSpacing != 0.0f) {
            currentContentByte.setWordSpacing(wordSpacing);
        }
        this.setTextMatrix(currentContentByte, fontInfo, textX, this.transformY(textY, 0.0f, containerHeight));
        if (font.getFontType() == 3 && IStyle.JUSTIFY_VALUE.equals(align) && wordSpacing > 0.0f) {
            int idx = text.indexOf(32);
            if (idx >= 0) {
                float spaceCorrection = -wordSpacing * 1000.0f / fontSize;
                PdfTextArray textArray = new PdfTextArray(text.substring(0, idx));
                int lastIdx = idx;
                while ((idx = text.indexOf(32, lastIdx + 1)) >= 0) {
                    textArray.add(spaceCorrection);
                    textArray.add(text.substring(lastIdx, idx));
                    lastIdx = idx;
                }
                textArray.add(spaceCorrection);
                textArray.add(text.substring(lastIdx));
                currentContentByte.showText(textArray);
            } else {
                currentContentByte.showText(text);
            }
        } else {
            currentContentByte.showText(text);
        }
        currentContentByte.endText();
        currentContentByte.restoreState();
    }

    private PdfAction createPdfAction(String hyperlink, String bookmark, String target, int type) {
        if ("_top".equalsIgnoreCase(target) || "_parent".equalsIgnoreCase(target) || "_blank".equalsIgnoreCase(target) || "_self".equalsIgnoreCase(target)) {
            return new PdfAction(hyperlink);
        }
        if (type == 2) {
            return PdfAction.gotoLocalPage((String)bookmark, (boolean)false);
        }
        return PdfAction.gotoRemotePage((String)hyperlink, (String)bookmark, (boolean)false, (boolean)false);
    }

    private void setTextMatrix(PdfContentByte cb, FontInfo fi, float x, float y) {
        cb.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, x, y);
        if (!fi.getSimulation()) {
            cb.setTextMatrix(0.0f, 0.0f);
            return;
        }
        switch (fi.getFontStyle()) {
            case 2: {
                this.simulateItalic(cb);
                break;
            }
            case 1: {
                this.simulateBold(cb);
                break;
            }
            case 3: {
                this.simulateBold(cb);
                this.simulateItalic(cb);
            }
        }
    }

    private void simulateBold(PdfContentByte cb) {
        cb.setTextRenderingMode(2);
        cb.setLineWidth(0.9f);
        cb.setTextMatrix(0.0f, 0.0f);
    }

    private void simulateItalic(PdfContentByte cb) {
        float beta = EmitterUtil.ITALIC_HORIZONTAL_COEFFICIENT;
        cb.setTextMatrix(1.0f, 0.0f, beta, 1.0f, 0.0f, 0.0f);
    }

    private TplValueTriple computeTplVerticalValTriple(float absPos, float containerBaseAbsPos, float containerSize, float ImageSize) {
        float tplOrigin = 0.0f;
        float tplSize = 0.0f;
        float translation = 0.0f;
        if (absPos <= 0.0f) {
            if (ImageSize + absPos > 0.0f && ImageSize + absPos <= containerSize) {
                tplOrigin = containerBaseAbsPos - ImageSize - absPos;
                tplSize = ImageSize + absPos;
            } else if (ImageSize + absPos > containerSize) {
                tplOrigin = containerBaseAbsPos - containerSize;
                tplSize = containerSize;
                translation = containerSize - ImageSize - absPos;
            }
        } else if (!(absPos >= containerSize)) {
            if (ImageSize + absPos <= containerSize) {
                tplOrigin = containerBaseAbsPos - ImageSize - absPos;
                tplSize = ImageSize;
                translation = 0.0f;
            } else {
                tplOrigin = containerBaseAbsPos - containerSize;
                tplSize = containerSize - absPos;
                translation = containerSize - absPos - ImageSize;
            }
        }
        return new TplValueTriple(tplOrigin, tplSize, translation);
    }

    private void showHelpText(float x, float y, float width, float height, String helpText) {
        Rectangle rectangle = new Rectangle(x, y, x + width, y + height);
        PdfAnnotation annotation = PdfAnnotation.createSquareCircle((PdfWriter)this.writer, (Rectangle)rectangle, (String)helpText, (boolean)true);
        PdfBorderDictionary borderStyle = new PdfBorderDictionary(0.0f, 0, null);
        annotation.setBorderStyle(borderStyle);
        annotation.setFlags(288);
        this.writer.addAnnotation(annotation);
    }

    private TplValueTriple computeTplHorizontalValPair(float absPos, float containerBaseAbsPos, float containerSize, float ImageSize) {
        float tplOrigin = 0.0f;
        float tplSize = 0.0f;
        float translation = 0.0f;
        if (absPos <= 0.0f) {
            if (ImageSize + absPos > 0.0f && ImageSize + absPos <= containerSize) {
                tplOrigin = containerBaseAbsPos;
                tplSize = ImageSize + absPos;
            } else if (ImageSize + absPos > containerSize) {
                tplOrigin = containerBaseAbsPos;
                tplSize = containerSize;
            }
            translation = absPos;
        } else if (!(absPos >= containerSize)) {
            if (ImageSize + absPos <= containerSize) {
                tplOrigin = containerBaseAbsPos + absPos;
                tplSize = ImageSize;
            } else {
                tplOrigin = containerBaseAbsPos + absPos;
                tplSize = containerSize - absPos;
            }
            translation = 0.0f;
        }
        return new TplValueTriple(tplOrigin, tplSize, translation);
    }

    private void drawImage(Image image, float imageX, float imageY, float height, float width, String helpText) throws DocumentException {
        imageY = this.transformY(imageY, height);
        this.contentByte.saveState();
        this.contentByte.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, imageX, imageY);
        this.contentByte.addImage(image, width, 0.0f, 0.0f, height, 0.0f, 0.0f);
        if (helpText != null) {
            this.showHelpText(imageX, imageY, width, height, helpText);
        }
        this.contentByte.restoreState();
    }

    private void embedFlash(String flashPath, byte[] flashData, float x, float y, float height, float width, String helpText) throws IOException {
        y = this.transformY(y, height);
        this.contentByte.saveState();
        PdfFileSpecification fs = PdfFileSpecification.fileEmbedded((PdfWriter)this.writer, (String)flashPath, (String)helpText, (byte[])flashData);
        PdfAnnotation annot = PdfAnnotation.createScreen((PdfWriter)this.writer, (Rectangle)new Rectangle(x, y, x + width, y + height), (String)helpText, (PdfFileSpecification)fs, (String)"application/x-shockwave-flash", (boolean)true);
        this.writer.addAnnotation(annot);
        if (helpText != null) {
            this.showHelpText(x, y, width, height, helpText);
        }
        this.contentByte.restoreState();
    }

    private final class TplValueTriple {
        private final float tplOrigin;
        private final float tplSize;
        private final float translation;

        public TplValueTriple(float val1, float val2, float val3) {
            this.tplOrigin = val1;
            this.tplSize = val2;
            this.translation = val3;
        }

        float getTplOrigin() {
            return this.tplOrigin;
        }

        float getTplSize() {
            return this.tplSize;
        }

        float getTranslation() {
            return this.translation;
        }
    }
}

