/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.dscache.DataSetResultCache;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.odi.ICandidateQuery;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;

public class CandidateQuery
extends BaseQuery
implements ICandidateQuery {
    private ICustomDataSet customDataSet;
    private IResultIterator resultObjsIterator;
    private int groupingLevel;
    private IResultClass resultMetadata;
    private DataEngineSession session;

    public CandidateQuery(DataEngineSession session) {
        this.session = session;
    }

    public void setCandidates(IResultIterator resultObjsIterator, int groupingLevel) throws DataException {
        assert (resultObjsIterator != null);
        this.resultObjsIterator = resultObjsIterator;
        this.groupingLevel = groupingLevel;
        this.resultMetadata = resultObjsIterator.getResultClass();
    }

    public void setCandidates(ICustomDataSet customDataSet) throws DataException {
        assert (customDataSet != null);
        this.customDataSet = customDataSet;
        this.resultMetadata = customDataSet.getResultClass();
    }

    public IResultClass getResultClass() {
        return this.resultMetadata;
    }

    public IResultIterator execute(IEventHandler eventHandler, StopSign stopSign) throws DataException {
        if (this.customDataSet == null) {
            return new CachedResultSet(this, this.resultMetadata, this.resultObjsIterator, this.groupingLevel, eventHandler, this.session, stopSign);
        }
        if (!this.session.getDataSetCacheManager().doesSaveToCache()) {
            return new CachedResultSet(this, this.customDataSet, eventHandler, this.session, stopSign);
        }
        return new CachedResultSet((BaseQuery)this, this.resultMetadata, new DataSetResultCache(this.customDataSet, this.resultMetadata, this.session), eventHandler, this.session, stopSign);
    }

    public void close() {
    }
}

