/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.impl.DataSetCacheUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class DiskDataSetCacheObject
implements IDataSetCacheObject {
    private String cacheDir;
    private static Integer count = new Integer(0);
    private int cacheCapability;

    public DiskDataSetCacheObject(String cacheDir, int cacheCapability) {
        assert (cacheCapability > 0);
        this.cacheDir = cacheDir.endsWith(File.separator) ? String.valueOf(cacheDir) + "DataSetCacheObject_" + this.hashCode() + "_" + this.getCount() : String.valueOf(cacheDir) + File.separator + "DataSetCacheObject_" + this.hashCode() + "_" + this.getCount();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return new Boolean(new File(DiskDataSetCacheObject.this.cacheDir).mkdirs());
            }
        });
        this.cacheCapability = cacheCapability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCount() {
        Integer n = count;
        synchronized (n) {
            count = (count + 1) % 100000;
            return count;
        }
    }

    public File getDataFile() {
        return new File(String.valueOf(this.cacheDir) + File.separator + "data.data");
    }

    public File getMetaFile() {
        return new File(String.valueOf(this.cacheDir) + File.separator + "meta.data");
    }

    public boolean isCachedDataReusable(final int requiredCapability) {
        assert (requiredCapability > 0);
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    if (DiskDataSetCacheObject.this.getDataFile().exists() && DiskDataSetCacheObject.this.getMetaFile().exists() && DiskDataSetCacheObject.this.cacheCapability >= requiredCapability) {
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean needUpdateCache(int requiredCapability) {
        return !this.isCachedDataReusable(requiredCapability);
    }

    public void release() {
        DataSetCacheUtil.deleteFile(this.cacheDir);
    }

    public IResultClass getResultClass() throws DataException {
        try {
            return (IResultClass)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    FileInputStream fis1 = null;
                    BufferedInputStream bis1 = null;
                    fis1 = new FileInputStream(DiskDataSetCacheObject.this.getMetaFile());
                    bis1 = new BufferedInputStream(fis1);
                    IOUtil.readInt((InputStream)bis1);
                    ResultClass rsClass = new ResultClass(bis1);
                    bis1.close();
                    fis1.close();
                    return rsClass;
                }
            });
        }
        catch (Exception e) {
            throw new DataException("data.engine.datasetcache.load.error", e);
        }
    }

    public String getCacheDir() {
        return this.cacheDir;
    }
}

