/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.FilterUtil;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;

public final class QueryExecutionStrategyUtil {
    public static Strategy getQueryExecutionStrategy(IQueryDefinition query, IBaseDataSetDesign dataSet) throws DataException {
        if (query.getGroups() != null && query.getGroups().size() > 0) {
            return Strategy.Complex;
        }
        if (query.getFilters() != null && query.getFilters().size() > 0) {
            return Strategy.Complex;
        }
        if (query.getSorts() != null && query.getSorts().size() > 0) {
            return Strategy.Complex;
        }
        if (query.getSubqueries() != null && query.getSubqueries().size() > 0) {
            return Strategy.Complex;
        }
        if (query.getBindings() != null) {
            for (IBinding binding : query.getBindings().values()) {
                if (binding.getAggrFunction() != null) {
                    return Strategy.Complex;
                }
                if (!ExpressionCompilerUtil.hasAggregationInExpr(binding.getExpression())) continue;
                return Strategy.Complex;
            }
        }
        if (dataSet != null) {
            if (dataSet.getFilters() != null && FilterUtil.hasMutipassFilters(dataSet.getFilters())) {
                return Strategy.Complex;
            }
            if (dataSet.needDistinctValue()) {
                return Strategy.Complex;
            }
            if (dataSet.getComputedColumns() != null) {
                List computedColumns = dataSet.getComputedColumns();
                int i = 0;
                while (i < computedColumns.size()) {
                    IComputedColumn computedColumn = (IComputedColumn)computedColumns.get(i);
                    if (computedColumn.getAggregateFunction() != null) {
                        return Strategy.Complex;
                    }
                    if (computedColumn.getExpression() instanceof IScriptExpression && ExpressionUtil.hasAggregation((String)((IScriptExpression)computedColumn.getExpression()).getText())) {
                        return Strategy.Complex;
                    }
                    ++i;
                }
            }
        }
        return Strategy.Simple;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strategy {
        Simple,
        Complex;

    }
}

