/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Calendar;
import java.util.Map;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.IntegerHolder;
import org.eclipse.birt.data.engine.executor.cache.Md5Util;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.IIncreCacheDataSetDesign;

public class CacheUtil {
    private static final int MAX_DIR_CREATION_ATTEMPT = 1000;
    private static final String PATH_SEP = File.separator;
    private static final String TEST_MEM_BUFFER_SIZE = "birt.data.engine.test.memcachesize";
    private static final String TIME_DATA = "time.data";
    private static final String PS_ = "PS_";
    private static IntegerHolder cacheCounter1 = new IntegerHolder(0);
    private static IntegerHolder cacheCounter2 = new IntegerHolder(0);

    private CacheUtil() {
    }

    public static long computeMemoryBufferSize(Map appContext) {
        if (appContext == null) {
            return 0xA00000L;
        }
        if (appContext.get(TEST_MEM_BUFFER_SIZE) != null) {
            return CacheUtil.populateMemBufferSize(appContext.get(TEST_MEM_BUFFER_SIZE));
        }
        return CacheUtil.populateMemBufferSize(appContext.get(DataEngine.MEMORY_BUFFER_SIZE)) * 1024L * 1024L;
    }

    private static long populateMemBufferSize(Object propValue) {
        String targetBufferSize = propValue == null ? "10" : propValue.toString();
        long memoryCacheSize = 10L;
        if (targetBufferSize != null) {
            memoryCacheSize = Long.parseLong(targetBufferSize);
        }
        return memoryCacheSize == 0L ? 1L : memoryCacheSize;
    }

    public static String createTempRootDir(final String tempDir) {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    String rootDirStr = null;
                    File tempDtEDir = null;
                    tempDtEDir = new File(tempDir, "BirtDataTemp" + System.currentTimeMillis() + cacheCounter1.intValue());
                    cacheCounter1.add(1);
                    int x = 0;
                    while (tempDtEDir.exists()) {
                        tempDtEDir = new File(tempDir, "BirtDataTemp" + System.currentTimeMillis() + cacheCounter1.intValue() + "_" + ++x);
                    }
                    tempDtEDir.mkdirs();
                    tempDtEDir.deleteOnExit();
                    rootDirStr = CacheUtil.getCanonicalPath(tempDtEDir);
                    return rootDirStr;
                }
            });
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String createSessionTempDir(final String tempRootDir) throws DataException {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    File sessionFile = null;
                    String sessionTempDir = String.valueOf(tempRootDir) + File.separator + "session_" + System.currentTimeMillis() + cacheCounter2.intValue();
                    cacheCounter2.add(1);
                    sessionFile = new File(sessionTempDir);
                    int i = 0;
                    String tempDir = sessionTempDir;
                    while (sessionFile.exists()) {
                        sessionTempDir = String.valueOf(tempDir) + "_" + ++i;
                        sessionFile = new File(sessionTempDir);
                        if (i <= 1000) continue;
                        throw new DataException("data.engine.failToCreateTempDir", CacheUtil.diagnosticMkdirs(sessionFile));
                    }
                    if (!sessionFile.mkdirs()) {
                        throw new DataException("data.engine.failToCreateTempDir", CacheUtil.diagnosticMkdirs(sessionFile));
                    }
                    sessionFile.deleteOnExit();
                    return CacheUtil.getCanonicalPath(sessionFile);
                }
            });
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String diagnosticMkdirs(final File directory) {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    File canonFile;
                    String parent;
                    File newDirectory;
                    do {
                        canonFile = null;
                        try {
                            canonFile = directory.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            return directory.getAbsolutePath();
                        }
                        parent = canonFile.getParent();
                        if (parent != null) continue;
                        return directory.getAbsolutePath();
                    } while (!(newDirectory = new File(parent)).exists() && !newDirectory.mkdirs());
                    try {
                        return canonFile.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        return newDirectory.getAbsolutePath();
                    }
                }
            });
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getCanonicalPath(final File file) {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        return file.getAbsolutePath();
                    }
                }
            });
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String createIncrementalTempDir(final DataEngineSession session, final IIncreCacheDataSetDesign dataSetDesign) {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    File cacheDir = new File(String.valueOf(session.getTempDir()) + PATH_SEP + CacheUtil.PS_ + PATH_SEP + Md5Util.getMD5(dataSetDesign.getConfigFileUrl().toString()) + PATH_SEP + dataSetDesign.getName());
                    if (!cacheDir.exists()) {
                        cacheDir.mkdirs();
                    }
                    return CacheUtil.getCanonicalPath(cacheDir);
                }
            });
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getLastTime(final String folder) throws DataException {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    File file = new File(String.valueOf(folder) + PATH_SEP + CacheUtil.TIME_DATA);
                    if (!file.exists()) {
                        return null;
                    }
                    FileInputStream fis = new FileInputStream(file);
                    ObjectInputStream ois = new ObjectInputStream(fis);
                    String lastTime = (String)ois.readObject();
                    fis.close();
                    ois.close();
                    return lastTime;
                }
            });
        }
        catch (Exception e) {
            throw new DataException("data.engine.datasetcache.save.error", e);
        }
    }

    public static void saveCurrentTime(final String folder) throws DataException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    FileOutputStream fos = new FileOutputStream(new File(String.valueOf(folder) + PATH_SEP + CacheUtil.TIME_DATA));
                    ObjectOutputStream oos = new ObjectOutputStream(fos);
                    Calendar calendar = Calendar.getInstance();
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(CacheUtil.populate2DigitString(calendar.get(1)));
                    buffer.append(CacheUtil.populate2DigitString(calendar.get(2) + 1));
                    buffer.append(CacheUtil.populate2DigitString(calendar.get(5)));
                    if (calendar.get(9) == 1) {
                        buffer.append(CacheUtil.populate2DigitString(calendar.get(10) + 12));
                    }
                    buffer.append(CacheUtil.populate2DigitString(calendar.get(12)));
                    buffer.append(CacheUtil.populate2DigitString(calendar.get(13)));
                    oos.writeObject(buffer.toString());
                    fos.close();
                    oos.close();
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new DataException(e.getLocalizedMessage());
        }
    }

    private static String populate2DigitString(int value) {
        if (value < 10) {
            return "0" + value;
        }
        return String.valueOf(value);
    }

    public static long getLastTimestamp(final String folder) throws DataException {
        try {
            return (Long)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    RandomAccessFile raf = new RandomAccessFile(String.valueOf(folder) + PATH_SEP + "timestamp.data", "r");
                    long timestamp = raf.readLong();
                    raf.close();
                    return timestamp;
                }
            });
        }
        catch (Exception e) {
            throw new DataException(e.getLocalizedMessage());
        }
    }

    public static void saveCurrentTimestamp(final String folder) throws DataException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    RandomAccessFile raf = new RandomAccessFile(String.valueOf(folder) + PATH_SEP + "timestamp.data", "rw");
                    Calendar calendar = Calendar.getInstance();
                    raf.writeLong(calendar.getTimeInMillis());
                    raf.close();
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new DataException(e.getLocalizedMessage());
        }
    }
}

