/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;

public class ResultObjectUtil {
    private int columnCount;
    private Class[] typeArray;
    private IResultClass rsMetaData;

    public static ResultObjectUtil newInstance(IResultClass rsMetaData) {
        ResultObjectUtil instance = new ResultObjectUtil();
        int length = rsMetaData.getFieldCount();
        instance.typeArray = new Class[length];
        int i = 0;
        while (i < length) {
            try {
                instance.typeArray[i] = rsMetaData.getFieldValueClass(i + 1);
            }
            catch (DataException dataException) {}
            ++i;
        }
        instance.columnCount = rsMetaData.getFieldCount();
        instance.rsMetaData = rsMetaData;
        return instance;
    }

    private ResultObjectUtil() {
    }

    public ResultObject newResultObject(Object[] rowData) {
        return new ResultObject(this.rsMetaData, rowData);
    }

    public IResultObject[] readData(final InputStream bis, final int length, final StopSign stopSign) throws IOException {
        try {
            return (IResultObject[])AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ResultObject[] rowDatas = new ResultObject[length];
                    int i = 0;
                    while (i < length) {
                        if (stopSign != null && stopSign.isStopped()) break;
                        int rowLen = IOUtil.readInt((InputStream)bis);
                        byte[] rowDataBytes = new byte[rowLen];
                        bis.read(rowDataBytes);
                        ByteArrayInputStream bais = new ByteArrayInputStream(rowDataBytes);
                        DataInputStream dis = new DataInputStream(bais);
                        Object[] obs = new Object[ResultObjectUtil.this.columnCount];
                        int j = 0;
                        while (j < ResultObjectUtil.this.columnCount) {
                            Class fieldType = ResultObjectUtil.this.typeArray[j];
                            if (dis.readByte() == 0) {
                                obs[j] = null;
                            } else if (fieldType.equals(Integer.class)) {
                                obs[j] = new Integer(dis.readInt());
                            } else if (fieldType.equals(Double.class)) {
                                obs[j] = new Double(dis.readDouble());
                            } else if (fieldType.equals(BigDecimal.class)) {
                                obs[j] = new BigDecimal(dis.readUTF());
                            } else if (fieldType.equals(Time.class)) {
                                obs[j] = new Time(dis.readLong());
                            } else if (fieldType.equals(Timestamp.class)) {
                                obs[j] = new Timestamp(dis.readLong());
                            } else if (fieldType.equals(Date.class)) {
                                obs[j] = new Date(dis.readLong());
                            } else if (fieldType.isAssignableFrom(java.util.Date.class)) {
                                obs[j] = new java.util.Date(dis.readLong());
                            } else if (fieldType.equals(Boolean.class)) {
                                obs[j] = new Boolean(dis.readBoolean());
                            } else if (fieldType.equals(String.class)) {
                                obs[j] = IOUtil.readString((DataInputStream)dis);
                            } else if (fieldType.equals(IClob.class)) {
                                obs[j] = IOUtil.readString((DataInputStream)dis);
                            } else if (fieldType.equals(IBlob.class)) {
                                int len = IOUtil.readInt((InputStream)dis);
                                if (len == 0) {
                                    obs[j] = null;
                                } else {
                                    byte[] bytes = new byte[len];
                                    dis.read(bytes);
                                    obs[j] = bytes;
                                }
                            } else if (fieldType.equals(DataType.getClass((int)0))) {
                                ObjectInputStream ois = new ObjectInputStream(dis);
                                try {
                                    obs[j] = ois.readObject();
                                }
                                catch (Exception exception) {}
                                ois.close();
                            }
                            ++j;
                        }
                        rowDatas[i] = ResultObjectUtil.this.newResultObject(obs);
                        rowDataBytes = null;
                        dis = null;
                        bais = null;
                        ++i;
                    }
                    return rowDatas;
                }
            });
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void writeData(OutputStream bos, IResultObject[] resultObjects, int length, StopSign stopSign) throws IOException {
        int i = 0;
        while (i < length) {
            this.writeData(bos, resultObjects[i]);
            if (stopSign != null && stopSign.isStopped()) {
                return;
            }
            ++i;
        }
    }

    public void writeData(final OutputStream bos, final IResultObject resultObject) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(baos);
                    int j = 0;
                    while (j < ResultObjectUtil.this.columnCount) {
                        Object fieldValue = null;
                        try {
                            fieldValue = resultObject.getFieldValue(j + 1);
                        }
                        catch (DataException dataException) {}
                        if (fieldValue == null) {
                            dos.writeByte(0);
                        } else {
                            dos.writeByte(1);
                            Class fieldType = ResultObjectUtil.this.typeArray[j];
                            if (fieldType.equals(Integer.class)) {
                                dos.writeInt((Integer)fieldValue);
                            } else if (fieldType.equals(Double.class)) {
                                dos.writeDouble((Double)fieldValue);
                            } else if (fieldType.equals(BigDecimal.class)) {
                                dos.writeUTF(((BigDecimal)fieldValue).toString());
                            } else if (java.util.Date.class.isAssignableFrom(fieldType)) {
                                dos.writeLong(((java.util.Date)fieldValue).getTime());
                            } else if (fieldType.equals(Boolean.class)) {
                                dos.writeBoolean((Boolean)fieldValue);
                            } else if (fieldType.equals(String.class)) {
                                IOUtil.writeString((DataOutputStream)dos, (String)fieldValue.toString());
                            } else if (fieldType.equals(IClob.class)) {
                                IOUtil.writeString((DataOutputStream)dos, (String)fieldValue.toString());
                            } else if (fieldType.equals(IBlob.class)) {
                                byte[] bytes = (byte[])fieldValue;
                                if (bytes == null || bytes.length == 0) {
                                    IOUtil.writeInt((OutputStream)dos, (int)0);
                                } else {
                                    IOUtil.writeInt((OutputStream)dos, (int)bytes.length);
                                    dos.write((byte[])fieldValue);
                                }
                            } else if (fieldType.equals(DataType.getClass((int)0))) {
                                if (!(fieldValue instanceof Serializable)) {
                                    fieldValue = fieldValue.toString();
                                }
                                ObjectOutputStream oo = new ObjectOutputStream(dos);
                                oo.writeObject(fieldValue);
                                oo.close();
                            }
                        }
                        ++j;
                    }
                    dos.flush();
                    byte[] rowsDataBytes = baos.toByteArray();
                    IOUtil.writeInt((OutputStream)bos, (int)rowsDataBytes.length);
                    bos.write(rowsDataBytes);
                    rowsDataBytes = null;
                    dos = null;
                    baos = null;
                    return null;
                }
            });
        }
        catch (Exception exception) {}
    }
}

