/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.DataOutputStream;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.CacheRequest;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.SmartCacheHelper;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartCache
implements ResultSetCache {
    private ResultSetCache resultSetCache;
    private boolean isOpen = true;

    public SmartCache(CacheRequest cacheRequest, ResultSet odaResultSet, IResultClass rsMeta, DataEngineSession session, StopSign stopSign) throws DataException {
        SmartCacheHelper smartCacheHelper = new SmartCacheHelper(session);
        this.resultSetCache = smartCacheHelper.getResultSetCache(cacheRequest, odaResultSet, rsMeta, stopSign);
    }

    public SmartCache(CacheRequest cacheRequest, OdiAdapter odiAdapter, IResultClass rsMeta, DataEngineSession session, StopSign stopSign) throws DataException {
        SmartCacheHelper smartCacheHelper = new SmartCacheHelper(session);
        this.resultSetCache = smartCacheHelper.getResultSetCache(cacheRequest, odiAdapter, rsMeta, stopSign);
    }

    public SmartCache(CacheRequest cacheRequest, ResultSetCache resultCache, int startIndex, int endIndex, IResultClass rsMeta, DataEngineSession session, StopSign stopSign) throws DataException {
        SmartCacheHelper smartCacheHelper = new SmartCacheHelper(session);
        this.resultSetCache = smartCacheHelper.getResultSetCache(cacheRequest, resultCache, startIndex, endIndex, rsMeta, stopSign);
    }

    public SmartCache(CacheRequest cacheRequest, IRowResultSet rowResultSet, IResultClass rsMeta, DataEngineSession session, StopSign stopSign) throws DataException {
        SmartCacheHelper smartCacheHelper = new SmartCacheHelper(session);
        this.resultSetCache = smartCacheHelper.getResultSetCache(cacheRequest, rowResultSet, rsMeta, stopSign);
    }

    @Override
    public int getCount() throws DataException {
        assert (this.isOpen);
        return this.resultSetCache.getCount();
    }

    @Override
    public int getCurrentIndex() throws DataException {
        assert (this.isOpen);
        return this.resultSetCache.getCurrentIndex();
    }

    @Override
    public IResultObject getCurrentResult() throws DataException {
        assert (this.isOpen);
        return this.resultSetCache.getCurrentResult();
    }

    @Override
    public boolean next() throws DataException {
        assert (this.isOpen);
        return this.resultSetCache.next();
    }

    @Override
    public IResultObject fetch() throws DataException {
        assert (this.isOpen);
        return this.resultSetCache.fetch();
    }

    @Override
    public void moveTo(int destIndex) throws DataException {
        assert (this.isOpen);
        this.resultSetCache.moveTo(destIndex);
    }

    @Override
    public void reset() throws DataException {
        assert (this.isOpen);
        this.resultSetCache.reset();
    }

    @Override
    public void close() {
        if (!this.isOpen) {
            return;
        }
        this.resultSetCache.close();
        this.resultSetCache = null;
        this.isOpen = false;
    }

    @Override
    public void doSave(DataOutputStream outputStream, DataOutputStream rowLensStream, List<IBinding> cacheRequestMap) throws DataException {
        this.resultSetCache.doSave(outputStream, rowLensStream, cacheRequestMap);
    }

    public void finalize() {
        this.close();
    }

    @Override
    public void setResultClass(IResultClass rsMeta) throws DataException {
        this.resultSetCache.setResultClass(rsMeta);
    }
}

