/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.odi.IResultObject;

class DataFileWriter {
    private File file;
    private boolean isOpen;
    private FileOutputStream fos;
    private BufferedOutputStream bos;
    private ResultObjectUtil resultObjectUtil;

    static DataFileWriter newInstance(File file, ResultObjectUtil resultObjectUtil) {
        return new DataFileWriter(file, resultObjectUtil);
    }

    private DataFileWriter(File file, ResultObjectUtil resultObjectUtil) {
        this.resultObjectUtil = resultObjectUtil;
        this.setWriteFile(file);
    }

    void setWriteFile(File file) {
        if (this.isOpen) {
            this.close();
        }
        this.file = file;
        this.isOpen = false;
    }

    void write(IResultObject[] resultObjects, int count, StopSign stopSign) throws IOException {
        if (!this.isOpen) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws FileNotFoundException {
                        DataFileWriter.this.fos = new FileOutputStream(DataFileWriter.this.file);
                        DataFileWriter.this.bos = new BufferedOutputStream(DataFileWriter.this.fos);
                        DataFileWriter.this.isOpen = true;
                        return null;
                    }
                });
            }
            catch (Exception exception) {}
        }
        this.resultObjectUtil.writeData(this.bos, resultObjects, count, stopSign);
    }

    void close() {
        if (this.isOpen) {
            try {
                this.bos.close();
                this.fos.close();
                this.isOpen = false;
            }
            catch (IOException iOException) {}
        }
    }
}

