/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.DiskDataExport;
import org.eclipse.birt.data.engine.executor.cache.disk.IRowIterator;
import org.eclipse.birt.data.engine.executor.cache.disk.RowFile;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.odi.IResultObject;

class DiskDirectExport
extends DiskDataExport {
    private RowFile rowFile;
    private int dataCountOfUnit;

    DiskDirectExport(Map infoMap, ResultObjectUtil resultObjectUtil) {
        this.dataCountOfUnit = Integer.parseInt((String)infoMap.get("dataCountOfUnit"));
        this.rowFile = new RowFile(new File((String)infoMap.get("goalFile")), resultObjectUtil, this.dataCountOfUnit);
    }

    public void exportStartDataToDisk(IResultObject[] resultObjects, StopSign stopSign) throws IOException {
        this.innerExportStartData(resultObjects, stopSign);
    }

    public int exportRestDataToDisk(IResultObject resultObject, IRowResultSet rs, StopSign stopSign) throws DataException, IOException {
        int result = this.innerExportRestData(resultObject, rs, this.dataCountOfUnit, stopSign);
        this.rowFile.endWrite();
        return result;
    }

    public IRowIterator getRowIterator() {
        return this.rowFile;
    }

    public void close() {
    }

    protected void outputResultObjects(IResultObject[] resultObjects, int indexOfUnit, StopSign stopSign) throws IOException {
        this.rowFile.writeRows(resultObjects, resultObjects.length, stopSign);
    }
}

