/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.DiskDataExport;
import org.eclipse.birt.data.engine.executor.cache.disk.IRowIterator;
import org.eclipse.birt.data.engine.executor.cache.disk.MergeSortImpl;
import org.eclipse.birt.data.engine.executor.cache.disk.MergeSortUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.MergeTempFileUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.RowFile;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.odi.IResultObject;

class DiskSortExport2
extends DiskDataExport {
    private int dataCountOfUnit;
    private int dataCountOfTotal;
    private MergeTempFileUtil tempFileUtil;
    private List currRowFiles;
    private MergeSortUtil mergeSortUtil;
    private IResultObject[] rowBuffer = null;
    private int inMemoryPos;
    private IRowIterator goalRowIterator = null;

    DiskSortExport2(Map infoMap, Comparator comparator, ResultObjectUtil resultObjectUtil) {
        this.dataCountOfUnit = Integer.parseInt((String)infoMap.get("dataCountOfUnit"));
        if (this.dataCountOfUnit < 2) {
            throw new IllegalArgumentException("the dataCountOfUnit of " + this.dataCountOfUnit + " is less than 2 " + ", and then merge sort on file can not be done");
        }
        this.rowBuffer = new IResultObject[this.dataCountOfUnit];
        this.tempFileUtil = new MergeTempFileUtil((String)infoMap.get("tempDir"), resultObjectUtil);
        this.mergeSortUtil = MergeSortUtil.getUtil(comparator);
        this.currRowFiles = new ArrayList();
        this.inMemoryPos = -1;
    }

    public void exportStartDataToDisk(IResultObject[] resultObjects, StopSign stopSign) throws IOException {
        this.dataCountOfTotal = resultObjects.length;
        System.arraycopy(resultObjects, 0, this.rowBuffer, 0, resultObjects.length);
        this.inMemoryPos = this.dataCountOfUnit - 1;
    }

    public int exportRestDataToDisk(IResultObject resultObject, IRowResultSet rs, StopSign stopSign) throws DataException, IOException {
        int dataCountOfRest = this.innerExportRestData(resultObject, rs, this.dataCountOfUnit, stopSign);
        this.dataCountOfTotal += dataCountOfRest;
        MergeSortImpl mergeSortImpl = new MergeSortImpl(this.dataCountOfUnit, this.mergeSortUtil, this.tempFileUtil, this.currRowFiles);
        this.goalRowIterator = mergeSortImpl.mergeSortOnUnits(stopSign);
        return dataCountOfRest;
    }

    protected int innerExportRestData(IResultObject resultObject, IRowResultSet rs, int dataCountOfUnit, StopSign stopSign) throws DataException, IOException {
        this.addNewRow(resultObject);
        int columnCount = rs.getMetaData().getFieldCount();
        int currDataCount = 1;
        IResultObject odaObject = null;
        while ((odaObject = rs.next(stopSign)) != null) {
            if (stopSign.isStopped()) {
                return 0;
            }
            Object[] ob = new Object[columnCount];
            int i = 0;
            while (i < columnCount) {
                ob[i] = odaObject.getFieldValue(i + 1);
                ++i;
            }
            ResultObject rowData = this.resultObjectUtil.newResultObject(ob);
            this.addNewRow(rowData);
            ++currDataCount;
        }
        this.processLastUnit(stopSign);
        return currDataCount;
    }

    private void addNewRow(IResultObject resultObject) throws IOException {
        if (this.inMemoryPos == this.dataCountOfUnit - 1) {
            this.prepareNewTempRowFile(0);
            this.mergeSortUtil.sortSelf(this.rowBuffer);
            this.inMemoryPos = -1;
        }
        ++this.inMemoryPos;
        DiskSortExport2.getCurrTempFile(this.currRowFiles).write(this.rowBuffer[this.inMemoryPos]);
        this.rowBuffer[this.inMemoryPos] = resultObject;
    }

    private void processLastUnit(StopSign stopSign) throws IOException {
        this.rowBuffer = DiskSortExport2.interchange(this.rowBuffer, this.inMemoryPos);
        this.mergeSortUtil.sortSelf(this.rowBuffer);
        int cacheSize = 0;
        if (this.currRowFiles.size() <= this.dataCountOfUnit) {
            cacheSize = this.dataCountOfUnit - this.currRowFiles.size();
        }
        this.prepareNewTempRowFile(cacheSize);
        this.inMemoryPos = -1;
        DiskSortExport2.getCurrTempFile(this.currRowFiles).writeRows(this.rowBuffer, this.rowBuffer.length, stopSign);
        DiskSortExport2.getCurrTempFile(this.currRowFiles).endWrite();
    }

    private static IResultObject[] interchange(IResultObject[] objectArray, int position) {
        IResultObject[] tempBuffer = new IResultObject[objectArray.length];
        System.arraycopy(objectArray, position + 1, tempBuffer, 0, objectArray.length - (position + 1));
        System.arraycopy(objectArray, 0, tempBuffer, objectArray.length - (position + 1), position + 1);
        return tempBuffer;
    }

    private void prepareNewTempRowFile(int cacheSize) {
        if (this.currRowFiles.size() > 0) {
            RowFile lastRowFile = (RowFile)this.currRowFiles.get(this.currRowFiles.size() - 1);
            lastRowFile.endWrite();
        }
        RowFile rowFile = this.tempFileUtil.newTempFile(cacheSize);
        this.currRowFiles.add(rowFile);
    }

    private static RowFile getCurrTempFile(List files) {
        return (RowFile)files.get(files.size() - 1);
    }

    protected void outputResultObjects(IResultObject[] resultObjects, int indexOfUnit, StopSign stopSign) throws IOException {
    }

    public IRowIterator getRowIterator() {
        return this.goalRowIterator;
    }

    public void close() {
        this.tempFileUtil.clearTempDir();
    }
}

