/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.RowFile;

class MergeTempFileUtil {
    private String tempDirStr;
    private ResultObjectUtil resultObjectUtil;
    private int curLevel = 0;
    private int curIndex = 0;
    private static final String tempFilePrefix = "data";

    MergeTempFileUtil(final String tempDir, final ResultObjectUtil roUtil) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    MergeTempFileUtil.this.tempDirStr = tempDir;
                    MergeTempFileUtil.this.resultObjectUtil = roUtil;
                    File tempDir2 = new File(MergeTempFileUtil.this.tempDirStr);
                    if (!tempDir2.exists()) {
                        tempDir2.mkdirs();
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {}
    }

    RowFile newTempFile(int cacheSize) {
        return new RowFile(new File(this.tempDirStr, "data_" + this.curLevel + "_" + this.curIndex++), this.resultObjectUtil, cacheSize);
    }

    void newMergeLevel() {
        ++this.curLevel;
        this.curIndex = 0;
    }

    void clearTempDir() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    File tempDir = new File(MergeTempFileUtil.this.tempDirStr);
                    if (tempDir.exists()) {
                        tempDir.delete();
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {}
    }
}

