/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.DataFileReader;
import org.eclipse.birt.data.engine.executor.cache.disk.DataFileWriter;
import org.eclipse.birt.data.engine.executor.cache.disk.IRowIterator;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.odi.IResultObject;

class RowFile
implements IRowIterator {
    private File tempFile = null;
    private ResultObjectUtil resultObjectUtil;
    private int readPos = 0;
    private int rowCount = 0;
    private IResultObject[] memoryRowCache = null;
    private DataFileReader dfr = null;
    private DataFileWriter dfw = null;

    RowFile(File file, ResultObjectUtil resultObjectUtil, int cacheSize) {
        assert (file != null);
        this.tempFile = file;
        this.resultObjectUtil = resultObjectUtil;
        this.setCacheSize(cacheSize);
    }

    private void setCacheSize(int cacheSize) {
        if (cacheSize >= 0) {
            this.memoryRowCache = new IResultObject[cacheSize];
        }
    }

    void write(IResultObject resultObject) throws IOException {
        IResultObject[] resultObjects = new IResultObject[]{resultObject};
        this.writeRows(resultObjects, 1, null);
    }

    void writeRows(IResultObject[] resultObjects, int count, StopSign stopSign) throws IOException {
        int cacheFreeSize = this.memoryRowCache.length - this.rowCount;
        if (cacheFreeSize >= count) {
            this.writeRowsToCache(resultObjects, 0, count);
        } else if (cacheFreeSize > 0) {
            this.writeRowsToCache(resultObjects, 0, cacheFreeSize);
            this.writeRowsToFile(resultObjects, cacheFreeSize, count - cacheFreeSize, stopSign);
        } else {
            this.writeRowsToFile(resultObjects, 0, count, stopSign);
        }
    }

    private void writeRowsToCache(IResultObject[] resultObjects, int from, int count) throws IOException {
        System.arraycopy(resultObjects, from, this.memoryRowCache, this.rowCount, count);
        this.rowCount += count;
    }

    private void writeRowsToFile(IResultObject[] resultObjects, int from, int count, StopSign stopSign) throws IOException {
        if (this.dfw == null) {
            this.createWriter();
        }
        this.dfw.write(this.getSubArray(resultObjects, from, count), count, stopSign);
        this.rowCount += count;
    }

    private IResultObject[] getSubArray(IResultObject[] resultObjects, int from, int count) {
        IResultObject[] subArray = new IResultObject[count];
        System.arraycopy(resultObjects, from, subArray, 0, count);
        return subArray;
    }

    private void createWriter() {
        this.dfw = DataFileWriter.newInstance(this.tempFile, this.resultObjectUtil);
    }

    void endWrite() {
        this.closeWriter();
    }

    private void closeWriter() {
        if (this.dfw != null) {
            this.dfw.close();
            this.dfw = null;
        }
    }

    public void reset() {
        this.readPos = 0;
        this.createReader();
    }

    public IResultObject fetch() throws IOException {
        IResultObject resultObject = this.readRowFromCache();
        if (resultObject == null) {
            resultObject = this.readRowFromFile();
        }
        return resultObject;
    }

    private IResultObject readRowFromCache() throws IOException {
        if (this.readPos >= this.memoryRowCache.length) {
            return null;
        }
        return this.memoryRowCache[this.readPos++];
    }

    private IResultObject readRowFromFile() throws IOException {
        if (this.readPos >= this.rowCount) {
            return null;
        }
        if (this.dfr == null) {
            this.createReader();
        }
        ++this.readPos;
        return this.dfr.read(1, null)[0];
    }

    private void createReader() {
        if (this.dfr != null) {
            this.dfr.close();
        }
        this.dfr = DataFileReader.newInstance(this.tempFile, this.resultObjectUtil);
    }

    public void close() {
        this.closeReader();
        if (this.tempFile != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    RowFile.this.tempFile.delete();
                    return null;
                }
            });
        }
        this.memoryRowCache = null;
    }

    private void closeReader() {
        if (this.dfr != null) {
            this.dfr.close();
            this.dfr = null;
        }
    }
}

