/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.DataFileReader;
import org.eclipse.birt.data.engine.executor.cache.disk.DataFileWriter;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.odi.IResultObject;

class SortDataProvider {
    private int dataCountOfUnit;
    private File tempDir;
    private File goalFile;
    private DataFileReader[] dfrArray;
    private DataFileWriter dfw;
    private IResultObject[][] cachedResultObjects;
    private int[] indexOfCachedRowData;
    private String tempDirStr;
    private static final String tempFilePrefix = "data";
    public static final int SORT_ITSELF = 0;
    public static final int SORT_MERGE = 1;
    private ResultObjectUtil resultObjectUtil;

    SortDataProvider(final int dataCountOfUnit, final String tempDirStr, final String goalFileStr, final ResultObjectUtil resultObjectUtil) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    SortDataProvider.this.dataCountOfUnit = dataCountOfUnit;
                    SortDataProvider.this.resultObjectUtil = resultObjectUtil;
                    SortDataProvider.this.tempDir = new File(tempDirStr);
                    if (!SortDataProvider.this.tempDir.exists()) {
                        SortDataProvider.this.tempDir.mkdirs();
                    }
                    SortDataProvider.this.tempDirStr = tempDirStr;
                    SortDataProvider.this.goalFile = new File(goalFileStr);
                    return null;
                }
            });
        }
        catch (Exception exception) {}
    }

    void initForMerge(int dataCountOfTotal) {
        int countOfUnit = dataCountOfTotal / this.dataCountOfUnit;
        if (dataCountOfTotal % this.dataCountOfUnit != 0) {
            ++countOfUnit;
        }
        this.dfrArray = new DataFileReader[countOfUnit];
        this.cachedResultObjects = new IResultObject[countOfUnit][];
        this.indexOfCachedRowData = new int[countOfUnit];
        int i = 0;
        while (i < countOfUnit) {
            this.indexOfCachedRowData[i] = -1;
            ++i;
        }
    }

    IResultObject[] readData(int begin, int end, StopSign stopSign) throws IOException {
        int cacheLength;
        if (begin == end) {
            return new IResultObject[0];
        }
        int readerIndex = begin / this.dataCountOfUnit;
        if (this.indexOfCachedRowData[readerIndex] == -1) {
            File file = this.getTempFile(readerIndex);
            if (this.dfrArray[readerIndex] == null) {
                this.dfrArray[readerIndex] = DataFileReader.newInstance(file, this.resultObjectUtil);
            } else {
                this.dfrArray[readerIndex].setReadFile(file);
            }
        }
        int length = end - begin;
        IResultObject[] sortedData = null;
        int offsetOfBegin = begin - this.indexOfCachedRowData[readerIndex];
        int n = cacheLength = this.cachedResultObjects[readerIndex] != null ? this.cachedResultObjects[readerIndex].length : 0;
        if (this.indexOfCachedRowData[readerIndex] == -1 || offsetOfBegin >= cacheLength) {
            this.cachedResultObjects[readerIndex] = this.dfrArray[readerIndex].read(length, stopSign);
            sortedData = this.cachedResultObjects[readerIndex];
            this.indexOfCachedRowData[readerIndex] = begin;
        } else {
            int offsetOfEnd = end - this.indexOfCachedRowData[readerIndex];
            if (offsetOfEnd > cacheLength) {
                IResultObject[] tempCachedData = new IResultObject[length];
                int fromBeginCachedLength = this.indexOfCachedRowData[readerIndex] + cacheLength - begin;
                int i = 0;
                while (i < fromBeginCachedLength) {
                    tempCachedData[i] = this.cachedResultObjects[readerIndex][offsetOfBegin + i];
                    ++i;
                }
                int nextReadLength = offsetOfEnd - cacheLength;
                IResultObject[] nextSortData = this.dfrArray[readerIndex].read(nextReadLength, stopSign);
                int i2 = 0;
                while (i2 < nextReadLength) {
                    tempCachedData[fromBeginCachedLength + i2] = nextSortData[i2];
                    ++i2;
                }
                this.cachedResultObjects[readerIndex] = tempCachedData;
                this.indexOfCachedRowData[readerIndex] = begin;
                offsetOfBegin = begin - this.indexOfCachedRowData[readerIndex];
            }
            sortedData = new IResultObject[length];
            int i = 0;
            while (i < length) {
                sortedData[i] = this.cachedResultObjects[readerIndex][offsetOfBegin + i];
                ++i;
            }
        }
        return sortedData;
    }

    void writeData(int hint, int currPos, IResultObject[] resultObjects, int count, StopSign stopSign) throws IOException {
        if (hint == 0) {
            int writerIndex = currPos / this.dataCountOfUnit;
            File outputFile = this.getTempFile(writerIndex);
            if (this.dfw == null) {
                this.dfw = DataFileWriter.newInstance(outputFile, this.resultObjectUtil);
            } else if (currPos % this.dataCountOfUnit == 0) {
                this.dfw.setWriteFile(outputFile);
            }
            this.dfw.write(resultObjects, count, stopSign);
            this.dfw.close();
        } else {
            if (currPos == 0) {
                this.dfw.setWriteFile(this.goalFile);
            }
            this.dfw.write(resultObjects, count, stopSign);
        }
    }

    void end() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    int i = 0;
                    while (i < SortDataProvider.this.dfrArray.length) {
                        SortDataProvider.this.dfrArray[i].close();
                        File tempFile = SortDataProvider.this.getTempFile(i);
                        tempFile.delete();
                        ++i;
                    }
                    SortDataProvider.this.tempDir.delete();
                    SortDataProvider.this.dfw.close();
                    SortDataProvider.this.tempDir = null;
                    SortDataProvider.this.goalFile = null;
                    SortDataProvider.this.dfrArray = null;
                    SortDataProvider.this.dfw = null;
                    SortDataProvider.this.indexOfCachedRowData = null;
                    SortDataProvider.this.cachedResultObjects = null;
                    return null;
                }
            });
        }
        catch (Exception exception) {}
    }

    private File getTempFile(int index) {
        return new File(this.tempDirStr, "data_" + index);
    }
}

