/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.aggregation.AggregationHelper;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.dscache.DataSetResultCache;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.impl.document.StreamWrapper;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IAggrValueHolder;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class CachedResultSet
implements IResultIterator {
    private ResultSetPopulator resultSetPopulator;
    private IEventHandler handler;
    private ResultSet resultSet;
    private static String className = CachedResultSet.class.getName();
    private static Logger logger = Logger.getLogger(className);
    private List aggrHolder = new ArrayList();

    public CachedResultSet() {
    }

    public CachedResultSet(BaseQuery query, IResultClass meta, ResultSet odaResultSet, IEventHandler eventHandler, DataEngineSession session, StopSign stopSign) throws DataException {
        this.handler = eventHandler;
        this.resultSetPopulator = new ResultSetPopulator(query, meta, this, session, eventHandler);
        this.resultSetPopulator.populateResultSet(new OdiResultSetWrapper(odaResultSet), stopSign);
    }

    public CachedResultSet(BaseQuery query, IResultClass meta, IDataSetPopulator odaResultSet, IEventHandler eventHandler, DataEngineSession session, StopSign stopSign) throws DataException {
        this.handler = eventHandler;
        this.resultSetPopulator = new ResultSetPopulator(query, meta, this, session, eventHandler);
        this.resultSetPopulator.populateResultSet(new OdiResultSetWrapper(odaResultSet), stopSign);
    }

    public CachedResultSet(BaseQuery query, IResultClass meta, DataSetResultCache odaCacheResultSet, IEventHandler eventHandler, DataEngineSession session, StopSign stopSign) throws DataException {
        this.handler = eventHandler;
        this.resultSetPopulator = new ResultSetPopulator(query, meta, this, session, eventHandler);
        this.resultSetPopulator.populateResultSet(new OdiResultSetWrapper(odaCacheResultSet), stopSign);
        odaCacheResultSet.close();
    }

    public CachedResultSet(BaseQuery query, ICustomDataSet customDataSet, IEventHandler eventHandler, DataEngineSession session, StopSign stopSign) throws DataException {
        this.handler = eventHandler;
        assert (customDataSet != null);
        this.resultSetPopulator = new ResultSetPopulator(query, customDataSet.getResultClass(), this, session, eventHandler);
        this.resultSetPopulator.populateResultSet(new OdiResultSetWrapper(customDataSet), stopSign);
    }

    public CachedResultSet(BaseQuery query, IResultClass meta, IResultIterator parentResultIterator, int groupLevel, IEventHandler eventHandler, DataEngineSession session, StopSign stopSign) throws DataException {
        this.handler = eventHandler;
        assert (parentResultIterator instanceof CachedResultSet);
        CachedResultSet parentResultSet = (CachedResultSet)parentResultIterator;
        int[] groupInfo = parentResultSet.getCurrentGroupInfo(groupLevel);
        this.resultSetPopulator = new ResultSetPopulator(query, this.createCustomDataSetMetaData(query, meta), this, session, eventHandler);
        this.resultSetPopulator.populateResultSet(new OdiResultSetWrapper(new Object[]{parentResultSet.resultSetPopulator.getCache(), groupInfo}), stopSign);
    }

    private IResultClass createCustomDataSetMetaData(BaseQuery query, IResultClass meta) throws DataException {
        ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
        if (query.getFetchEvents() != null) {
            int i = 0;
            while (i < meta.getFieldCount()) {
                ResultFieldMetadata rfMeta = new ResultFieldMetadata(i, meta.getFieldName(i + 1), meta.getFieldLabel(i + 1), meta.getFieldValueClass(i + 1), meta.getFieldNativeTypeName(i + 1), false);
                rfMeta.setAlias(meta.getFieldAlias(i + 1));
                projectedColumns.add(rfMeta);
                ++i;
            }
            int j = 0;
            while (j < query.getFetchEvents().size()) {
                if (query.getFetchEvents().get(j) instanceof ComputedColumnHelper) {
                    ComputedColumnHelper helper = (ComputedColumnHelper)query.getFetchEvents().get(j);
                    helper.setModel(1);
                    int i2 = 0;
                    while (i2 < helper.getComputedColumnList().size()) {
                        projectedColumns.add(new ResultFieldMetadata(i2 + 1 + meta.getFieldCount(), ((IComputedColumn)helper.getComputedColumnList().get(i2)).getName(), ((IComputedColumn)helper.getComputedColumnList().get(i2)).getName(), DataType.getClass((int)((IComputedColumn)helper.getComputedColumnList().get(i2)).getDataType()), null, true));
                        ++i2;
                    }
                }
                meta = new ResultClass(projectedColumns);
                ++j;
            }
        }
        return meta;
    }

    private int[] getCurrentGroupInfo(int groupLevel) throws DataException {
        return this.resultSetPopulator.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().getCurrentGroupInfo(groupLevel);
    }

    public void doSave(StreamWrapper streamsWrapper, boolean isSubQuery) throws DataException {
        if (streamsWrapper.getStreamForGroupInfo() != null) {
            this.resultSetPopulator.getGroupProcessorManager().getGroupCalculationUtil().doSave(streamsWrapper.getStreamForGroupInfo());
        }
        if (!isSubQuery && streamsWrapper.getStreamForResultClass() != null) {
            ((ResultClass)this.resultSetPopulator.getResultSetMetadata()).doSave(streamsWrapper.getStreamForResultClass(), this.resultSetPopulator.getEventHandler().getAllColumnBindings());
            try {
                streamsWrapper.getStreamForResultClass().close();
                if (streamsWrapper.getStreamForDataSet() != null) {
                    this.resultSetPopulator.getCache().doSave(streamsWrapper.getStreamForDataSet(), streamsWrapper.getStreamForDataSetRowLens(), this.resultSetPopulator.getEventHandler().getAllColumnBindings());
                }
                streamsWrapper.getStreamForDataSet().close();
                streamsWrapper.getStreamForDataSetRowLens().close();
            }
            catch (IOException e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
    }

    public void close() {
        if (this.resultSetPopulator == null || this.resultSetPopulator.getCache() == null) {
            return;
        }
        this.resultSetPopulator.getCache().close();
        this.resultSetPopulator = null;
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (DataException e) {
            logger.logp(Level.FINE, className, "closeOdaResultSet", "Exception at CachedResultSet.close()", (Throwable)((Object)e));
        }
    }

    public IResultObject getCurrentResult() throws DataException {
        assert (this.resultSetPopulator != null && this.resultSetPopulator.getCache() != null);
        return this.resultSetPopulator.getCache().getCurrentResult();
    }

    public boolean next() throws DataException {
        assert (this.resultSetPopulator != null && this.resultSetPopulator.getCache() != null);
        boolean hasNext = this.resultSetPopulator.getCache().next();
        this.resultSetPopulator.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().next(hasNext);
        return hasNext;
    }

    public int getEndingGroupLevel() throws DataException {
        return this.resultSetPopulator.getEndingGroupLevel();
    }

    public int getStartingGroupLevel() throws DataException {
        return this.resultSetPopulator.getStartingGroupLevel();
    }

    public void first(int groupLevel) throws DataException {
        this.resultSetPopulator.first(groupLevel);
    }

    public void last(int groupLevel) throws DataException {
        this.resultSetPopulator.last(groupLevel);
    }

    public IResultClass getResultClass() throws DataException {
        return this.resultSetPopulator.getResultSetMetadata();
    }

    public int getCurrentResultIndex() throws DataException {
        assert (this.resultSetPopulator != null && this.resultSetPopulator.getCache() != null);
        return this.resultSetPopulator.getCache().getCurrentIndex();
    }

    public int getCurrentGroupIndex(int groupLevel) throws DataException {
        return this.resultSetPopulator.getCurrentGroupIndex(groupLevel);
    }

    public int[] getGroupStartAndEndIndex(int groupLevel) throws DataException {
        return this.resultSetPopulator.getGroupStartAndEndIndex(groupLevel);
    }

    public int getRowCount() throws DataException {
        return this.resultSetPopulator.getCache().getCount();
    }

    public ResultSetCache getResultSetCache() {
        return this.resultSetPopulator.getCache();
    }

    public IExecutorHelper getExecutorHelper() {
        if (this.handler != null) {
            return this.handler.getExecutorHelper();
        }
        return null;
    }

    public void setOdaResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public Object getAggrValue(String aggrName) throws DataException {
        int i = 0;
        while (i < this.aggrHolder.size()) {
            AggregationHelper helper = (AggregationHelper)this.aggrHolder.get(i);
            if (helper.hasAggr(aggrName)) {
                return helper.getAggrValue(aggrName);
            }
            ++i;
        }
        throw new DataException("Target Aggregation Name does not exist");
    }

    public void addAggrValueHolder(IAggrValueHolder holder) {
        this.aggrHolder.add(holder);
    }

    public void clearAggrValueHolder() {
        this.aggrHolder.clear();
    }
}

