/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSourceQuery;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.RowResultSet;
import org.eclipse.birt.data.engine.executor.cache.SmartCacheRequest;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.impl.document.StreamWrapper;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class SimpleResultSet
implements IResultIterator {
    private ResultSet resultSet;
    private RowResultSet rowResultSet;
    private StopSign stopSign;
    private IResultObject currResultObj;
    private IEventHandler handler;
    private int rowCount;

    public SimpleResultSet(DataSourceQuery dataSourceQuery, ResultSet resultSet, IResultClass resultClass, IEventHandler handler, StopSign stopSign) throws DataException {
        this.rowResultSet = new RowResultSet(new SmartCacheRequest(dataSourceQuery.getMaxRows(), dataSourceQuery.getFetchEvents(), new OdiAdapter(resultSet), resultClass, false));
        this.currResultObj = this.rowResultSet.next(stopSign);
        this.rowCount = this.currResultObj != null ? -1 : 0;
        this.resultSet = resultSet;
        this.stopSign = stopSign;
        this.handler = handler;
    }

    public void close() throws DataException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (DataException e) {
            e.printStackTrace();
        }
    }

    public void doSave(StreamWrapper streamsWrapper, boolean isSubQuery) throws DataException {
    }

    public void first(int groupingLevel) throws DataException {
    }

    public Object getAggrValue(String aggrName) throws DataException {
        return null;
    }

    public int getCurrentGroupIndex(int groupLevel) throws DataException {
        return 0;
    }

    public IResultObject getCurrentResult() throws DataException {
        return this.currResultObj;
    }

    public int getCurrentResultIndex() throws DataException {
        return this.rowResultSet.getIndex();
    }

    public int getEndingGroupLevel() throws DataException {
        if (this.rowResultSet.hasNext()) {
            return 1;
        }
        return 0;
    }

    public IExecutorHelper getExecutorHelper() {
        return this.handler.getExecutorHelper();
    }

    public int[] getGroupStartAndEndIndex(int groupLevel) throws DataException {
        return null;
    }

    public IResultClass getResultClass() throws DataException {
        return this.rowResultSet.getMetaData();
    }

    public ResultSetCache getResultSetCache() {
        return null;
    }

    public int getRowCount() throws DataException {
        return this.rowCount;
    }

    public int getStartingGroupLevel() throws DataException {
        if (this.rowResultSet.getIndex() == 0) {
            return 0;
        }
        return 1;
    }

    public void last(int groupingLevel) throws DataException {
    }

    public boolean next() throws DataException {
        this.currResultObj = this.rowResultSet.next(this.stopSign);
        return this.currResultObj != null;
    }
}

