/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.OrderingInfo;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBoundaryInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupProcessorManager;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

class GroupInstanceSorter {
    private ResultSetPopulator populator;
    private GroupProcessorManager groupProcessor;

    GroupInstanceSorter(GroupProcessorManager gp) {
        this.populator = gp.getResultSetPopulator();
        this.groupProcessor = gp;
    }

    void doGroupSorting(ScriptContext cx, StopSign stopSign) throws DataException {
        ArrayList groupLevels = new ArrayList();
        ArrayList expressionList = new ArrayList();
        this.populateGroupSortExpressions(expressionList, groupLevels);
        if (expressionList.size() > 0) {
            this.groupProcessor.calculateExpressionList(expressionList, groupLevels, 4);
            List[] groupArray = this.groupProcessor.getGroupCalculationUtil().getGroupInformationUtil().getGroupBoundaryInfos();
            this.populateGroupBoundaryInfosSortings(cx, groupArray);
            this.groupProcessor.getGroupCalculationUtil().sortGroupBoundaryInfos(groupArray);
            OrderingInfo odInfo = this.groupProcessor.getGroupCalculationUtil().getGroupInformationUtil().getOrderingInfo(groupArray);
            this.populator.reSetSmartCacheUsingOrderingInfo(odInfo, stopSign);
        }
    }

    void populateGroupSortExpressions(List expressionList, List groupLevels) {
        int i = 0;
        while (i < this.populator.getQuery().getGrouping().length) {
            List groupSorts = this.populator.getQuery().getGrouping()[i].getSorts();
            String name = this.populator.getQuery().getGrouping()[i].getName();
            if (groupSorts != null) {
                int j = 0;
                while (j < groupSorts.size()) {
                    IScriptExpression expr = ((ISortDefinition)groupSorts.get(j)).getExpression();
                    expr.setGroupName(name);
                    expressionList.add(expr);
                    groupLevels.add(new Integer(i + 1));
                    ++j;
                }
            }
            ++i;
        }
    }

    void populateGroupBoundaryInfosSortings(ScriptContext cx, List[] groupArray) throws DataException {
        int i = 0;
        while (i < this.populator.getQuery().getGrouping().length) {
            List groupSorts = this.populator.getQuery().getGrouping()[i].getSorts();
            if (groupSorts != null && groupSorts.size() != 0) {
                this.populator.getResultIterator().first(0);
                int j = 0;
                while (j < groupArray[i].size()) {
                    this.populateGroupBoundaryInfoSortings(cx, groupArray, i, j);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void populateGroupBoundaryInfoSortings(ScriptContext cx, List[] groupArray, int groupPosition, int groupIndex) throws DataException {
        Object[] sortKeys = new Object[this.populator.getQuery().getGrouping()[groupPosition].getSorts().size()];
        boolean[] sortDirections = new boolean[sortKeys.length];
        int[] sortStrength = new int[sortKeys.length];
        this.populator.getResultIterator().last(groupPosition + 1);
        int l = 0;
        while (l < sortKeys.length) {
            sortKeys[l] = ScriptEvalUtil.evalExpr(((ISortDefinition)this.populator.getQuery().getGrouping()[groupPosition].getSorts().get(l)).getExpression(), cx, this.groupProcessor.getExpressionProcessor().getScope(), ScriptExpression.defaultID, 0);
            sortDirections[l] = ((ISortDefinition)this.populator.getQuery().getGrouping()[groupPosition].getSorts().get(l)).getSortDirection() == 0;
            sortStrength[l] = ((ISortDefinition)this.populator.getQuery().getGrouping()[groupPosition].getSorts().get(l)).getSortStrength();
            ++l;
        }
        ((GroupBoundaryInfo)groupArray[groupPosition].get(groupIndex)).setSortCondition(sortKeys, sortDirections, sortStrength);
        this.populator.getResultIterator().next();
    }
}

