/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.pass;

import java.util.ArrayList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.pass.ComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.pass.PassUtil;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IResultClass;

class ComputedColumnCalculator {
    private ResultSetPopulator populator;
    private ComputedColumnsState iccState;
    private ComputedColumnHelper computedColumnHelper;

    private ComputedColumnCalculator(ResultSetPopulator populator, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper) {
        this.populator = populator;
        this.iccState = iccState;
        this.computedColumnHelper = computedColumnHelper;
    }

    static void populateComputedColumns(ResultSetPopulator populator, OdiResultSetWrapper odaResultSet, ComputedColumnsState iccState, ComputedColumnHelper computedColumnHelper, StopSign stopSign) throws DataException {
        new ComputedColumnCalculator(populator, iccState, computedColumnHelper).doPopulate(odaResultSet.getWrappedOdiResultSet() instanceof ICustomDataSet, stopSign);
    }

    private void doPopulate(boolean isCustomDataSet, StopSign stopSign) throws DataException {
        while (this.needMoreExpressionProcessOnComputedColumns()) {
            this.makeAPassToComputedColumn(isCustomDataSet, stopSign);
        }
    }

    private boolean needMoreExpressionProcessOnComputedColumns() {
        if (this.iccState == null) {
            return false;
        }
        int i = 0;
        while (i < this.iccState.getCount()) {
            if (!this.iccState.isValueAvailable(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void makeAPassToComputedColumn(boolean isCustomDataSet, StopSign stopSign) throws DataException {
        if (isCustomDataSet) {
            this.populator.setResultSetMetadata(ComputedColumnCalculator.rebuildCustomedResultClass(this.populator.getResultSetMetadata(), false));
        }
        this.populateComputedColumns();
        if (isCustomDataSet) {
            this.populator.setResultSetMetadata(ComputedColumnCalculator.rebuildCustomedResultClass(this.populator.getResultSetMetadata(), true));
        }
        PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), true, stopSign);
    }

    private static IResultClass rebuildCustomedResultClass(IResultClass meta, boolean returnToOriginalValue) throws DataException {
        ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
        int i = 1;
        while (i <= meta.getFieldCount()) {
            projectedColumns.add(new ResultFieldMetadata(0, meta.getFieldName(i), meta.getFieldLabel(i), meta.getFieldValueClass(i), meta.getFieldNativeTypeName(i), returnToOriginalValue ? true : PassUtil.isTemporaryResultSetComputedColumn(meta.getFieldName(i))));
            ++i;
        }
        return new ResultClass(projectedColumns);
    }

    private void populateComputedColumns() throws DataException {
        this.calculateAggregation();
        int startValue = this.iccState.getLastAccessedComputedColumnIndex() + 1;
        this.computedColumnHelper.getComputedColumnList().clear();
        int i = startValue;
        while (i < this.iccState.getCount()) {
            if (!this.iccState.isValueAvailable(i)) break;
            this.computedColumnHelper.getComputedColumnList().add(this.iccState.getComputedColumn(i));
            this.iccState.setLastAccessedComputedColumnId(i);
            ++i;
        }
        this.computedColumnHelper.setRePrepare(true);
    }

    private void calculateAggregation() throws DataException {
        this.populator.getExpressionProcessor().setResultIterator(this.populator.getResultIterator());
        this.populator.getExpressionProcessor().evaluateMultiPassExprOnCmp(this.iccState, true);
    }
}

