/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.impl.ResultSetCacheUtil;
import org.mozilla.javascript.Scriptable;

public class CacheResultIterator
implements IResultIterator {
    private InputStream metaInputStream = null;
    private DataInputStream rowInputStream = null;
    private ResultClass resultClass = null;
    private int rowCount;
    private int rowIndex;
    private int startingGroupLevel = -1;
    private int endingGroupLevel = -1;
    private List columnList = null;
    private Map columnValueMap = null;
    private IQueryResults queryResults;
    private int currRowIndex;
    private static Logger logger = Logger.getLogger(CacheResultIterator.class.getName());
    private int lastRowIndex = -1;

    public CacheResultIterator(String tempDir, IQueryResults queryResults) throws DataException {
        Object[] params = new Object[]{tempDir, queryResults.getID()};
        logger.entering(CacheResultIterator.class.getName(), "CacheResultIterator", params);
        this.columnValueMap = new HashMap();
        this.currRowIndex = -1;
        this.lastRowIndex = this.currRowIndex - 1;
        this.queryResults = queryResults;
        try {
            this.createCacheInputStream(tempDir);
            this.resultClass = new ResultClass(this.metaInputStream);
            this.rowCount = IOUtil.readInt((InputStream)this.rowInputStream);
            if (this.rowCount == -1) {
                this.rowCount = Integer.MAX_VALUE;
            }
            int columnSize = IOUtil.readInt((InputStream)this.rowInputStream);
            this.columnList = new ArrayList();
            int i = 0;
            while (i < columnSize) {
                this.columnList.add(IOUtil.readObject((DataInputStream)this.rowInputStream, (ClassLoader)DataEngineSession.getCurrentClassLoader()));
                ++i;
            }
            logger.exiting(CacheResultIterator.class.getName(), "CacheResultIterator");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DataException("data.engine.OpenCacheTempError");
        }
        catch (IOException iOException) {
            throw new DataException("data.engine.ReadCacheTempError");
        }
    }

    private void createCacheInputStream(final String tempDir) throws FileNotFoundException {
        block2: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        CacheResultIterator.this.metaInputStream = new BufferedInputStream(new FileInputStream(ResultSetCacheUtil.getMetaFile(tempDir, CacheResultIterator.this.queryResults.getID())), 1024);
                        CacheResultIterator.this.rowInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(ResultSetCacheUtil.getDataFile(tempDir, CacheResultIterator.this.queryResults.getID())), 1024));
                        return null;
                    }
                });
            }
            catch (Exception e) {
                if (!(e instanceof FileNotFoundException)) break block2;
                throw (FileNotFoundException)e;
            }
        }
    }

    public void close() throws BirtException {
        this.closeCacheIntputStream();
    }

    private void closeCacheIntputStream() throws DataException {
        try {
            if (this.metaInputStream != null) {
                this.metaInputStream.close();
                this.metaInputStream = null;
            }
            if (this.rowInputStream != null) {
                this.rowInputStream.close();
                this.rowInputStream = null;
            }
        }
        catch (IOException iOException) {
            throw new DataException("data.engine.CloseCacheTempError");
        }
    }

    public boolean findGroup(Object[] groupKeyValues) throws BirtException {
        throw new UnsupportedOperationException();
    }

    public Boolean getBoolean(String name) throws BirtException {
        return DataTypeUtil.toBoolean((Object)this.getValue(name));
    }

    public Integer getInteger(String name) throws BirtException {
        return DataTypeUtil.toInteger((Object)this.getValue(name));
    }

    public Double getDouble(String name) throws BirtException {
        return DataTypeUtil.toDouble((Object)this.getValue(name));
    }

    public String getString(String name) throws BirtException {
        return DataTypeUtil.toString((Object)this.getValue(name));
    }

    public BigDecimal getBigDecimal(String name) throws BirtException {
        return DataTypeUtil.toBigDecimal((Object)this.getValue(name));
    }

    public Date getDate(String name) throws BirtException {
        return DataTypeUtil.toDate((Object)this.getValue(name));
    }

    public Blob getBlob(String name) throws BirtException {
        return DataTypeUtil.toBlob((Object)this.getValue(name));
    }

    public byte[] getBytes(String name) throws BirtException {
        return DataTypeUtil.toBytes((Object)this.getValue(name));
    }

    public int getEndingGroupLevel() throws BirtException {
        return this.endingGroupLevel;
    }

    public IQueryResults getQueryResults() {
        return this.queryResults;
    }

    public IResultMetaData getResultMetaData() throws BirtException {
        return new ResultMetaData(this.resultClass);
    }

    public int getRowId() throws BirtException {
        return this.rowIndex;
    }

    public int getRowIndex() throws BirtException {
        return this.rowIndex;
    }

    public Scriptable getScope() {
        return null;
    }

    public IResultIterator getSecondaryIterator(String subQueryName, Scriptable scope) throws BirtException {
        throw new DataException("data.engine.reportItem.SubQuery.Unsupported");
    }

    public int getStartingGroupLevel() throws BirtException {
        return this.startingGroupLevel;
    }

    public Object getValue(String name) throws BirtException {
        if (this.isBeforeFirst()) {
            this.next();
            this.lastRowIndex = this.currRowIndex;
        }
        return this.columnValueMap.get(name);
    }

    public boolean isEmpty() throws BirtException {
        return this.rowCount == 0;
    }

    public void moveTo(int rowIndex) throws BirtException {
        if (rowIndex < 0 || rowIndex >= this.rowCount) {
            throw new DataException("data.engine.invalidRowIndex", new Integer(rowIndex));
        }
        if (rowIndex < this.currRowIndex) {
            throw new DataException("data.engine.backwardSeekError");
        }
        if (rowIndex == this.currRowIndex) {
            return;
        }
        int gapRows = rowIndex - this.currRowIndex;
        int i = 0;
        while (i < gapRows) {
            this.next();
            ++i;
        }
    }

    public boolean next() throws BirtException {
        this.checkStarted();
        if (this.columnValueMap == null) {
            return false;
        }
        if (this.lastRowIndex < this.currRowIndex) {
            ++this.currRowIndex;
            this.readCurrentRow();
        } else {
            this.lastRowIndex = this.currRowIndex - 1;
        }
        return this.columnValueMap != null && this.columnValueMap.size() > 0;
    }

    private void readCurrentRow() throws DataException {
        try {
            this.rowIndex = IOUtil.readInt((InputStream)this.rowInputStream);
            if (this.rowIndex == -1) {
                this.columnValueMap = null;
                return;
            }
            this.startingGroupLevel = IOUtil.readInt((InputStream)this.rowInputStream);
            this.endingGroupLevel = IOUtil.readInt((InputStream)this.rowInputStream);
            this.columnValueMap.clear();
            int i = 0;
            while (i < this.columnList.size()) {
                this.columnValueMap.put(this.columnList.get(i), IOUtil.readObject((DataInputStream)this.rowInputStream, (ClassLoader)DataEngineSession.getCurrentClassLoader()));
                ++i;
            }
        }
        catch (IOException iOException) {
            throw new DataException("data.engine.ReadCacheTempError");
        }
    }

    public void skipToEnd(int groupLevel) throws BirtException {
        while (this.getEndingGroupLevel() != groupLevel) {
            if (this.next()) continue;
            return;
        }
    }

    private void checkStarted() throws DataException {
        if (this.rowInputStream == null) {
            DataException e = new DataException("data.engine.ResultClosed");
            throw e;
        }
    }

    public boolean isBeforeFirst() throws BirtException {
        return !this.isEmpty() && this.currRowIndex == -1;
    }

    public boolean isFirst() throws BirtException {
        return !this.isEmpty() && this.currRowIndex == 0;
    }
}

