/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.GroupComputedColumn;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

class ComputedColumnHelperInstance {
    private DataSetRuntime dataSet;
    private DataSetRuntime.Mode mode;
    private List ccList = new ArrayList();
    private IComputedColumn[] computedColumn;
    private int[] columnIndexArray;
    private boolean isPrepared;
    private ScriptContext cx;
    protected static Logger logger = Logger.getLogger(ComputedColumnHelper.class.getName());

    public ComputedColumnHelperInstance(DataSetRuntime dataSet, List computedColumns, DataSetRuntime.Mode mode, ScriptContext cx) {
        int i = 0;
        while (i < computedColumns.size()) {
            this.ccList.add(computedColumns.get(i));
            ++i;
        }
        this.isPrepared = false;
        this.dataSet = dataSet;
        this.mode = mode;
        this.cx = cx;
    }

    public List getComputedColumnList() {
        return this.ccList;
    }

    public boolean process(IResultObject resultObject, int rowIndex) throws DataException {
        logger.entering(ComputedColumnHelper.class.getName(), "process");
        assert (resultObject != null);
        IResultClass resultClass = resultObject.getResultClass();
        if (!this.isPrepared) {
            this.prepare(resultClass);
        }
        if (this.computedColumn.length == 0) {
            logger.exiting(ComputedColumnHelper.class.getName(), "process");
            return true;
        }
        this.dataSet.setRowObject(resultObject, true);
        this.dataSet.setCurrentRowIndex(rowIndex);
        DataSetRuntime.Mode temp = this.dataSet.getMode();
        this.dataSet.setMode(this.mode);
        try {
            int i = 0;
            while (i < this.computedColumn.length) {
                if (!this.isAggrComputedColumn(this.computedColumn[i])) {
                    if (this.computedColumn[i].getExpression() != null) {
                        Object value = null;
                        try {
                            if (this.computedColumn[i].getExpression().getHandle() != null) {
                                value = ((CompiledExpression)this.computedColumn[i].getExpression().getHandle()).evaluate(this.cx, this.dataSet.getScriptScope());
                            } else {
                                String exprText = ((IScriptExpression)this.computedColumn[i].getExpression()).getText();
                                if (exprText != null) {
                                    value = ScriptEvalUtil.evaluateJSAsExpr(this.cx, this.dataSet.getJSDataSetObject(), exprText, ScriptExpression.defaultID, 0);
                                }
                            }
                            if (this.computedColumn[i] instanceof GroupComputedColumn) {
                                try {
                                    value = ((GroupComputedColumn)this.computedColumn[i]).calculate(value);
                                }
                                catch (BirtException e) {
                                    throw DataException.wrap(e);
                                }
                            }
                            value = DataTypeUtil.convert((Object)value, (Class)resultClass.getFieldValueClass(this.columnIndexArray[i]));
                        }
                        catch (BirtException e) {
                            String fieldName = resultClass.getFieldName(this.columnIndexArray[i]);
                            if (fieldName != null && fieldName.startsWith("_{$TEMP_")) {
                                throw new DataException("data.engine.ScriptResult.WrongSystemComputedColumn", e);
                            }
                            if (resultClass.wasAnyType(this.columnIndexArray[i])) {
                                throw new DataException("data.engine.possibleMixedDataTypeInColumn", e);
                            }
                            throw new DataException("data.engine.CompCol.FailRetrieveValueComputedColumn", (Throwable)e, resultClass.getFieldName(this.columnIndexArray[i]));
                        }
                        resultObject.setCustomFieldValue(this.columnIndexArray[i], value);
                    } else {
                        throw new DataException("data.engine.BadCompColExpr", resultObject.getResultClass().getFieldName(this.columnIndexArray[i]));
                    }
                }
                ++i;
            }
        }
        finally {
            this.dataSet.setMode(temp);
        }
        logger.exiting(ComputedColumnHelper.class.getName(), "process");
        return true;
    }

    private boolean isAggrComputedColumn(IComputedColumn cc) {
        return cc.getAggregateFunction() != null;
    }

    public void setRePrepare(boolean rePrepare) {
        this.isPrepared = !rePrepare;
    }

    private void prepare(IResultClass resultClass) throws DataException {
        assert (resultClass != null);
        ArrayList<Integer> cmptList = new ArrayList<Integer>();
        int i = 0;
        while (i < this.ccList.size()) {
            IComputedColumn cmptdColumn = (IComputedColumn)this.ccList.get(i);
            int cmptdColumnIdx = resultClass.getFieldIndex(cmptdColumn.getName());
            if (cmptdColumnIdx >= 1 && resultClass.isCustomField(cmptdColumnIdx)) {
                cmptList.add(new Integer(i));
            }
            ++i;
        }
        int size = cmptList.size();
        this.columnIndexArray = new int[size];
        this.computedColumn = new IComputedColumn[size];
        int i2 = 0;
        while (i2 < size) {
            IComputedColumn cmptdColumn;
            int pos = (Integer)cmptList.get(i2);
            this.computedColumn[i2] = cmptdColumn = (IComputedColumn)this.ccList.get(pos);
            this.columnIndexArray[i2] = resultClass.getFieldIndex(cmptdColumn.getName());
            ++i2;
        }
        this.isPrepared = true;
    }
}

