/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.IScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.impl.CachedQueryResults;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSourceManager;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.impl.EngineExecutionHints;
import org.eclipse.birt.data.engine.impl.IEngineExecutionHints;
import org.eclipse.birt.data.engine.impl.LogUtil;
import org.eclipse.birt.data.engine.impl.PreparedQueryUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ISubCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.impl.query.MeasureDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.PreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.impl.query.PreparedSubCubeQuery;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.script.JSDataSources;
import org.mozilla.javascript.Scriptable;

public class DataEngineImpl
extends DataEngine {
    private HashMap dataSources = new HashMap();
    private HashMap dataSetDesigns = new HashMap();
    private Scriptable dataSourcesJSObject;
    private DataEngineContext context;
    private DataEngineSession session;
    private DataSourceManager dataSourceManager;
    private List shutdownListenerList = null;
    private IEngineExecutionHints queryExecutionHints;
    protected static Logger logger = Logger.getLogger(DataEngineImpl.class.getName());

    public DataEngineImpl(DataEngineContext context) {
        assert (context != null);
        logger.entering(DataEngineImpl.class.getName(), "DataEngineImpl", context);
        this.queryExecutionHints = new EngineExecutionHints();
        this.context = context;
        this.dataSourceManager = new DataSourceManager(logger);
        this.session = new DataEngineSession(this);
        logger.exiting(DataEngineImpl.class.getName(), "DataEngineImpl");
        logger.log(Level.FINE, "Data Engine starts up");
    }

    public DataEngineContext getContext() {
        return this.context;
    }

    public IQueryResults getQueryResults(String queryResultID) throws DataException {
        if (this.context.getMode() == 2 || this.context.getMode() == 4 && this.context.getDocWriter() == null) {
            return new QueryResults(this.session.getTempDir(), this.context, queryResultID);
        }
        if (this.context.getMode() == 1 || this.context.getMode() == 3) {
            return new CachedQueryResults(this.session, queryResultID, null);
        }
        return null;
    }

    public void defineDataSource(IBaseDataSourceDesign dataSource) throws DataException {
        Object existingDefn;
        logger.entering(DataEngineImpl.class.getName(), "defineDataSource", dataSource == null ? "<null>" : dataSource.getName());
        if (dataSource == null) {
            NullPointerException e = new NullPointerException("dataSource param cannot be null");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSource", "dataSource param cannot be null", e);
            throw e;
        }
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSource", "DataEngine has been shutdown", e);
            throw e;
        }
        String name = dataSource.getName();
        if (name == null || name.length() == 0) {
            IllegalArgumentException e = new IllegalArgumentException("Data source has no name");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSource", "Data source has no name", e);
            throw e;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, DataEngineImpl.class.getName(), "defineDataSource", "DataEngine.defineDataSource: " + LogUtil.toString(dataSource));
        }
        if ((existingDefn = this.dataSources.get(dataSource.getName())) != null) {
            this.dataSourceManager.addDataSource((DataSourceRuntime)existingDefn);
        }
        DataSourceRuntime newDefn = DataSourceRuntime.newInstance(dataSource, this);
        this.dataSources.put(newDefn.getName(), newDefn);
        logger.exiting(DataEngineImpl.class.getName(), "defineDataSource");
    }

    public void defineDataSet(IBaseDataSetDesign dataSet) throws DataException {
        logger.entering(DataEngineImpl.class.getName(), "defineDataSet", dataSet == null ? "<null>" : dataSet.getName());
        if (dataSet == null) {
            NullPointerException e = new NullPointerException("dataSource param cannot be null");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSet", "dataSource param cannot be null", e);
            throw e;
        }
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSet", "DataEngine has been shutdown", e);
            throw e;
        }
        String name = dataSet.getName();
        if (name == null || name.length() == 0) {
            IllegalArgumentException e = new IllegalArgumentException("Data source has no name");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSet", "Data source has no name", e);
            throw e;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, DataEngineImpl.class.getName(), "defineDataSet", "DataEngine.defineDataSet: " + LogUtil.toString(dataSet));
        }
        if (!(dataSet instanceof IJointDataSetDesign)) {
            Class dSourceClass;
            String dataSourceName = dataSet.getDataSourceName();
            DataSourceRuntime dsource = this.getDataSourceRuntime(dataSourceName);
            if (dsource == null) {
                DataException e = new DataException("data.engine.UndefinedDataSource", dataSourceName);
                logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSet", "Data source {" + dataSourceName + "} is not defined", (Throwable)((Object)e));
                throw e;
            }
            if (dataSet instanceof IOdaDataSetDesign) {
                dSourceClass = IOdaDataSourceDesign.class;
            } else if (dataSet instanceof IScriptDataSetDesign) {
                dSourceClass = IScriptDataSourceDesign.class;
            } else {
                DataException e = new DataException("data.engine.UnsupportedDataSetType");
                logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSet", "Unsupported data set type: " + dataSet.getName(), (Throwable)((Object)e));
                throw e;
            }
            if (!dSourceClass.isInstance(dsource.getDesign())) {
                DataException e = new DataException("data.engine.UnsupportedDataSourceType", dsource.getName());
                logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "defineDataSet", "Unsupported data source type: " + dsource.getName(), (Throwable)((Object)e));
                throw e;
            }
        }
        this.dataSetDesigns.put(name, dataSet);
        logger.exiting(DataEngineImpl.class.getName(), "defineDataSet");
    }

    public void clearCache(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        if (dataSource == null || dataSet == null) {
            return;
        }
        DataSetCacheManager dscManager = this.getSession().getDataSetCacheManager();
        if (dscManager == null) {
            return;
        }
        dscManager.clearCache(dataSource, dataSet);
    }

    public DataSourceRuntime getDataSourceRuntime(String name) {
        return (DataSourceRuntime)this.dataSources.get(name);
    }

    public IBaseDataSetDesign getDataSetDesign(String name) {
        return (IBaseDataSetDesign)this.dataSetDesigns.get(name);
    }

    public IPreparedQuery prepare(IQueryDefinition querySpec) throws DataException {
        return this.prepare(querySpec, null);
    }

    public IPreparedCubeQuery prepare(ISubCubeQueryDefinition querySpec, Map appContext) throws BirtException {
        return new PreparedSubCubeQuery(querySpec, appContext, this.session);
    }

    public IPreparedQuery prepare(IQueryDefinition querySpec, Map appContext) throws DataException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(DataEngineImpl.class.getName(), "prepare", LogUtil.toString(querySpec));
        }
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "prepare", "DataEngine has been shutdown", e);
            throw e;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Start to prepare query: " + LogUtil.toString(querySpec));
        }
        IPreparedQuery result = PreparedQueryUtil.newInstance(this, querySpec, appContext);
        logger.fine("Finished preparing query.");
        logger.exiting(DataEngineImpl.class.getName(), "prepare");
        return result;
    }

    public void closeDataSource(String dataSourceName) throws DataException {
        logger.entering("DataEngineImpl", "closeDataSource", dataSourceName);
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "closeDataSource", "DataEngine has been shutdown", e);
            throw e;
        }
        logger.logp(Level.FINE, DataEngineImpl.class.getName(), "closeDataSource", "Close DataSource :" + dataSourceName);
        DataSourceRuntime ds = this.getDataSourceRuntime(dataSourceName);
        if (ds != null) {
            DataEngineImpl.closeDataSource(ds);
        }
        logger.exiting(DataEngineImpl.class.getName(), "closeDataSource");
    }

    private static void closeDataSource(DataSourceRuntime ds) throws DataException {
        assert (ds != null);
        if (ds.isOpen()) {
            ds.beforeClose();
            ds.closeOdiDataSource();
            ds.afterClose();
        }
    }

    public DataEngineSession getSession() {
        return this.session;
    }

    public void addShutdownListener(IShutdownListener listener) {
        if (this.shutdownListenerList == null) {
            this.shutdownListenerList = new ArrayList();
        }
        int i = 0;
        while (i < this.shutdownListenerList.size()) {
            if (listener == this.shutdownListenerList.get(i)) {
                return;
            }
            ++i;
        }
        this.shutdownListenerList.add(listener);
    }

    public void removeListener(IShutdownListener listener) {
        if (this.shutdownListenerList == null) {
            return;
        }
        int i = 0;
        while (i < this.shutdownListenerList.size()) {
            if (listener == this.shutdownListenerList.get(i)) {
                this.shutdownListenerList.remove(i);
                return;
            }
            ++i;
        }
    }

    public void shutdown() {
        logger.entering("DataEngineImpl", "shutdown");
        if (this.dataSources == null) {
            logger.fine("The data engine has already been shutdown");
            return;
        }
        Collection col = this.dataSources.values();
        for (DataSourceRuntime ds : col) {
            try {
                DataEngineImpl.closeDataSource(ds);
            }
            catch (DataException e) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "The data source (" + ds + ") fails to shut down", (Throwable)((Object)e));
            }
        }
        this.dataSourceManager.close();
        if (this.shutdownListenerList != null) {
            int i = 0;
            while (i < this.shutdownListenerList.size()) {
                ((IShutdownListener)this.shutdownListenerList.get(i)).dataEngineShutdown();
                ++i;
            }
            this.shutdownListenerList.clear();
        }
        logger.logp(Level.FINE, DataEngineImpl.class.getName(), "shutdown", "Data engine shuts down");
        this.dataSetDesigns = null;
        this.dataSources = null;
        this.clearTempFile();
        logger.exiting(DataEngineImpl.class.getName(), "shutdown");
    }

    private void clearTempFile() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    File tmpDir = new File(DataEngineImpl.this.session.getTempDir());
                    if (!tmpDir.exists() || !tmpDir.isDirectory()) {
                        return null;
                    }
                    DataEngineImpl.deleteDirectory(tmpDir);
                    return null;
                }
            });
        }
        catch (Exception exception) {}
    }

    private static void deleteDirectory(final File dir) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    File[] subFiles = dir.listFiles();
                    if (subFiles != null) {
                        int i = 0;
                        while (i < subFiles.length) {
                            if (subFiles[i].isDirectory()) {
                                DataEngineImpl.deleteDirectory(subFiles[i]);
                            } else {
                                this.safeDelete(subFiles[i]);
                            }
                            ++i;
                        }
                    }
                    this.safeDelete(dir);
                    return null;
                }

                private void safeDelete(File file) {
                    if (!file.delete()) {
                        file.deleteOnExit();
                    }
                }
            });
        }
        catch (Exception exception) {}
    }

    public Scriptable getDataSourcesScriptObject() {
        if (this.dataSources == null) {
            IllegalStateException e = new IllegalStateException("DataEngine has been shutdown");
            logger.logp(Level.WARNING, DataEngineImpl.class.getName(), "closeDataSource", "DataEngine has been shutdown", e);
            throw e;
        }
        if (this.dataSourcesJSObject == null) {
            this.dataSourcesJSObject = new JSDataSources(this.dataSources);
        }
        return this.dataSourcesJSObject;
    }

    public IPreparedCubeQuery prepare(ICubeQueryDefinition query, Map appContext) throws BirtException {
        this.adaptCubeQueryDefinition(query);
        return new PreparedCubeQuery(query, this.session, this.context, appContext);
    }

    private void adaptCubeQueryDefinition(ICubeQueryDefinition query) throws DataException {
        List bindings = query.getBindings();
        List levelExprList = this.getAllAggrOns(query);
        int i = 0;
        while (i < bindings.size()) {
            IBinding binding = (IBinding)bindings.get(i);
            String measureName = OlapExpressionUtil.getMeasure(binding.getExpression());
            if (measureName != null && binding.getAggrFunction() == null) {
                String aggrFunc = this.getAggrFunction(query, measureName);
                binding.setAggrFunction(aggrFunc);
                if (binding.getAggregatOns().size() == 0) {
                    Iterator itr = levelExprList.iterator();
                    while (itr.hasNext()) {
                        binding.addAggregateOn(itr.next().toString());
                    }
                }
            }
            ++i;
        }
    }

    private List getAllAggrOns(ICubeQueryDefinition query) {
        List levels = CubeQueryDefinitionUtil.populateMeasureAggrOns(query);
        ArrayList<String> levelExprs = new ArrayList<String>();
        for (DimLevel level : levels) {
            levelExprs.add(ExpressionUtil.createJSDimensionExpression((String)level.getDimensionName(), (String)level.getLevelName()));
        }
        return levelExprs;
    }

    private String getAggrFunction(ICubeQueryDefinition query, String measureName) {
        for (MeasureDefinition measure : query.getMeasures()) {
            if (!measure.getName().equals(measureName)) continue;
            if (measure.getAggrFunction() == null) break;
            return measure.getAggrFunction();
        }
        return "SUM";
    }

    public IResultMetaData getCachedDataSetMetaData(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws BirtException {
        return this.session.getDataSetCacheManager().getCachedResultMetadata(dataSource, dataSet);
    }

    public IEngineExecutionHints getExecutionHints() {
        return this.queryExecutionHints;
    }

    public void registerQueries(IDataQueryDefinition[] queryDefns) throws DataException {
        ((EngineExecutionHints)this.queryExecutionHints).populateCachedDataSets(this, queryDefns);
    }
}

