/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.IScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.script.IBaseDataSourceEventHandler;
import org.eclipse.birt.data.engine.api.script.IDataSourceInstanceHandle;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.OdaDataSourceRuntime;
import org.eclipse.birt.data.engine.impl.ScriptDataSourceRuntime;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.script.DataSourceJSEventHandler;
import org.eclipse.birt.data.engine.script.JSDataSourceImpl;
import org.eclipse.birt.data.engine.script.ScriptDataSourceJSEventHandler;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public abstract class DataSourceRuntime
implements IDataSourceInstanceHandle {
    private IBaseDataSourceDesign design;
    private IBaseDataSourceEventHandler eventHandler;
    private Scriptable sharedScope;
    private Scriptable jsDataSourceObject;
    private IDataSource odiDataSource;
    private Context cx;
    protected static Logger logger = Logger.getLogger(DataSourceRuntime.class.getName());

    public static DataSourceRuntime newInstance(IBaseDataSourceDesign dataSource, DataEngineImpl dataEngine) throws DataException {
        if (dataSource instanceof IOdaDataSourceDesign) {
            return new OdaDataSourceRuntime((IOdaDataSourceDesign)dataSource, dataEngine.getSession().getSharedScope(), dataEngine.getSession().getEngineContext().getScriptContext());
        }
        if (dataSource instanceof IScriptDataSourceDesign) {
            return new ScriptDataSourceRuntime((IScriptDataSourceDesign)dataSource, dataEngine.getSession().getSharedScope(), dataEngine.getSession().getEngineContext().getScriptContext());
        }
        throw new DataException("data.engine.UnsupportedDataSourceType", dataSource.getName());
    }

    protected DataSourceRuntime(IBaseDataSourceDesign dataSourceDesign, Scriptable sharedScope, ScriptContext cx) {
        Object[] params = new Object[]{dataSourceDesign, sharedScope};
        logger.entering(DataSourceRuntime.class.getName(), "DataSourceRuntime", params);
        assert (dataSourceDesign != null);
        this.design = dataSourceDesign;
        this.sharedScope = sharedScope;
        this.eventHandler = dataSourceDesign.getEventHandler();
        if (this.eventHandler == null) {
            this.eventHandler = dataSourceDesign instanceof IScriptDataSourceDesign ? new ScriptDataSourceJSEventHandler(cx, (IScriptDataSourceDesign)dataSourceDesign) : new DataSourceJSEventHandler(cx, dataSourceDesign);
        }
        logger.exiting(DataSourceRuntime.class.getName(), "DataSourceRuntime");
    }

    public IBaseDataSourceDesign getDesign() {
        return this.design;
    }

    public String getName() {
        return this.design.getName();
    }

    protected IBaseDataSourceEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public Scriptable getScriptScope() {
        return this.getJSDataSourceObject();
    }

    private Scriptable getJSDataSourceObject() {
        if (this.jsDataSourceObject == null) {
            Scriptable topScope = this.sharedScope;
            this.jsDataSourceObject = (Scriptable)Context.javaToJS((Object)new JSDataSourceImpl(this), (Scriptable)topScope);
            this.jsDataSourceObject.setParentScope(topScope);
            this.jsDataSourceObject.setPrototype(topScope);
        }
        return this.jsDataSourceObject;
    }

    public boolean isOpen() {
        return this.odiDataSource != null;
    }

    public IDataSource getOdiDataSource() {
        return this.odiDataSource;
    }

    public void openOdiDataSource(IDataSource odiDataSource) throws DataException {
        odiDataSource.open();
        this.odiDataSource = odiDataSource;
    }

    public boolean canClose() {
        if (this.odiDataSource != null) {
            return this.odiDataSource.canClose();
        }
        return true;
    }

    public void closeOdiDataSource() throws DataException {
        if (this.odiDataSource != null) {
            this.odiDataSource.close();
            this.odiDataSource = null;
        }
    }

    public void beforeOpen() throws DataException {
        if (this.eventHandler != null) {
            try {
                this.eventHandler.handleBeforeOpen(this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }

    public void afterOpen() throws DataException {
        if (this.eventHandler != null) {
            try {
                this.eventHandler.handleAfterOpen(this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }

    public void beforeClose() throws DataException {
        if (this.eventHandler != null) {
            try {
                this.eventHandler.handleBeforeClose(this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }

    public void afterClose() throws DataException {
        if (this.eventHandler != null) {
            try {
                this.eventHandler.handleAfterClose(this);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
    }
}

