/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.expression.NamedExpression;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.GroupBindingColumn;
import org.mozilla.javascript.Context;

public class ExprManagerUtil {
    private ExprManager exprManager;
    private static Logger logger = Logger.getLogger(ExprManagerUtil.class.getName());
    private Context cx;

    private ExprManagerUtil(ExprManager em, Context cx) {
        logger.entering(ExprManagerUtil.class.getName(), "ExprManagerUtil", em);
        this.exprManager = em;
        this.cx = cx;
        logger.exiting(ExprManagerUtil.class.getName(), "ExprManagerUtil");
    }

    public static void validateColumnBinding(ExprManager exprManager, IBaseQueryDefinition baseQueryDefn, Context cx) throws DataException {
        ExprManagerUtil util = new ExprManagerUtil(exprManager, cx);
        util.checkColumnBindingExpression(baseQueryDefn);
        util.checkDependencyCycle();
        util.checkGroupNameValidation();
    }

    private void checkGroupNameValidation() throws DataException {
        HashMap map = this.getGroupKeys();
        for (Integer level : map.keySet()) {
            this.exprManager.setEntryGroupLevel(level);
            if (ExpressionCompilerUtil.hasColumnRow(map.get(level).toString(), this.exprManager, this.cx)) continue;
            this.exprManager.setEntryGroupLevel(0);
            if (!this.isColumnBindingExist(map.get(level).toString())) {
                throw new DataException("data.engine.ColumnBindingNotExist", map.get(level).toString());
            }
            throw new DataException("data.engine.InvalidGroupKeyName", new Object[]{map.get(level).toString(), level});
        }
        this.exprManager.setEntryGroupLevel(0);
    }

    private boolean isColumnBindingExist(String columnName) throws DataException {
        List bindings = this.exprManager.getBindingExprs();
        int i = 0;
        while (i < bindings.size()) {
            GroupBindingColumn gbc = (GroupBindingColumn)bindings.get(i);
            if (gbc.getExpression(columnName) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void checkDependencyCycle() throws DataException {
        Iterator it = this.getColumnNames().iterator();
        HashSet<NamedExpression> namedExpressions = new HashSet<NamedExpression>();
        while (it.hasNext()) {
            String name = it.next().toString();
            IBaseExpression expr = this.exprManager.getExpr(name);
            namedExpressions.add(new NamedExpression(name, expr));
        }
        String nameInvolvedInCycle = ExpressionCompilerUtil.getFirstFoundNameInCycle(namedExpressions, "row");
        if (nameInvolvedInCycle != null) {
            throw new DataException("data.engine.ColumnBindingCycle", nameInvolvedInCycle);
        }
    }

    private void checkColumnBindingExpression(IBaseQueryDefinition baseQueryDefn) throws DataException {
        List list = this.getColumnNames();
        int i = 0;
        while (i < list.size()) {
            block10: {
                String name = list.get(i).toString();
                IBaseExpression expr = this.exprManager.getExpr(name);
                if (expr != null) {
                    if (!(expr instanceof IScriptExpression) && !(expr instanceof IConditionalExpression)) {
                        throw new DataException("data.engine.BadDataExpression");
                    }
                    List l = null;
                    try {
                        l = ExpressionCompilerUtil.extractColumnExpression(expr, "row");
                    }
                    catch (DataException dataException) {}
                    if (l != null) {
                        int j = 0;
                        while (j < l.size()) {
                            this.checkColumnBindingExist(name, l.get(j).toString(), list, baseQueryDefn);
                            ++j;
                        }
                    }
                    List usedBindings = null;
                    if (expr instanceof IScriptExpression) {
                        try {
                            usedBindings = ExpressionUtil.extractColumnExpressions((String)((IScriptExpression)expr).getText(), (String)"row");
                        }
                        catch (BirtException birtException) {
                            break block10;
                        }
                        this.validateReferredColumnBinding(name, usedBindings, baseQueryDefn);
                    }
                }
            }
            ++i;
        }
    }

    private void checkColumnBindingExist(String bindingName, String referName, List binding, IBaseQueryDefinition baseQueryDefn) throws DataException {
        if ("__rownum".equals(referName) || "_outer".equals(referName)) {
            return;
        }
        int i = 0;
        while (i < binding.size()) {
            if (referName.equals(binding.get(i).toString())) {
                return;
            }
            ++i;
        }
        this.validateInParentQuery(bindingName, baseQueryDefn, referName);
    }

    private void validateReferredColumnBinding(String bindingName, List usedBindings, IBaseQueryDefinition baseQueryDefn) throws DataException {
        List nameList = this.getColumnNames();
        int i = 0;
        while (i < usedBindings.size()) {
            String name;
            IColumnBinding cb = (IColumnBinding)usedBindings.get(i);
            if (!this.useDefinedKeyWord(cb) && !nameList.contains(name = ((IColumnBinding)usedBindings.get(i)).getResultSetColumnName()) && baseQueryDefn != null) {
                this.validateInParentQuery(bindingName, baseQueryDefn, name);
            }
            ++i;
        }
    }

    private void validateInParentQuery(String bindingName, IBaseQueryDefinition baseQueryDefn, String name) throws DataException {
        if (baseQueryDefn == null) {
            throw new DataException("data.engine.ColumnBindingReferToInexistBinding", new Object[]{bindingName, name});
        }
        String expr = this.findExpression(bindingName, name, baseQueryDefn.getParentQuery());
        if (expr == null) {
            throw new DataException("data.engine.ColumnBindingReferToInexistBinding", new Object[]{bindingName, name});
        }
        if (ExpressionUtil.hasAggregation((String)expr)) {
            throw new DataException("data.engine.ColumnBindingReferToAggregationColumnBindingInParentQuery", bindingName);
        }
    }

    private String findExpression(String bindingName, String referName, IBaseQueryDefinition queryDefn) throws DataException {
        if (queryDefn == null) {
            return null;
        }
        if (queryDefn.getBindings().get(referName) == null) {
            return this.findExpression(bindingName, referName, queryDefn.getParentQuery());
        }
        IBinding binding = (IBinding)queryDefn.getBindings().get(referName);
        if (binding.getAggrFunction() != null) {
            throw new DataException("data.engine.ColumnBindingReferToAggregationColumnBindingInParentQuery", bindingName);
        }
        IBaseExpression expr = binding.getExpression();
        if (expr instanceof IScriptExpression) {
            return ((IScriptExpression)expr).getText();
        }
        return null;
    }

    private boolean useDefinedKeyWord(IColumnBinding cb) {
        return cb.getOuterLevel() > 0 || cb.getResultSetColumnName().equals("__rownum") || cb.getResultSetColumnName().equals("_rowPosition");
    }

    private List getColumnNames() {
        List bindingExprs = this.exprManager.getBindingExprs();
        Map autoBindingExprMap = this.exprManager.getAutoBindingExprMap();
        ArrayList l = new ArrayList();
        l.addAll(autoBindingExprMap.keySet());
        int i = 0;
        while (i < bindingExprs.size()) {
            l.addAll(((GroupBindingColumn)bindingExprs.get(i)).getColumnNames());
            ++i;
        }
        return l;
    }

    private HashMap getGroupKeys() {
        List bindingExprs = this.exprManager.getBindingExprs();
        HashMap<Integer, String> l = new HashMap<Integer, String>();
        int i = 0;
        while (i < bindingExprs.size()) {
            String key = ((GroupBindingColumn)bindingExprs.get(i)).getGroupKey();
            Integer groupLevel = new Integer(((GroupBindingColumn)bindingExprs.get(i)).getGroupLevel());
            if (key != null) {
                l.put(groupLevel, key);
            }
            ++i;
        }
        return l;
    }
}

