/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.IQueryExecutor;
import org.eclipse.birt.data.engine.impl.OdaDataSourceRuntime;

public class OdaDataSetRuntime
extends DataSetRuntime {
    private String queryText;
    private Map publicProperties;
    private static Logger logger = Logger.getLogger(OdaDataSetRuntime.class.getName());

    OdaDataSetRuntime(IOdaDataSetDesign dataSet, IQueryExecutor executor, DataEngineSession session) {
        super(dataSet, executor, session);
        Object[] params = new Object[]{dataSet, executor};
        logger.entering(OdaDataSetRuntime.class.getName(), "OdaDataSetRuntime", params);
        this.queryText = dataSet.getQueryText();
        this.publicProperties = new HashMap();
        this.publicProperties.putAll(dataSet.getPublicProperties());
        logger.exiting(OdaDataSetRuntime.class.getName(), "OdaDataSetRuntime");
        logger.log(Level.FINER, "OdaDataSetRuntime starts up");
    }

    public IOdaDataSetDesign getSubdesign() {
        return (IOdaDataSetDesign)this.getDesign();
    }

    public OdaDataSourceRuntime getExtendedDataSource() {
        assert (this.getDataSource() instanceof OdaDataSourceRuntime);
        return (OdaDataSourceRuntime)this.getDataSource();
    }

    public String getQueryText() {
        return this.queryText;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public String getExtensionID() {
        return this.getSubdesign().getExtensionID();
    }

    public String getPrimaryResultSetName() {
        return this.getSubdesign().getPrimaryResultSetName();
    }

    public Map getPublicProperties() {
        return this.publicProperties;
    }

    public Map getPrivateProperties() {
        return this.getSubdesign().getPrivateProperties();
    }

    public Map getAllExtensionProperties() {
        return this.publicProperties;
    }

    public String getExtensionProperty(String name) {
        return (String)this.publicProperties.get(name);
    }

    public void setExtensionProperty(String name, String value) {
        this.publicProperties.put(name, value);
    }
}

